/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.invoker;

import groovy.lang.Binding;
import groovy.lang.GroovyShell;
import java.io.File;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.maven.plugin.invoker.ScriptEvaluationException;
import org.apache.maven.plugin.invoker.ScriptInterpreter;
import org.apache.tools.ant.AntClassLoader;
import org.codehaus.groovy.control.CompilerConfiguration;

class GroovyScriptInterpreter
implements ScriptInterpreter {
    GroovyScriptInterpreter() {
    }

    public Object evaluateScript(String script, List classPath, Map globalVariables, PrintStream scriptOutput) throws ScriptEvaluationException {
        PrintStream origOut = System.out;
        PrintStream origErr = System.err;
        try {
            Object path;
            CompilerConfiguration config = new CompilerConfiguration(CompilerConfiguration.DEFAULT);
            if (scriptOutput != null) {
                System.setErr(scriptOutput);
                System.setOut(scriptOutput);
                config.setOutput(new PrintWriter(scriptOutput));
            }
            AntClassLoader loader = null;
            if (classPath != null && !classPath.isEmpty()) {
                AntClassLoader childFirstLoader = new AntClassLoader(this.getClass().getClassLoader(), false);
                Iterator it = classPath.iterator();
                while (it.hasNext()) {
                    path = (String)it.next();
                    childFirstLoader.addPathComponent(new File((String)path));
                }
                loader = childFirstLoader;
            }
            Binding binding = new Binding(globalVariables);
            GroovyShell interpreter = new GroovyShell(loader, binding, config);
            try {
                path = interpreter.evaluate(script);
                return path;
            }
            catch (Exception e) {
                throw new ScriptEvaluationException(e);
            }
        }
        finally {
            System.setErr(origErr);
            System.setOut(origOut);
        }
    }
}

