/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.ear;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.ear.AbstractEarMojo;
import org.apache.maven.plugin.ear.ApplicationXmlWriter;
import org.apache.maven.plugin.ear.EarPluginException;
import org.apache.maven.plugin.ear.SecurityRole;
import org.codehaus.plexus.configuration.PlexusConfiguration;
import org.codehaus.plexus.configuration.PlexusConfigurationException;
import org.codehaus.plexus.util.FileUtils;

public class GenerateApplicationXmlMojo
extends AbstractEarMojo {
    public static final String VERSION_1_3 = "1.3";
    public static final String VERSION_1_4 = "1.4";
    public static final String VERSION_5 = "5";
    public static final String UTF_8 = "UTF-8";
    private Boolean generateApplicationXml = Boolean.TRUE;
    private String version = "1.3";
    private String displayName = null;
    private String description = null;
    private String encoding = "UTF-8";
    private PlexusConfiguration security;
    private String generatedDescriptorLocation;

    public void execute() throws MojoExecutionException, MojoFailureException {
        super.execute();
        if (!this.generateApplicationXml.booleanValue()) {
            this.getLog().debug((CharSequence)"Generation of application.xml is disabled");
            return;
        }
        if (!(this.version.equals(VERSION_1_3) || this.version.equals(VERSION_1_4) || this.version.equals(VERSION_5))) {
            throw new MojoExecutionException("Invalid version[" + this.version + "]");
        }
        this.getLog().info((CharSequence)"Generating application.xml");
        try {
            this.generateDeploymentDescriptor();
        }
        catch (EarPluginException e) {
            throw new MojoExecutionException("Failed to generate application.xml", (Exception)e);
        }
        try {
            FileUtils.copyFileToDirectory((File)new File(this.generatedDescriptorLocation, "application.xml"), (File)new File(this.getWorkDirectory(), "META-INF"));
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to copy application.xml to final destination", (Exception)e);
        }
    }

    protected void generateDeploymentDescriptor() throws EarPluginException {
        File outputDir = new File(this.generatedDescriptorLocation);
        if (!outputDir.exists()) {
            outputDir.mkdirs();
        }
        File descriptor = new File(outputDir, "application.xml");
        ApplicationXmlWriter writer = new ApplicationXmlWriter(this.version, this.encoding);
        writer.write(descriptor, this.getModules(), this.buildSecurityRoles(), this.displayName, this.description);
    }

    private List buildSecurityRoles() throws EarPluginException {
        ArrayList<SecurityRole> result = new ArrayList<SecurityRole>();
        if (this.security == null) {
            return result;
        }
        try {
            PlexusConfiguration[] securityRoles = this.security.getChildren("security-role");
            for (int i = 0; i < securityRoles.length; ++i) {
                PlexusConfiguration securityRole = securityRoles[i];
                String id = securityRole.getAttribute("id");
                String roleName = securityRole.getChild("role-name").getValue();
                String roleNameId = securityRole.getChild("role-name").getAttribute("id");
                String description = securityRole.getChild("description").getValue();
                String descriptionId = securityRole.getChild("description").getAttribute("id");
                if (roleName == null) {
                    throw new EarPluginException("Invalid security-role configuration, role-name could not be null.");
                }
                result.add(new SecurityRole(roleName, roleNameId, id, description, descriptionId));
            }
            return result;
        }
        catch (PlexusConfigurationException e) {
            throw new EarPluginException("Invalid security-role configuration", e);
        }
    }
}

