/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.ear;

import java.util.Iterator;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.ear.ArtifactTypeMappingService;
import org.apache.maven.plugin.ear.EarModule;
import org.apache.maven.plugin.ear.EarPluginException;
import org.codehaus.plexus.util.xml.XMLWriter;

public abstract class AbstractEarModule
implements EarModule {
    protected static final String MODULE_ELEMENT = "module";
    private String uri;
    private Artifact artifact;
    private String groupId;
    private String artifactId;
    protected String bundleDir;
    protected String bundleFileName;
    protected Boolean excluded = Boolean.FALSE;

    public AbstractEarModule() {
    }

    public AbstractEarModule(Artifact a) {
        this.artifact = a;
        this.groupId = a.getGroupId();
        this.artifactId = a.getArtifactId();
        this.bundleDir = null;
    }

    public void resolveArtifact(Set artifacts, String defaultJavaBundleDir) throws EarPluginException, MojoFailureException {
        if (this.artifact == null) {
            if (this.groupId == null || this.artifactId == null) {
                throw new MojoFailureException("Could not resolve artifact[" + this.groupId + ":" + this.artifactId + ":" + this.getType() + "]");
            }
            Iterator i = artifacts.iterator();
            while (i.hasNext()) {
                Artifact a = (Artifact)i.next();
                if (!a.getGroupId().equals(this.groupId) || !a.getArtifactId().equals(this.artifactId) || !ArtifactTypeMappingService.getInstance().isMappedToType(this.getType(), a.getType())) continue;
                this.artifact = a;
                return;
            }
            throw new MojoFailureException("Artifact[" + this.groupId + ":" + this.artifactId + ":" + this.getType() + "] " + "is not a dependency of the project.");
        }
    }

    protected abstract String getType();

    public Artifact getArtifact() {
        return this.artifact;
    }

    public String getUri() {
        if (this.uri == null) {
            this.uri = this.getBundleDir() == null ? this.getBundleFileName() : this.getBundleDir() + this.getBundleFileName();
        }
        return this.uri;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getBundleDir() {
        if (this.bundleDir != null) {
            this.bundleDir = AbstractEarModule.cleanBundleDir(this.bundleDir);
        }
        return this.bundleDir;
    }

    public String getBundleFileName() {
        if (this.bundleFileName == null) {
            this.bundleFileName = this.artifact.getFile().getName();
        }
        return this.bundleFileName;
    }

    public boolean isExcluded() {
        return this.excluded;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getType()).append(":").append(this.groupId).append(":").append(this.artifactId);
        if (this.artifact != null) {
            sb.append(":").append(this.artifact.getVersion());
        }
        return sb.toString();
    }

    static String cleanBundleDir(String bundleDir) {
        if (bundleDir == null) {
            return bundleDir;
        }
        if ((bundleDir = bundleDir.replace('\\', '/')).startsWith("/")) {
            bundleDir = bundleDir.substring(1, bundleDir.length());
        }
        if (bundleDir.length() > 0 && !bundleDir.endsWith("/")) {
            bundleDir = bundleDir + "/";
        }
        return bundleDir;
    }

    public abstract /* synthetic */ void appendModule(XMLWriter var1, String var2);
}

