/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.doap.options;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.plugin.doap.options.Standard;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ASFExtOptions
implements Serializable {
    private String xmlnsPrefix = "asfext";
    private String xmlnsNamespaceURI = "http://projects.apache.org/ns/asfext#";
    private boolean included = false;
    private String pmc = "${project.url}";
    private String name = "${project.name}";
    private String charter;
    private String chair;
    private List<Standard> standards;
    private Map extra;

    public void addExtra(Object key, String value) {
        this.getExtra().put(key, value);
    }

    public void addStandard(Standard standard) {
        this.getStandards().add(standard);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ASFExtOptions)) {
            return false;
        }
        ASFExtOptions that = (ASFExtOptions)other;
        boolean result = true;
        boolean bl = result = result && this.included == that.included;
        boolean bl2 = result && (this.getPmc() == null ? that.getPmc() == null : this.getPmc().equals(that.getPmc())) ? true : (result = false);
        boolean bl3 = result && (this.getName() == null ? that.getName() == null : this.getName().equals(that.getName())) ? true : (result = false);
        boolean bl4 = result && (this.getCharter() == null ? that.getCharter() == null : this.getCharter().equals(that.getCharter())) ? true : (result = false);
        boolean bl5 = result && (this.getChair() == null ? that.getChair() == null : this.getChair().equals(that.getChair())) ? true : (result = false);
        result = result && (this.getExtra() == null ? that.getExtra() == null : ((Object)this.getExtra()).equals(that.getExtra()));
        return result;
    }

    public String getChair() {
        return this.chair;
    }

    public String getCharter() {
        return this.charter;
    }

    public Map getExtra() {
        if (this.extra == null) {
            this.extra = new HashMap();
        }
        return this.extra;
    }

    public String getName() {
        return this.name;
    }

    public String getPmc() {
        return this.pmc;
    }

    public List<Standard> getStandards() {
        if (this.standards == null) {
            this.standards = new ArrayList<Standard>();
        }
        return this.standards;
    }

    public String getXmlnsNamespaceURI() {
        return this.xmlnsNamespaceURI;
    }

    public String getXmlnsPrefix() {
        return this.xmlnsPrefix;
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + (this.included ? 0 : 1);
        result = 37 * result + (this.pmc != null ? this.pmc.hashCode() : 0);
        result = 37 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 37 * result + (this.charter != null ? this.charter.hashCode() : 0);
        result = 37 * result + (this.chair != null ? this.chair.hashCode() : 0);
        result = 37 * result + (this.extra != null ? ((Object)this.extra).hashCode() : 0);
        return result;
    }

    public boolean isIncluded() {
        return this.included;
    }

    public void removeStandard(Standard standard) {
        this.getStandards().remove(standard);
    }

    public void setChair(String chair) {
        this.chair = chair;
    }

    public void setCharter(String charter) {
        this.charter = charter;
    }

    public void setExtra(Map extra) {
        this.extra = extra;
    }

    public void setIncluded(boolean included) {
        this.included = included;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setPmc(String pmc) {
        this.pmc = pmc;
    }

    public void setStandards(List<Standard> standards) {
        this.standards = standards;
    }

    public void setXmlnsNamespaceURI(String xmlnsNamespaceURI) {
        this.xmlnsNamespaceURI = xmlnsNamespaceURI;
    }

    public void setXmlnsPrefix(String xmlnsPrefix) {
        this.xmlnsPrefix = xmlnsPrefix;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(128);
        buf.append("included = '");
        buf.append(this.isIncluded());
        buf.append("'");
        buf.append("\n");
        buf.append("pmc = '");
        buf.append(this.getPmc());
        buf.append("'");
        buf.append("\n");
        buf.append("name = '");
        buf.append(this.getName());
        buf.append("'");
        buf.append("\n");
        buf.append("charter = '");
        buf.append(this.getCharter());
        buf.append("'");
        buf.append("\n");
        buf.append("chair = '");
        buf.append(this.getChair());
        buf.append("'");
        buf.append("\n");
        buf.append("extra = '");
        buf.append(this.getExtra());
        buf.append("'");
        return buf.toString();
    }
}

