/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.dependency;

import java.util.List;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.dependency.utils.DependencySilentLog;
import org.apache.maven.project.DefaultProjectBuildingRequest;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuildingRequest;
import org.sonatype.plexus.build.incremental.BuildContext;

public abstract class AbstractDependencyMojo
extends AbstractMojo {
    @Component
    private BuildContext buildContext;
    @Parameter(defaultValue="false")
    private boolean skipDuringIncrementalBuild;
    @Component
    private MavenProject project;
    @Parameter(defaultValue="${project.remoteArtifactRepositories}", readonly=true, required=true)
    private List<ArtifactRepository> remoteRepositories;
    @Parameter(defaultValue="${project.pluginArtifactRepositories}", readonly=true, required=true)
    private List<ArtifactRepository> remotePluginRepositories;
    @Parameter(defaultValue="${reactorProjects}", readonly=true)
    protected List<MavenProject> reactorProjects;
    @Component
    protected MavenSession session;
    @Parameter(property="silent", defaultValue="false")
    private boolean silent;
    @Parameter(property="mdep.skip", defaultValue="false")
    private boolean skip;

    public final void execute() throws MojoExecutionException, MojoFailureException {
        if (this.isSkip()) {
            this.getLog().info((CharSequence)"Skipping plugin execution");
            return;
        }
        this.doExecute();
    }

    protected abstract void doExecute() throws MojoExecutionException, MojoFailureException;

    public ProjectBuildingRequest newResolveArtifactProjectBuildingRequest() {
        return this.newProjectBuildingRequest(this.remoteRepositories);
    }

    protected ProjectBuildingRequest newResolvePluginProjectBuildingRequest() {
        return this.newProjectBuildingRequest(this.remotePluginRepositories);
    }

    private ProjectBuildingRequest newProjectBuildingRequest(List<ArtifactRepository> repositories) {
        DefaultProjectBuildingRequest buildingRequest = new DefaultProjectBuildingRequest(this.session.getProjectBuildingRequest());
        buildingRequest.setRemoteRepositories(repositories);
        return buildingRequest;
    }

    public MavenProject getProject() {
        return this.project;
    }

    public boolean isSkip() {
        if (this.skipDuringIncrementalBuild && this.buildContext.isIncremental()) {
            return true;
        }
        return this.skip;
    }

    public void setSkip(boolean skip) {
        this.skip = skip;
    }

    protected final boolean isSilent() {
        return this.silent;
    }

    public void setSilent(boolean silent) {
        this.silent = silent;
        if (silent) {
            this.setLog(new DependencySilentLog());
        }
    }
}

