/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.trac;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;

public class TracTicket {
    private String id;
    private String link;
    private Date timeCreated;
    private Date timeChanged;
    private String type;
    private String summary;
    private String status;
    private String resolution;
    private String milestone;
    private String owner;
    private String priority;
    private String reporter;
    private String component;

    public String getComponent() {
        return this.component;
    }

    public void setComponent(String component) {
        this.component = component;
    }

    public String getPriority() {
        return this.priority;
    }

    public void setPriority(String priority) {
        this.priority = priority;
    }

    public String getReporter() {
        return this.reporter;
    }

    public void setReporter(String reporter) {
        this.reporter = reporter;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getMilestone() {
        return this.milestone;
    }

    public void setMilestone(String milestone) {
        this.milestone = milestone;
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public String getResolution() {
        return this.resolution;
    }

    public void setResolution(String resolution) {
        this.resolution = resolution;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getSummary() {
        return this.summary;
    }

    public void setSummary(String summary) {
        this.summary = summary;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Date getTimeChanged() {
        return this.timeChanged;
    }

    public void setTimeChanged(String timeChanged) {
        this.timeChanged = this.parseDate(timeChanged);
    }

    public Date getTimeCreated() {
        return this.timeCreated;
    }

    public void setTimeCreated(String timeCreated) {
        this.timeCreated = this.parseDate(timeCreated);
    }

    private Date parseDate(String timeCreated) throws RuntimeException {
        try {
            long millis = Long.parseLong(timeCreated);
            Calendar cld = Calendar.getInstance();
            cld.setTimeInMillis(millis * 1000L);
            return cld.getTime();
        }
        catch (NumberFormatException e) {
            SimpleDateFormat format = new SimpleDateFormat("EEE MMM dd HH:mm:ss z yyyy", Locale.ENGLISH);
            try {
                return format.parse(timeCreated);
            }
            catch (ParseException e1) {
                throw new RuntimeException("Failed to parse date '" + timeCreated + "' as a date.", e1);
            }
        }
    }

    public String getLink() {
        return this.link;
    }

    public void setLink(String link) {
        this.link = link;
    }
}

