/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.jira;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.jira.JiraIssue;
import org.apache.maven.plugin.jira.JiraXML;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.reporting.MavenReportException;

public class JiraReportGenerator {
    private static final int COLUMN_KEY = 0;
    private static final int COLUMN_SUMMARY = 1;
    private static final int COLUMN_STATUS = 2;
    private static final int COLUMN_RESOLUTION = 3;
    private static final int COLUMN_ASSIGNEE = 4;
    private static final int COLUMN_REPORTER = 5;
    private static final int COLUMN_TYPE = 6;
    private static final int COLUMN_PRIORITY = 7;
    private static final int COLUMN_VERSION = 8;
    private static final int COLUMN_FIX_VERSION = 9;
    private static final int COLUMN_COMPONENT = 10;
    private static final String[] JIRA_COLUMNS = new String[]{"Key", "Summary", "Status", "Resolution", "Assignee", "Reporter", "Type", "Priority", "Version", "Fix Version", "Component"};
    private static final String SNAPSHOT_SUFFIX = "-SNAPSHOT";
    private int[] columnOrder;
    private String currentVersion = null;
    private JiraXML jira;
    private boolean onlyCurrentVersion = false;

    public JiraReportGenerator() {
    }

    public JiraReportGenerator(File xmlFile, String columnNames, String currentVersion, boolean onlyCurrentVersion) throws MavenReportException {
        this.currentVersion = currentVersion;
        this.onlyCurrentVersion = onlyCurrentVersion;
        this.jira = new JiraXML(xmlFile);
        String[] columnNamesArray = columnNames.split(",");
        int validColumnNames = 0;
        this.columnOrder = new int[columnNamesArray.length];
        block0: for (int i = 0; i < this.columnOrder.length; ++i) {
            this.columnOrder[i] = -1;
            for (int columnIndex = 0; columnIndex < JIRA_COLUMNS.length; ++columnIndex) {
                String columnName = columnNamesArray[i].trim();
                if (!JIRA_COLUMNS[columnIndex].equalsIgnoreCase(columnName)) continue;
                this.columnOrder[i] = columnIndex;
                ++validColumnNames;
                continue block0;
            }
        }
        if (validColumnNames == 0) {
            throw new MavenReportException("maven-changes-plugin: None of the configured columnNames '" + columnNames + "' are valid.");
        }
    }

    public void doGenerateEmptyReport(ResourceBundle bundle, Sink sink) {
        this.sinkBeginReport(sink, bundle);
        sink.paragraph();
        sink.text(bundle.getString("report.jira.error"));
        sink.paragraph_();
        this.sinkEndReport(sink);
    }

    public void doGenerateReport(ResourceBundle bundle, Sink sink, Log log) throws MojoExecutionException {
        List issueList = this.jira.getIssueList();
        if (this.onlyCurrentVersion) {
            issueList = this.getIssuesForCurrentRelease(issueList);
            log.info((CharSequence)"The JIRA Report will contain issues only for the current version.");
        }
        this.sinkBeginReport(sink, bundle);
        this.constructHeaderRow(sink, issueList, bundle);
        this.constructDetailRows(sink, issueList);
        this.sinkEndReport(sink);
    }

    private void constructHeaderRow(Sink sink, List issueList, ResourceBundle bundle) {
        if (issueList == null) {
            return;
        }
        sink.table();
        sink.tableRow();
        block13: for (int columnIndex = 0; columnIndex < this.columnOrder.length; ++columnIndex) {
            switch (this.columnOrder[columnIndex]) {
                case 0: {
                    this.sinkHeader(sink, bundle.getString("report.jira.label.key"));
                    continue block13;
                }
                case 1: {
                    this.sinkHeader(sink, bundle.getString("report.jira.label.summary"));
                    continue block13;
                }
                case 2: {
                    this.sinkHeader(sink, bundle.getString("report.jira.label.status"));
                    continue block13;
                }
                case 3: {
                    this.sinkHeader(sink, bundle.getString("report.jira.label.resolution"));
                    continue block13;
                }
                case 4: {
                    this.sinkHeader(sink, bundle.getString("report.jira.label.by"));
                    continue block13;
                }
                case 5: {
                    this.sinkHeader(sink, bundle.getString("report.jira.label.reporter"));
                    continue block13;
                }
                case 6: {
                    this.sinkHeader(sink, bundle.getString("report.jira.label.type"));
                    continue block13;
                }
                case 7: {
                    this.sinkHeader(sink, bundle.getString("report.jira.label.priority"));
                    continue block13;
                }
                case 8: {
                    this.sinkHeader(sink, bundle.getString("report.jira.label.version"));
                    continue block13;
                }
                case 9: {
                    this.sinkHeader(sink, bundle.getString("report.jira.label.fixVersion"));
                    continue block13;
                }
                case 10: {
                    this.sinkHeader(sink, bundle.getString("report.jira.label.component"));
                    continue block13;
                }
            }
        }
        sink.tableRow_();
    }

    private void constructDetailRows(Sink sink, List issueList) {
        if (issueList == null) {
            return;
        }
        for (int idx = 0; idx < issueList.size(); ++idx) {
            JiraIssue issue = (JiraIssue)issueList.get(idx);
            sink.tableRow();
            block14: for (int columnIndex = 0; columnIndex < this.columnOrder.length; ++columnIndex) {
                switch (this.columnOrder[columnIndex]) {
                    case 0: {
                        sink.tableCell();
                        sink.link(issue.getLink());
                        sink.text(issue.getKey());
                        sink.link_();
                        sink.tableCell_();
                        continue block14;
                    }
                    case 1: {
                        this.sinkCell(sink, issue.getSummary());
                        continue block14;
                    }
                    case 2: {
                        this.sinkCell(sink, issue.getStatus());
                        continue block14;
                    }
                    case 3: {
                        this.sinkCell(sink, issue.getResolution());
                        continue block14;
                    }
                    case 4: {
                        this.sinkCell(sink, issue.getAssignee());
                        continue block14;
                    }
                    case 5: {
                        this.sinkCell(sink, issue.getReporter());
                        continue block14;
                    }
                    case 6: {
                        this.sinkCell(sink, issue.getType());
                        continue block14;
                    }
                    case 7: {
                        this.sinkCell(sink, issue.getPriority());
                        continue block14;
                    }
                    case 8: {
                        this.sinkCell(sink, issue.getVersion());
                        continue block14;
                    }
                    case 9: {
                        this.sinkCell(sink, issue.getFixVersion());
                        continue block14;
                    }
                    case 10: {
                        this.sinkCell(sink, issue.getComponent());
                        continue block14;
                    }
                }
            }
            sink.tableRow_();
        }
        sink.table_();
    }

    private void sinkBeginReport(Sink sink, ResourceBundle bundle) {
        sink.head();
        sink.title();
        sink.text(bundle.getString("report.jira.header"));
        sink.title_();
        sink.head_();
        sink.body();
        sink.section1();
        this.sinkSectionTitle1(sink, bundle.getString("report.jira.header"));
    }

    private void sinkEndReport(Sink sink) {
        sink.section1_();
        sink.body_();
        sink.flush();
        sink.close();
    }

    private void sinkFigure(Sink sink, String image) {
        sink.figure();
        sink.figureGraphics(image);
        sink.figure_();
    }

    private void sinkHeader(Sink sink, String header) {
        sink.tableHeaderCell();
        sink.text(header);
        sink.tableHeaderCell_();
    }

    private void sinkCell(Sink sink, String text) {
        sink.tableCell();
        if (text != null) {
            sink.text(text);
        } else {
            sink.rawText("&nbsp;");
        }
        sink.tableCell_();
    }

    private void sinkSectionTitle1(Sink sink, String text) {
        sink.sectionTitle1();
        sink.text(text);
        sink.sectionTitle1_();
    }

    public List getIssuesForCurrentRelease(List allIssues) throws MojoExecutionException {
        ArrayList<JiraIssue> currentReleaseIssues = new ArrayList<JiraIssue>();
        boolean isFound = false;
        JiraIssue issue = null;
        String releaseVersion = this.currentVersion;
        if (this.currentVersion != null && this.currentVersion.endsWith(SNAPSHOT_SUFFIX)) {
            releaseVersion = this.currentVersion.substring(0, this.currentVersion.length() - SNAPSHOT_SUFFIX.length());
        }
        for (int i = 0; i < allIssues.size(); ++i) {
            issue = (JiraIssue)allIssues.get(i);
            if (issue.getFixVersion() == null || !issue.getFixVersion().equals(releaseVersion)) continue;
            isFound = true;
            currentReleaseIssues.add(issue);
        }
        if (!isFound) {
            throw new MojoExecutionException("Couldn't find any issues for the version '" + releaseVersion + "' among the supplied issues.");
        }
        return currentReleaseIssues;
    }
}

