/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.model.building;

import org.apache.maven.model.Model;
import org.apache.maven.model.building.ModelProblem;
import org.apache.maven.model.building.ModelProblemUtils;

public class DefaultModelProblem
implements ModelProblem {
    private final String source;
    private final int lineNumber;
    private final int columnNumber;
    private final String modelId;
    private final String message;
    private final Exception exception;
    private final ModelProblem.Severity severity;

    public DefaultModelProblem(String message, ModelProblem.Severity severity, Model source, int lineNumber, int columnNumber, Exception exception) {
        this(message, severity, ModelProblemUtils.toPath(source), lineNumber, columnNumber, ModelProblemUtils.toId(source), exception);
    }

    public DefaultModelProblem(String message, ModelProblem.Severity severity, String source, int lineNumber, int columnNumber, String modelId, Exception exception) {
        this.message = message;
        this.severity = severity != null ? severity : ModelProblem.Severity.ERROR;
        this.source = source != null ? source : "";
        this.lineNumber = lineNumber;
        this.columnNumber = columnNumber;
        this.modelId = modelId != null ? modelId : "";
        this.exception = exception;
    }

    public String getSource() {
        return this.source;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public int getColumnNumber() {
        return this.columnNumber;
    }

    public String getModelId() {
        return this.modelId;
    }

    public String getLocation() {
        StringBuilder buffer = new StringBuilder(256);
        buffer.append(this.getModelId());
        if (this.getSource().length() > 0) {
            if (buffer.length() > 0) {
                buffer.append(", ");
            }
            buffer.append(this.getSource());
        }
        if (this.getLineNumber() > 0) {
            if (buffer.length() > 0) {
                buffer.append(", ");
            }
            buffer.append("line ").append(this.getLineNumber());
        }
        if (this.getColumnNumber() > 0) {
            if (buffer.length() > 0) {
                buffer.append(", ");
            }
            buffer.append("column ").append(this.getColumnNumber());
        }
        return buffer.toString();
    }

    public Exception getException() {
        return this.exception;
    }

    public String getMessage() {
        String msg;
        if (this.message != null && this.message.length() > 0) {
            msg = this.message;
        } else {
            msg = this.exception.getMessage();
            if (msg == null) {
                msg = "";
            }
        }
        return msg;
    }

    public ModelProblem.Severity getSeverity() {
        return this.severity;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder(128);
        buffer.append("[").append((Object)this.getSeverity()).append("] ");
        buffer.append(this.getMessage());
        buffer.append(" @ ").append(this.getLocation());
        return buffer.toString();
    }
}

