/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.archiver;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.maven.archiver.ManifestConfiguration;
import org.apache.maven.archiver.ManifestSection;
import org.apache.maven.archiver.MavenArchiveConfiguration;
import org.apache.maven.archiver.PomPropertiesUtil;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.archiver.Archiver;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.jar.JarArchiver;
import org.codehaus.plexus.archiver.jar.Manifest;
import org.codehaus.plexus.archiver.jar.ManifestException;
import org.codehaus.plexus.interpolation.InterpolationException;
import org.codehaus.plexus.interpolation.PrefixAwareRecursionInterceptor;
import org.codehaus.plexus.interpolation.PrefixedObjectValueSource;
import org.codehaus.plexus.interpolation.PrefixedPropertiesValueSource;
import org.codehaus.plexus.interpolation.RecursionInterceptor;
import org.codehaus.plexus.interpolation.StringSearchInterpolator;
import org.codehaus.plexus.interpolation.ValueSource;
import org.codehaus.plexus.util.StringUtils;

public class MavenArchiver {
    public static final String SIMPLE_LAYOUT = "${artifact.artifactId}-${artifact.version}${dashClassifier?}.${artifact.extension}";
    public static final String REPOSITORY_LAYOUT = "${artifact.groupIdPath}/${artifact.artifactId}/${artifact.baseVersion}/${artifact.artifactId}-${artifact.version}${dashClassifier?}.${artifact.extension}";
    public static final String SIMPLE_LAYOUT_NONUNIQUE = "${artifact.artifactId}-${artifact.baseVersion}${dashClassifier?}.${artifact.extension}";
    public static final String REPOSITORY_LAYOUT_NONUNIQUE = "${artifact.groupIdPath}/${artifact.artifactId}/${artifact.baseVersion}/${artifact.artifactId}-${artifact.baseVersion}${dashClassifier?}.${artifact.extension}";
    private static final List ARTIFACT_EXPRESSION_PREFIXES;
    private JarArchiver archiver;
    private File archiveFile;

    public Manifest getManifest(MavenProject project, MavenArchiveConfiguration config) throws ManifestException, DependencyResolutionRequiredException {
        Iterator<Object> iter;
        boolean hasManifestEntries = !config.isManifestEntriesEmpty();
        Map entries = hasManifestEntries ? config.getManifestEntries() : Collections.EMPTY_MAP;
        Manifest manifest = this.getManifest(project, config.getManifest(), entries);
        if (hasManifestEntries) {
            Set keys = entries.keySet();
            iter = keys.iterator();
            while (iter.hasNext()) {
                String key = (String)iter.next();
                String value = (String)entries.get(key);
                Manifest.Attribute attr = manifest.getMainSection().getAttribute(key);
                if (key.equals("Class-Path") && attr != null) {
                    attr.setValue(value + " " + attr.getValue());
                    continue;
                }
                this.addManifestAttribute(manifest, key, value);
            }
        }
        if (!config.isManifestSectionsEmpty()) {
            List sections = config.getManifestSections();
            iter = sections.iterator();
            while (iter.hasNext()) {
                ManifestSection section = (ManifestSection)iter.next();
                Manifest.Section theSection = new Manifest.Section();
                theSection.setName(section.getName());
                if (!section.isManifestEntriesEmpty()) {
                    Map sectionEntries = section.getManifestEntries();
                    Set keys = sectionEntries.keySet();
                    Iterator it = keys.iterator();
                    while (it.hasNext()) {
                        String key = (String)it.next();
                        String value = (String)sectionEntries.get(key);
                        Manifest.Attribute attr = new Manifest.Attribute(key, value);
                        theSection.addConfiguredAttribute(attr);
                    }
                }
                manifest.addConfiguredSection(theSection);
            }
        }
        return manifest;
    }

    public Manifest getManifest(MavenProject project, ManifestConfiguration config) throws ManifestException, DependencyResolutionRequiredException {
        return this.getManifest(project, config, Collections.EMPTY_MAP);
    }

    private void addManifestAttribute(Manifest manifest, Map map, String key, String value) throws ManifestException {
        if (map.containsKey(key)) {
            return;
        }
        this.addManifestAttribute(manifest, key, value);
    }

    private void addManifestAttribute(Manifest manifest, String key, String value) throws ManifestException {
        if (!StringUtils.isEmpty((String)value)) {
            Manifest.Attribute attr = new Manifest.Attribute(key, value);
            manifest.addConfiguredAttribute(attr);
        } else {
            Manifest.Attribute attr = new Manifest.Attribute(key, "");
            manifest.addConfiguredAttribute(attr);
        }
    }

    protected Manifest getManifest(MavenProject project, ManifestConfiguration config, Map entries) throws ManifestException, DependencyResolutionRequiredException {
        String mainClass;
        Manifest m = new Manifest();
        this.addManifestAttribute(m, entries, "Created-By", "Apache Maven");
        this.addCustomEntries(m, entries, config);
        if (config.isAddClasspath()) {
            StringBuffer classpath = new StringBuffer();
            List artifacts = project.getRuntimeClasspathElements();
            String classpathPrefix = config.getClasspathPrefix();
            String layoutType = config.getClasspathLayoutType();
            String layout = config.getCustomClasspathLayout();
            StringSearchInterpolator interpolator = new StringSearchInterpolator();
            Iterator iter = artifacts.iterator();
            while (iter.hasNext()) {
                File f = new File((String)iter.next());
                if (!f.getAbsoluteFile().isFile()) continue;
                Artifact artifact = this.findArtifactWithFile(project.getArtifacts(), f);
                if (classpath.length() > 0) {
                    classpath.append(" ");
                }
                classpath.append(classpathPrefix);
                if (artifact == null || layoutType == null) {
                    classpath.append(f.getName());
                    continue;
                }
                ArrayList<Object> valueSources = new ArrayList<Object>();
                valueSources.add(new PrefixedObjectValueSource(ARTIFACT_EXPRESSION_PREFIXES, (Object)artifact, true));
                valueSources.add(new PrefixedObjectValueSource(ARTIFACT_EXPRESSION_PREFIXES, (Object)(artifact == null ? null : artifact.getArtifactHandler()), true));
                Properties extraExpressions = new Properties();
                if (artifact != null) {
                    if (!artifact.isSnapshot()) {
                        extraExpressions.setProperty("baseVersion", artifact.getVersion());
                    }
                    extraExpressions.setProperty("groupIdPath", artifact.getGroupId().replace('.', '/'));
                    if (StringUtils.isNotEmpty((String)artifact.getClassifier())) {
                        extraExpressions.setProperty("dashClassifier", "-" + artifact.getClassifier());
                        extraExpressions.setProperty("dashClassifier?", "-" + artifact.getClassifier());
                    } else {
                        extraExpressions.setProperty("dashClassifier", "");
                        extraExpressions.setProperty("dashClassifier?", "");
                    }
                }
                valueSources.add(new PrefixedPropertiesValueSource(ARTIFACT_EXPRESSION_PREFIXES, extraExpressions, true));
                Iterator it = valueSources.iterator();
                while (it.hasNext()) {
                    ValueSource vs = (ValueSource)it.next();
                    interpolator.addValueSource(vs);
                }
                PrefixAwareRecursionInterceptor recursionInterceptor = new PrefixAwareRecursionInterceptor((Collection)ARTIFACT_EXPRESSION_PREFIXES);
                try {
                    if ("simple".equals(layoutType)) {
                        if (config.isUseUniqueVersions()) {
                            classpath.append(interpolator.interpolate(SIMPLE_LAYOUT, (RecursionInterceptor)recursionInterceptor));
                            continue;
                        }
                        classpath.append(interpolator.interpolate(SIMPLE_LAYOUT_NONUNIQUE, (RecursionInterceptor)recursionInterceptor));
                        continue;
                    }
                    if ("repository".equals(layoutType)) {
                        if (config.isUseUniqueVersions()) {
                            classpath.append(interpolator.interpolate(REPOSITORY_LAYOUT, (RecursionInterceptor)recursionInterceptor));
                            continue;
                        }
                        classpath.append(interpolator.interpolate(REPOSITORY_LAYOUT_NONUNIQUE, (RecursionInterceptor)recursionInterceptor));
                        continue;
                    }
                    if ("custom".equals(layoutType)) {
                        if (layout == null) {
                            throw new ManifestException("custom layout type was declared, but custom layout expression was not specified. Check your <archive><manifest><customLayout/> element.");
                        }
                        classpath.append(interpolator.interpolate(layout, (RecursionInterceptor)recursionInterceptor));
                        continue;
                    }
                    throw new ManifestException("Unknown classpath layout type: '" + layoutType + "'. Check your <archive><manifest><layoutType/> element.");
                }
                catch (InterpolationException e) {
                    ManifestException error = new ManifestException("Error interpolating artifact path for classpath entry: " + e.getMessage());
                    error.initCause((Throwable)e);
                    throw error;
                }
                finally {
                    Iterator it2 = valueSources.iterator();
                    while (it2.hasNext()) {
                        ValueSource vs = (ValueSource)it2.next();
                        interpolator.removeValuesSource(vs);
                    }
                }
            }
            if (classpath.length() > 0) {
                this.addManifestAttribute(m, "Class-Path", classpath.toString());
            }
        }
        if (config.isAddDefaultSpecificationEntries()) {
            this.addManifestAttribute(m, entries, "Specification-Title", project.getName());
            this.addManifestAttribute(m, entries, "Specification-Version", project.getVersion());
            if (project.getOrganization() != null) {
                this.addManifestAttribute(m, entries, "Specification-Vendor", project.getOrganization().getName());
            }
        }
        if (config.isAddDefaultImplementationEntries()) {
            this.addManifestAttribute(m, entries, "Implementation-Title", project.getName());
            this.addManifestAttribute(m, entries, "Implementation-Version", project.getVersion());
            this.addManifestAttribute(m, entries, "Implementation-Vendor-Id", project.getGroupId());
            if (project.getOrganization() != null) {
                this.addManifestAttribute(m, entries, "Implementation-Vendor", project.getOrganization().getName());
            }
        }
        if ((mainClass = config.getMainClass()) != null && !"".equals(mainClass)) {
            this.addManifestAttribute(m, entries, "Main-Class", mainClass);
        }
        if (config.isAddExtensions()) {
            Artifact artifact;
            StringBuffer extensionsList = new StringBuffer();
            Set artifacts = project.getArtifacts();
            Iterator iter = artifacts.iterator();
            while (iter.hasNext()) {
                artifact = (Artifact)iter.next();
                if ("test".equals(artifact.getScope()) || !"jar".equals(artifact.getType())) continue;
                if (extensionsList.length() > 0) {
                    extensionsList.append(" ");
                }
                extensionsList.append(artifact.getArtifactId());
            }
            if (extensionsList.length() > 0) {
                this.addManifestAttribute(m, entries, "Extension-List", extensionsList.toString());
            }
            iter = artifacts.iterator();
            while (iter.hasNext()) {
                artifact = (Artifact)iter.next();
                if (!"jar".equals(artifact.getType())) continue;
                String ename = artifact.getArtifactId() + "-Extension-Name";
                this.addManifestAttribute(m, entries, ename, artifact.getArtifactId());
                String iname = artifact.getArtifactId() + "-Implementation-Version";
                this.addManifestAttribute(m, entries, iname, artifact.getVersion());
                if (artifact.getRepository() == null) continue;
                iname = artifact.getArtifactId() + "-Implementation-URL";
                String url = artifact.getRepository().getUrl() + "/" + artifact.toString();
                this.addManifestAttribute(m, entries, iname, url);
            }
        }
        return m;
    }

    private void addCustomEntries(Manifest m, Map entries, ManifestConfiguration config) throws ManifestException {
        this.addManifestAttribute(m, entries, "Built-By", System.getProperty("user.name"));
        this.addManifestAttribute(m, entries, "Build-Jdk", System.getProperty("java.version"));
        if (config.getPackageName() != null) {
            this.addManifestAttribute(m, entries, "Package", config.getPackageName());
        }
    }

    public JarArchiver getArchiver() {
        return this.archiver;
    }

    public void setArchiver(JarArchiver archiver) {
        this.archiver = archiver;
    }

    public void setOutputFile(File outputFile) {
        this.archiveFile = outputFile;
    }

    public void createArchive(MavenProject project, MavenArchiveConfiguration archiveConfiguration) throws ArchiverException, ManifestException, IOException, DependencyResolutionRequiredException {
        File manifestFile;
        MavenProject workingProject = new MavenProject(project);
        boolean forced = archiveConfiguration.isForced();
        if (archiveConfiguration.isAddMavenDescriptor()) {
            if (workingProject.getArtifact().isSnapshot()) {
                workingProject.setVersion(workingProject.getArtifact().getVersion());
            }
            String groupId = workingProject.getGroupId();
            String artifactId = workingProject.getArtifactId();
            this.archiver.addFile(project.getFile(), "META-INF/maven/" + groupId + "/" + artifactId + "/pom.xml");
            File pomPropertiesFile = archiveConfiguration.getPomPropertiesFile();
            if (pomPropertiesFile == null) {
                File dir = new File(workingProject.getBuild().getDirectory(), "maven-archiver");
                pomPropertiesFile = new File(dir, "pom.properties");
            }
            new PomPropertiesUtil().createPomProperties(workingProject, (Archiver)this.archiver, pomPropertiesFile, forced);
        }
        if ((manifestFile = archiveConfiguration.getManifestFile()) != null) {
            this.archiver.setManifest(manifestFile);
        }
        Manifest manifest = this.getManifest(workingProject, archiveConfiguration);
        this.archiver.addConfiguredManifest(manifest);
        this.archiver.setCompress(archiveConfiguration.isCompress());
        this.archiver.setIndex(archiveConfiguration.isIndex());
        this.archiver.setDestFile(this.archiveFile);
        if (archiveConfiguration.getManifest().isAddClasspath()) {
            List artifacts = project.getRuntimeClasspathElements();
            Iterator iter = artifacts.iterator();
            while (iter.hasNext()) {
                File f = new File((String)iter.next());
                this.archiver.addConfiguredIndexJars(f);
            }
        }
        this.archiver.setForced(forced);
        if (archiveConfiguration.isForced() || this.archiver.isSupportingForced()) {
            // empty if block
        }
        this.archiver.createArchive();
    }

    private Artifact findArtifactWithFile(Set artifacts, File file) {
        Iterator iterator = artifacts.iterator();
        while (iterator.hasNext()) {
            Artifact artifact = (Artifact)iterator.next();
            if (artifact.getFile() == null || !artifact.getFile().equals(file)) continue;
            return artifact;
        }
        return null;
    }

    static {
        ArrayList<String> artifactExpressionPrefixes = new ArrayList<String>();
        artifactExpressionPrefixes.add("artifact.");
        ARTIFACT_EXPRESSION_PREFIXES = artifactExpressionPrefixes;
    }
}

