/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.taxonomy.directory;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.IntUnaryOperator;
import org.apache.lucene.document.Document;
import org.apache.lucene.facet.FacetsConfig;
import org.apache.lucene.facet.taxonomy.FacetLabel;
import org.apache.lucene.facet.taxonomy.LRUHashMap;
import org.apache.lucene.facet.taxonomy.ParallelTaxonomyArrays;
import org.apache.lucene.facet.taxonomy.TaxonomyReader;
import org.apache.lucene.facet.taxonomy.directory.DirectoryTaxonomyWriter;
import org.apache.lucene.facet.taxonomy.directory.TaxonomyIndexArrays;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.MultiTerms;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.ReaderUtil;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.Accountables;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.InPlaceMergeSorter;
import org.apache.lucene.util.RamUsageEstimator;

public class DirectoryTaxonomyReader
extends TaxonomyReader
implements Accountable {
    private static final int DEFAULT_CACHE_VALUE = 4000;
    private static final long BYTES_PER_CACHE_ENTRY = 4L * (long)RamUsageEstimator.NUM_BYTES_OBJECT_REF + 4L * (long)RamUsageEstimator.NUM_BYTES_OBJECT_HEADER + 16L;
    private final DirectoryTaxonomyWriter taxoWriter;
    private final long taxoEpoch;
    private final DirectoryReader indexReader;
    private LRUHashMap<FacetLabel, Integer> ordinalCache;
    private LRUHashMap<Integer, FacetLabel> categoryCache;
    private volatile TaxonomyIndexArrays taxoArrays;

    DirectoryTaxonomyReader(DirectoryReader indexReader, DirectoryTaxonomyWriter taxoWriter, LRUHashMap<FacetLabel, Integer> ordinalCache, LRUHashMap<Integer, FacetLabel> categoryCache, TaxonomyIndexArrays taxoArrays) throws IOException {
        this.indexReader = indexReader;
        this.taxoWriter = taxoWriter;
        this.taxoEpoch = taxoWriter == null ? -1L : taxoWriter.getTaxonomyEpoch();
        this.ordinalCache = ordinalCache == null ? new LRUHashMap(4000) : ordinalCache;
        this.categoryCache = categoryCache == null ? new LRUHashMap(4000) : categoryCache;
        this.taxoArrays = taxoArrays != null ? new TaxonomyIndexArrays((IndexReader)indexReader, taxoArrays) : null;
    }

    public DirectoryTaxonomyReader(Directory directory) throws IOException {
        this.indexReader = this.openIndexReader(directory);
        this.taxoWriter = null;
        this.taxoEpoch = -1L;
        this.ordinalCache = new LRUHashMap(4000);
        this.categoryCache = new LRUHashMap(4000);
    }

    public DirectoryTaxonomyReader(DirectoryTaxonomyWriter taxoWriter) throws IOException {
        this.taxoWriter = taxoWriter;
        this.taxoEpoch = taxoWriter.getTaxonomyEpoch();
        this.indexReader = this.openIndexReader(taxoWriter.getInternalIndexWriter());
        this.ordinalCache = new LRUHashMap(4000);
        this.categoryCache = new LRUHashMap(4000);
    }

    @Override
    protected void doClose() throws IOException {
        this.indexReader.close();
        this.taxoArrays = null;
        this.ordinalCache = null;
        this.categoryCache = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected DirectoryTaxonomyReader doOpenIfChanged() throws IOException {
        DirectoryTaxonomyReader directoryTaxonomyReader;
        block11: {
            this.ensureOpen();
            DirectoryReader r2 = DirectoryReader.openIfChanged((DirectoryReader)this.indexReader);
            if (r2 == null) {
                return null;
            }
            boolean success = false;
            try {
                boolean recreated = false;
                if (this.taxoWriter == null) {
                    String t1 = (String)this.indexReader.getIndexCommit().getUserData().get("index.epoch");
                    String t2 = (String)r2.getIndexCommit().getUserData().get("index.epoch");
                    if (t1 == null) {
                        if (t2 != null) {
                            recreated = true;
                        }
                    } else if (!t1.equals(t2)) {
                        recreated = true;
                    }
                } else if (this.taxoEpoch != this.taxoWriter.getTaxonomyEpoch()) {
                    recreated = true;
                }
                DirectoryTaxonomyReader newTaxoReader = recreated ? new DirectoryTaxonomyReader(r2, this.taxoWriter, null, null, null) : new DirectoryTaxonomyReader(r2, this.taxoWriter, this.ordinalCache, this.categoryCache, this.taxoArrays);
                success = true;
                directoryTaxonomyReader = newTaxoReader;
                if (success) break block11;
            }
            catch (Throwable throwable) {
                if (!success) {
                    IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{r2});
                }
                throw throwable;
            }
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{r2});
        }
        return directoryTaxonomyReader;
    }

    protected DirectoryReader openIndexReader(Directory directory) throws IOException {
        return DirectoryReader.open((Directory)directory);
    }

    protected DirectoryReader openIndexReader(IndexWriter writer) throws IOException {
        return DirectoryReader.open((IndexWriter)writer);
    }

    protected DirectoryReader getInternalIndexReader() {
        this.ensureOpen();
        return this.indexReader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ParallelTaxonomyArrays getParallelTaxonomyArrays() throws IOException {
        this.ensureOpen();
        TaxonomyIndexArrays arrays = this.taxoArrays;
        if (arrays == null) {
            DirectoryTaxonomyReader directoryTaxonomyReader = this;
            synchronized (directoryTaxonomyReader) {
                arrays = this.taxoArrays;
                if (arrays == null) {
                    this.taxoArrays = arrays = new TaxonomyIndexArrays((IndexReader)this.indexReader);
                }
            }
        }
        return arrays;
    }

    @Override
    public Map<String, String> getCommitUserData() throws IOException {
        this.ensureOpen();
        return this.indexReader.getIndexCommit().getUserData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getOrdinal(FacetLabel cp) throws IOException {
        this.ensureOpen();
        if (cp.length == 0) {
            return 0;
        }
        LRUHashMap<FacetLabel, Integer> lRUHashMap = this.ordinalCache;
        synchronized (lRUHashMap) {
            Integer res = (Integer)this.ordinalCache.get(cp);
            if (res != null) {
                if (res < this.indexReader.maxDoc()) {
                    return res;
                }
                return -1;
            }
        }
        int ret = -1;
        PostingsEnum docs = MultiTerms.getTermPostingsEnum((IndexReader)this.indexReader, (String)"$full_path$", (BytesRef)new BytesRef((CharSequence)FacetsConfig.pathToString(cp.components, cp.length)), (int)0);
        if (docs != null && docs.nextDoc() != Integer.MAX_VALUE) {
            ret = docs.docID();
            LRUHashMap<FacetLabel, Integer> lRUHashMap2 = this.ordinalCache;
            synchronized (lRUHashMap2) {
                this.ordinalCache.put(cp, ret);
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FacetLabel getPath(int ordinal) throws IOException {
        FacetLabel ret;
        this.ensureOpen();
        this.checkOrdinalBounds(ordinal);
        FacetLabel[] ordinalPath = this.getPathFromCache(ordinal);
        if (ordinalPath[0] != null) {
            return ordinalPath[0];
        }
        int readerIndex = ReaderUtil.subIndex((int)ordinal, (List)this.indexReader.leaves());
        LeafReader leafReader = ((LeafReaderContext)this.indexReader.leaves().get(readerIndex)).reader();
        BinaryDocValues values = leafReader.getBinaryDocValues("$full_path$");
        if (values == null || !values.advanceExact(ordinal - ((LeafReaderContext)this.indexReader.leaves().get((int)readerIndex)).docBase)) {
            Document doc = this.indexReader.storedFields().document(ordinal);
            ret = new FacetLabel(FacetsConfig.stringToPath(doc.get("$full_path$")));
        } else {
            ret = new FacetLabel(FacetsConfig.stringToPath(values.binaryValue().utf8ToString()));
        }
        LRUHashMap<Integer, FacetLabel> lRUHashMap = this.categoryCache;
        synchronized (lRUHashMap) {
            this.categoryCache.put(ordinal, ret);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FacetLabel[] getPathFromCache(int ... ordinals) {
        FacetLabel[] facetLabels = new FacetLabel[ordinals.length];
        LRUHashMap<Integer, FacetLabel> lRUHashMap = this.categoryCache;
        synchronized (lRUHashMap) {
            for (int i = 0; i < ordinals.length; ++i) {
                facetLabels[i] = (FacetLabel)this.categoryCache.get(ordinals[i]);
            }
        }
        return facetLabels;
    }

    private void checkOrdinalBounds(int ... ordinals) throws IllegalArgumentException {
        for (int ordinal : ordinals) {
            if (ordinal >= 0 && ordinal < this.indexReader.maxDoc()) continue;
            throw new IllegalArgumentException("ordinal " + ordinal + " is out of the range of the indexReader " + this.indexReader.toString() + ". The maximum possible ordinal number is " + (this.indexReader.maxDoc() - 1));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FacetLabel[] getBulkPath(final int ... ordinals) throws IOException {
        this.ensureOpen();
        this.checkOrdinalBounds(ordinals);
        int ordinalsLength = ordinals.length;
        FacetLabel[] bulkPath = new FacetLabel[ordinalsLength];
        final int[] originalPosition = new int[ordinalsLength];
        Arrays.setAll(originalPosition, IntUnaryOperator.identity());
        this.getPathFromCache(ordinals);
        new InPlaceMergeSorter(){

            protected void swap(int i, int j) {
                int x = ordinals[i];
                ordinals[i] = ordinals[j];
                ordinals[j] = x;
                x = originalPosition[i];
                originalPosition[i] = originalPosition[j];
                originalPosition[j] = x;
            }

            public int compare(int i, int j) {
                return Integer.compare(ordinals[i], ordinals[j]);
            }
        }.sort(0, ordinalsLength);
        int leafReaderMaxDoc = 0;
        int leafReaderDocBase = 0;
        BinaryDocValues values = null;
        ArrayList<Integer> uncachedOrdinalPositions = new ArrayList<Integer>();
        for (int i = 0; i < ordinalsLength; ++i) {
            if (bulkPath[originalPosition[i]] != null) continue;
            if (values == null || ordinals[i] >= leafReaderDocBase + leafReaderMaxDoc) {
                int readerIndex = ReaderUtil.subIndex((int)ordinals[i], (List)this.indexReader.leaves());
                LeafReaderContext leafReaderContext = (LeafReaderContext)this.indexReader.leaves().get(readerIndex);
                LeafReader leafReader = leafReaderContext.reader();
                leafReaderMaxDoc = leafReader.maxDoc();
                leafReaderDocBase = leafReaderContext.docBase;
                values = leafReader.getBinaryDocValues("$full_path$");
                if (values == null) {
                    return super.getBulkPath(ordinals);
                }
            }
            boolean success = values.advanceExact(ordinals[i] - leafReaderDocBase);
            assert (success);
            bulkPath[originalPosition[i]] = new FacetLabel(FacetsConfig.stringToPath(values.binaryValue().utf8ToString()));
            uncachedOrdinalPositions.add(i);
        }
        if (!uncachedOrdinalPositions.isEmpty()) {
            LRUHashMap<Integer, FacetLabel> lRUHashMap = this.categoryCache;
            synchronized (lRUHashMap) {
                Iterator iterator = uncachedOrdinalPositions.iterator();
                while (iterator.hasNext()) {
                    int i = (Integer)iterator.next();
                    this.categoryCache.put(ordinals[i], bulkPath[originalPosition[i]]);
                }
            }
        }
        return bulkPath;
    }

    @Override
    public int getSize() {
        this.ensureOpen();
        return this.indexReader.numDocs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized long ramBytesUsed() {
        this.ensureOpen();
        long ramBytesUsed = 0L;
        if (this.taxoArrays != null) {
            ramBytesUsed += this.taxoArrays.ramBytesUsed();
        }
        LRUHashMap<Comparable<Integer>, Comparable<FacetLabel>> lRUHashMap = this.categoryCache;
        synchronized (lRUHashMap) {
            ramBytesUsed += BYTES_PER_CACHE_ENTRY * (long)this.categoryCache.size();
        }
        lRUHashMap = this.ordinalCache;
        synchronized (lRUHashMap) {
        }
        return ramBytesUsed += BYTES_PER_CACHE_ENTRY * (long)this.ordinalCache.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Collection<Accountable> getChildResources() {
        ArrayList<Accountable> resources = new ArrayList<Accountable>();
        if (this.taxoArrays != null) {
            resources.add(Accountables.namedAccountable((String)"taxoArrays", (Accountable)this.taxoArrays));
        }
        LRUHashMap<Comparable<Integer>, Comparable<FacetLabel>> lRUHashMap = this.categoryCache;
        synchronized (lRUHashMap) {
            resources.add(Accountables.namedAccountable((String)"categoryCache", (long)(BYTES_PER_CACHE_ENTRY * (long)this.categoryCache.size())));
        }
        lRUHashMap = this.ordinalCache;
        synchronized (lRUHashMap) {
            resources.add(Accountables.namedAccountable((String)"ordinalCache", (long)(BYTES_PER_CACHE_ENTRY * (long)this.ordinalCache.size())));
        }
        return Collections.unmodifiableList(resources);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCacheSize(int size) {
        this.ensureOpen();
        LRUHashMap<Comparable<Integer>, Comparable<FacetLabel>> lRUHashMap = this.categoryCache;
        synchronized (lRUHashMap) {
            this.categoryCache.setMaxSize(size);
        }
        lRUHashMap = this.ordinalCache;
        synchronized (lRUHashMap) {
            this.ordinalCache.setMaxSize(size);
        }
    }

    public String toString(int max) {
        this.ensureOpen();
        StringBuilder sb = new StringBuilder();
        int limit = Math.min(max, this.indexReader.maxDoc());
        for (int i = 0; i < limit; ++i) {
            try {
                FacetLabel category = this.getPath(i);
                if (category == null) {
                    sb.append(i).append(": NULL!! \n");
                    continue;
                }
                if (category.length == 0) {
                    sb.append(i).append(": EMPTY STRING!! \n");
                    continue;
                }
                sb.append(i).append(": ").append(category).append("\n");
                continue;
            }
            catch (IOException e) {
                sb.append(i).append(": EXCEPTION!! \n");
            }
        }
        return sb.toString();
    }
}

