/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.lucene.facet.params.CategoryListParams;
import org.apache.lucene.facet.params.FacetSearchParams;
import org.apache.lucene.facet.search.CountFacetRequest;
import org.apache.lucene.facet.search.DepthOneFacetResultsHandler;
import org.apache.lucene.facet.search.FacetArrays;
import org.apache.lucene.facet.search.FacetRequest;
import org.apache.lucene.facet.search.FacetResult;
import org.apache.lucene.facet.search.FacetResultsHandler;
import org.apache.lucene.facet.search.FacetsAccumulator;
import org.apache.lucene.facet.search.FacetsAggregator;
import org.apache.lucene.facet.search.FacetsCollector;
import org.apache.lucene.facet.search.MultiFacetsAggregator;
import org.apache.lucene.facet.search.OrdinalValueResolver;
import org.apache.lucene.facet.search.PerCategoryListAggregator;
import org.apache.lucene.facet.search.TopKFacetResultsHandler;
import org.apache.lucene.facet.search.TopKInEachNodeHandler;
import org.apache.lucene.facet.taxonomy.CategoryPath;
import org.apache.lucene.facet.taxonomy.ParallelTaxonomyArrays;
import org.apache.lucene.facet.taxonomy.TaxonomyReader;
import org.apache.lucene.index.IndexReader;

public class TaxonomyFacetsAccumulator
extends FacetsAccumulator {
    public final TaxonomyReader taxonomyReader;
    public final IndexReader indexReader;
    public final FacetArrays facetArrays;

    public TaxonomyFacetsAccumulator(FacetSearchParams searchParams, IndexReader indexReader, TaxonomyReader taxonomyReader) {
        this(searchParams, indexReader, taxonomyReader, null);
    }

    public TaxonomyFacetsAccumulator(FacetSearchParams searchParams, IndexReader indexReader, TaxonomyReader taxonomyReader, FacetArrays facetArrays) {
        super(searchParams);
        this.facetArrays = facetArrays == null ? new FacetArrays(taxonomyReader.getSize()) : facetArrays;
        this.indexReader = indexReader;
        this.taxonomyReader = taxonomyReader;
    }

    protected Map<CategoryListParams, List<FacetRequest>> groupRequests() {
        if (this.searchParams.indexingParams.getAllCategoryListParams().size() == 1) {
            return Collections.singletonMap(this.searchParams.indexingParams.getCategoryListParams(null), this.searchParams.facetRequests);
        }
        HashMap<CategoryListParams, List<FacetRequest>> requestsPerCLP = new HashMap<CategoryListParams, List<FacetRequest>>();
        for (FacetRequest fr : this.searchParams.facetRequests) {
            CategoryListParams clp = this.searchParams.indexingParams.getCategoryListParams(fr.categoryPath);
            List<FacetRequest> requests = requestsPerCLP.get(clp);
            if (requests == null) {
                requests = new ArrayList<FacetRequest>();
                requestsPerCLP.put(clp, requests);
            }
            requests.add(fr);
        }
        return requestsPerCLP;
    }

    public FacetsAggregator getAggregator() {
        Map<CategoryListParams, List<FacetRequest>> requestsPerCLP = this.groupRequests();
        if (requestsPerCLP.size() == 1) {
            boolean allCount = true;
            for (FacetRequest facetRequest : this.searchParams.facetRequests) {
                if (facetRequest instanceof CountFacetRequest) continue;
                allCount = false;
                break;
            }
            if (allCount) {
                return requestsPerCLP.values().iterator().next().get(0).createFacetsAggregator(this.searchParams.indexingParams);
            }
        }
        HashMap<CategoryListParams, FacetsAggregator> perCLPAggregator = new HashMap<CategoryListParams, FacetsAggregator>();
        for (Map.Entry entry : requestsPerCLP.entrySet()) {
            CategoryListParams clp = (CategoryListParams)entry.getKey();
            List requests = (List)entry.getValue();
            HashMap aggClasses = new HashMap();
            HashMap<CategoryPath, FacetsAggregator> perCategoryAggregator = new HashMap<CategoryPath, FacetsAggregator>();
            for (FacetRequest fr : requests) {
                FacetsAggregator fa = fr.createFacetsAggregator(this.searchParams.indexingParams);
                if (fa == null) {
                    throw new IllegalArgumentException("this accumulator only supports requests that create a FacetsAggregator: " + fr);
                }
                Class<?> faClass = fa.getClass();
                if (!aggClasses.containsKey(faClass)) {
                    aggClasses.put(faClass, fa);
                } else {
                    fa = (FacetsAggregator)aggClasses.get(faClass);
                }
                perCategoryAggregator.put(fr.categoryPath, fa);
            }
            if (aggClasses.size() == 1) {
                perCLPAggregator.put(clp, (FacetsAggregator)aggClasses.values().iterator().next());
                continue;
            }
            perCLPAggregator.put(clp, new MultiFacetsAggregator(perCategoryAggregator));
        }
        return new PerCategoryListAggregator(perCLPAggregator, this.searchParams.indexingParams);
    }

    protected FacetResultsHandler createFacetResultsHandler(FacetRequest fr, OrdinalValueResolver resolver) {
        if (fr.getDepth() == 1 && fr.getSortOrder() == FacetRequest.SortOrder.DESCENDING) {
            return new DepthOneFacetResultsHandler(this.taxonomyReader, fr, this.facetArrays, resolver);
        }
        if (fr.getResultMode() == FacetRequest.ResultMode.PER_NODE_IN_TREE) {
            return new TopKInEachNodeHandler(this.taxonomyReader, fr, resolver, this.facetArrays);
        }
        return new TopKFacetResultsHandler(this.taxonomyReader, fr, resolver, this.facetArrays);
    }

    @Override
    public List<FacetResult> accumulate(List<FacetsCollector.MatchingDocs> matchingDocs) throws IOException {
        FacetsAggregator aggregator = this.getAggregator();
        for (CategoryListParams clp : this.groupRequests().keySet()) {
            for (FacetsCollector.MatchingDocs md : matchingDocs) {
                aggregator.aggregate(md, clp, this.facetArrays);
            }
        }
        ParallelTaxonomyArrays arrays = this.taxonomyReader.getParallelTaxonomyArrays();
        int[] children = arrays.children();
        int[] siblings = arrays.siblings();
        ArrayList<FacetResult> res = new ArrayList<FacetResult>();
        for (FacetRequest fr : this.searchParams.facetRequests) {
            CategoryListParams.OrdinalPolicy ordinalPolicy;
            int rootOrd = this.taxonomyReader.getOrdinal(fr.categoryPath);
            if (rootOrd == -1) {
                res.add(TaxonomyFacetsAccumulator.emptyResult(rootOrd, fr));
                continue;
            }
            CategoryListParams clp = this.searchParams.indexingParams.getCategoryListParams(fr.categoryPath);
            if (fr.categoryPath.length > 0 && (ordinalPolicy = clp.getOrdinalPolicy(fr.categoryPath.components[0])) == CategoryListParams.OrdinalPolicy.NO_PARENTS) {
                aggregator.rollupValues(fr, rootOrd, children, siblings, this.facetArrays);
            }
            FacetResultsHandler frh = this.createFacetResultsHandler(fr, aggregator.createOrdinalValueResolver(fr, this.facetArrays));
            res.add(frh.compute());
        }
        return res;
    }

    @Override
    public boolean requiresDocScores() {
        return this.getAggregator().requiresDocScores();
    }
}

