/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.range;

import org.apache.lucene.facet.range.Range;

public final class DoubleRange
extends Range {
    private final double minIncl;
    private final double maxIncl;
    public final double min;
    public final double max;
    public final boolean minInclusive;
    public final boolean maxInclusive;

    public DoubleRange(String label, double min, boolean minInclusive, double max, boolean maxInclusive) {
        super(label);
        this.min = min;
        this.max = max;
        this.minInclusive = minInclusive;
        this.maxInclusive = maxInclusive;
        if (Double.isNaN(min)) {
            throw new IllegalArgumentException("min cannot be NaN");
        }
        if (!minInclusive) {
            min = Math.nextUp(min);
        }
        if (Double.isNaN(max)) {
            throw new IllegalArgumentException("max cannot be NaN");
        }
        if (!maxInclusive) {
            max = Math.nextAfter(max, Double.NEGATIVE_INFINITY);
        }
        this.minIncl = min;
        this.maxIncl = max;
    }

    @Override
    public boolean accept(long value) {
        double doubleValue = Double.longBitsToDouble(value);
        return doubleValue >= this.minIncl && doubleValue <= this.maxIncl;
    }
}

