/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.old;

import java.io.IOException;
import java.util.Arrays;
import org.apache.lucene.facet.old.ScoredDocIDs;
import org.apache.lucene.facet.old.ScoredDocIDsIterator;
import org.apache.lucene.index.AtomicReader;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.MultiFields;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.FixedBitSet;
import org.apache.lucene.util.OpenBitSetDISI;

public class ScoredDocIdsUtils {
    public static final ScoredDocIDs getComplementSet(ScoredDocIDs docids, IndexReader reader) throws IOException {
        FixedBitSet complement;
        int maxDoc = reader.maxDoc();
        DocIdSet docIdSet = docids.getDocIDs();
        if (docIdSet instanceof FixedBitSet) {
            complement = ((FixedBitSet)docIdSet).clone();
        } else {
            int doc;
            complement = new FixedBitSet(maxDoc);
            DocIdSetIterator iter = docIdSet.iterator();
            while ((doc = iter.nextDoc()) < maxDoc) {
                complement.set(doc);
            }
        }
        complement.flip(0, maxDoc);
        ScoredDocIdsUtils.clearDeleted(reader, complement);
        return ScoredDocIdsUtils.createScoredDocIds((DocIdSet)complement, maxDoc);
    }

    private static void clearDeleted(IndexReader reader, FixedBitSet set) throws IOException {
        if (!reader.hasDeletions()) {
            return;
        }
        DocIdSetIterator it = set.iterator();
        int doc = it.nextDoc();
        for (AtomicReaderContext context : reader.leaves()) {
            AtomicReader r = context.reader();
            int maxDoc = r.maxDoc() + context.docBase;
            if (doc >= maxDoc) continue;
            if (!r.hasDeletions()) {
                while ((doc = it.nextDoc()) < maxDoc) {
                }
                continue;
            }
            Bits liveDocs = r.getLiveDocs();
            do {
                if (liveDocs.get(doc - context.docBase)) continue;
                set.clear(doc);
            } while ((doc = it.nextDoc()) < maxDoc);
        }
    }

    public static final ScoredDocIDs createScoredDocIDsSubset(ScoredDocIDs allDocIds, int[] sampleSet) throws IOException {
        final int[] docids = sampleSet;
        Arrays.sort(docids);
        final float[] scores = new float[docids.length];
        ScoredDocIDsIterator it = allDocIds.iterator();
        int n = 0;
        while (it.next() && n < docids.length) {
            int doc = it.getDocID();
            if (doc != docids[n]) continue;
            scores[n] = it.getScore();
            ++n;
        }
        final int size = n;
        return new ScoredDocIDs(){

            @Override
            public DocIdSet getDocIDs() {
                return new DocIdSet(){

                    public boolean isCacheable() {
                        return true;
                    }

                    public DocIdSetIterator iterator() {
                        return new DocIdSetIterator(){
                            private int next = -1;

                            public int advance(int target) {
                                while (this.next < size && docids[this.next++] < target) {
                                }
                                return this.next == size ? Integer.MAX_VALUE : docids[this.next];
                            }

                            public int docID() {
                                return docids[this.next];
                            }

                            public int nextDoc() {
                                if (++this.next >= size) {
                                    return Integer.MAX_VALUE;
                                }
                                return docids[this.next];
                            }

                            public long cost() {
                                return size;
                            }
                        };
                    }
                };
            }

            @Override
            public ScoredDocIDsIterator iterator() {
                return new ScoredDocIDsIterator(){
                    int next = -1;

                    @Override
                    public boolean next() {
                        return ++this.next < size;
                    }

                    @Override
                    public float getScore() {
                        return scores[this.next];
                    }

                    @Override
                    public int getDocID() {
                        return docids[this.next];
                    }
                };
            }

            @Override
            public int size() {
                return size;
            }
        };
    }

    public static final ScoredDocIDs createAllDocsScoredDocIDs(IndexReader reader) {
        if (reader.hasDeletions()) {
            return new AllLiveDocsScoredDocIDs(reader);
        }
        return new AllDocsScoredDocIDs(reader);
    }

    public static final ScoredDocIDs createScoredDocIds(final DocIdSet docIdSet, final int maxDoc) {
        return new ScoredDocIDs(){
            private int size = -1;

            @Override
            public DocIdSet getDocIDs() {
                return docIdSet;
            }

            @Override
            public ScoredDocIDsIterator iterator() throws IOException {
                final DocIdSetIterator docIterator = docIdSet.iterator();
                return new ScoredDocIDsIterator(){

                    @Override
                    public boolean next() {
                        try {
                            return docIterator.nextDoc() != Integer.MAX_VALUE;
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    }

                    @Override
                    public float getScore() {
                        return 1.0f;
                    }

                    @Override
                    public int getDocID() {
                        return docIterator.docID();
                    }
                };
            }

            @Override
            public int size() {
                if (this.size < 0) {
                    OpenBitSetDISI openBitSetDISI;
                    try {
                        openBitSetDISI = new OpenBitSetDISI(docIdSet.iterator(), maxDoc);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                    this.size = (int)openBitSetDISI.cardinality();
                }
                return this.size;
            }
        };
    }

    private static final class AllLiveDocsScoredDocIDs
    implements ScoredDocIDs {
        final int maxDoc;
        final IndexReader reader;

        AllLiveDocsScoredDocIDs(IndexReader reader) {
            this.maxDoc = reader.maxDoc();
            this.reader = reader;
        }

        @Override
        public int size() {
            return this.reader.numDocs();
        }

        @Override
        public DocIdSet getDocIDs() {
            return new DocIdSet(){

                public boolean isCacheable() {
                    return true;
                }

                public DocIdSetIterator iterator() {
                    return new DocIdSetIterator(){
                        final Bits liveDocs;
                        private int next;
                        {
                            this.liveDocs = MultiFields.getLiveDocs((IndexReader)AllLiveDocsScoredDocIDs.this.reader);
                            this.next = -1;
                        }

                        public int advance(int target) {
                            if (target > this.next) {
                                this.next = target - 1;
                            }
                            return this.nextDoc();
                        }

                        public int docID() {
                            return this.next;
                        }

                        public int nextDoc() {
                            do {
                                ++this.next;
                            } while (this.next < AllLiveDocsScoredDocIDs.this.maxDoc && this.liveDocs != null && !this.liveDocs.get(this.next));
                            return this.next < AllLiveDocsScoredDocIDs.this.maxDoc ? this.next : Integer.MAX_VALUE;
                        }

                        public long cost() {
                            return AllLiveDocsScoredDocIDs.this.maxDoc;
                        }
                    };
                }
            };
        }

        @Override
        public ScoredDocIDsIterator iterator() {
            try {
                final DocIdSetIterator iter = this.getDocIDs().iterator();
                return new ScoredDocIDsIterator(){

                    @Override
                    public boolean next() {
                        try {
                            return iter.nextDoc() != Integer.MAX_VALUE;
                        }
                        catch (IOException e) {
                            return false;
                        }
                    }

                    @Override
                    public float getScore() {
                        return 1.0f;
                    }

                    @Override
                    public int getDocID() {
                        return iter.docID();
                    }
                };
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static class AllDocsScoredDocIDs
    implements ScoredDocIDs {
        final int maxDoc;

        public AllDocsScoredDocIDs(IndexReader reader) {
            this.maxDoc = reader.maxDoc();
        }

        @Override
        public int size() {
            return this.maxDoc;
        }

        @Override
        public DocIdSet getDocIDs() {
            return new DocIdSet(){

                public boolean isCacheable() {
                    return true;
                }

                public DocIdSetIterator iterator() {
                    return new DocIdSetIterator(){
                        private int next = -1;

                        public int advance(int target) {
                            if (target <= this.next) {
                                target = this.next + 1;
                            }
                            this.next = target >= AllDocsScoredDocIDs.this.maxDoc ? Integer.MAX_VALUE : target;
                            return this.next;
                        }

                        public int docID() {
                            return this.next;
                        }

                        public int nextDoc() {
                            return ++this.next < AllDocsScoredDocIDs.this.maxDoc ? this.next : Integer.MAX_VALUE;
                        }

                        public long cost() {
                            return AllDocsScoredDocIDs.this.maxDoc;
                        }
                    };
                }
            };
        }

        @Override
        public ScoredDocIDsIterator iterator() {
            try {
                final DocIdSetIterator iter = this.getDocIDs().iterator();
                return new ScoredDocIDsIterator(){

                    @Override
                    public boolean next() {
                        try {
                            return iter.nextDoc() != Integer.MAX_VALUE;
                        }
                        catch (IOException e) {
                            return false;
                        }
                    }

                    @Override
                    public float getScore() {
                        return 1.0f;
                    }

                    @Override
                    public int getDocID() {
                        return iter.docID();
                    }
                };
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

