/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.partitions;

import java.io.IOException;
import org.apache.lucene.facet.partitions.IntermediateFacetResult;
import org.apache.lucene.facet.search.FacetArrays;
import org.apache.lucene.facet.search.FacetRequest;
import org.apache.lucene.facet.search.FacetResult;
import org.apache.lucene.facet.search.FacetResultsHandler;
import org.apache.lucene.facet.taxonomy.TaxonomyReader;

public abstract class PartitionsFacetResultsHandler
extends FacetResultsHandler {
    public PartitionsFacetResultsHandler(TaxonomyReader taxonomyReader, FacetRequest facetRequest, FacetArrays facetArrays) {
        super(taxonomyReader, facetRequest, facetArrays);
    }

    public abstract IntermediateFacetResult fetchPartitionResult(int var1) throws IOException;

    public abstract IntermediateFacetResult mergeResults(IntermediateFacetResult ... var1) throws IOException;

    public abstract FacetResult renderFacetResult(IntermediateFacetResult var1) throws IOException;

    public abstract FacetResult rearrangeFacetResult(FacetResult var1);

    public abstract void labelResult(FacetResult var1) throws IOException;

    protected boolean isSelfPartition(int ordinal, FacetArrays facetArrays, int offset) {
        int partitionSize = facetArrays.arrayLength;
        return ordinal / partitionSize == offset / partitionSize;
    }

    @Override
    public final FacetResult compute() throws IOException {
        FacetResult res = this.renderFacetResult(this.fetchPartitionResult(0));
        this.labelResult(res);
        return res;
    }
}

