/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.encoding;

import java.util.Arrays;
import org.apache.lucene.facet.encoding.IntDecoder;
import org.apache.lucene.facet.encoding.IntEncoder;
import org.apache.lucene.facet.encoding.IntEncoderFilter;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IntsRef;

public final class SortingIntEncoder
extends IntEncoderFilter {
    public SortingIntEncoder(IntEncoder encoder) {
        super(encoder);
    }

    @Override
    public void encode(IntsRef values, BytesRef buf) {
        Arrays.sort(values.ints, values.offset, values.offset + values.length);
        this.encoder.encode(values, buf);
    }

    @Override
    public IntDecoder createMatchingDecoder() {
        return this.encoder.createMatchingDecoder();
    }

    public String toString() {
        return "Sorting(" + this.encoder.toString() + ")";
    }
}

