/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.enhancements.association;

import java.io.IOException;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.facet.enhancements.CategoryEnhancement;
import org.apache.lucene.facet.enhancements.association.AssociationEnhancement;
import org.apache.lucene.facet.enhancements.association.AssociationProperty;
import org.apache.lucene.facet.enhancements.params.EnhancementsIndexingParams;
import org.apache.lucene.facet.index.CategoryListPayloadStream;
import org.apache.lucene.facet.index.attributes.OrdinalProperty;
import org.apache.lucene.facet.index.streaming.CategoryListTokenizer;
import org.apache.lucene.util.encoding.SimpleIntEncoder;

public class AssociationListTokenizer
extends CategoryListTokenizer {
    protected CategoryListPayloadStream payloadStream;
    private String categoryListTermText;

    public AssociationListTokenizer(TokenStream input, EnhancementsIndexingParams indexingParams, CategoryEnhancement enhancement) {
        super(input, indexingParams);
        this.categoryListTermText = enhancement.getCategoryListTermText();
    }

    protected void handleStartOfInput() throws IOException {
        this.payloadStream = null;
    }

    public final boolean incrementToken() throws IOException {
        if (this.input.incrementToken()) {
            AssociationProperty associationProperty;
            if (this.categoryAttribute != null && (associationProperty = AssociationEnhancement.getAssociationProperty(this.categoryAttribute)) != null && associationProperty.hasBeenSet()) {
                OrdinalProperty ordinalProperty = (OrdinalProperty)this.categoryAttribute.getProperty(OrdinalProperty.class);
                if (ordinalProperty == null) {
                    throw new IOException("Error: Association without ordinal");
                }
                if (this.payloadStream == null) {
                    this.payloadStream = new CategoryListPayloadStream(new SimpleIntEncoder());
                }
                this.payloadStream.appendIntToStream(ordinalProperty.getOrdinal());
                this.payloadStream.appendIntToStream(associationProperty.getAssociation());
            }
            return true;
        }
        if (this.payloadStream != null) {
            this.termAttribute.setEmpty().append(this.categoryListTermText);
            this.payload.setData(this.payloadStream.convertStreamToByteArray());
            this.payloadAttribute.setPayload(this.payload);
            this.payloadStream = null;
            return true;
        }
        return false;
    }
}

