/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.enhancements;

import java.io.IOException;
import java.util.List;
import org.apache.lucene.facet.enhancements.CategoryEnhancement;
import org.apache.lucene.facet.search.PayloadIterator;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.util.Vint8;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnhancementsPayloadIterator
extends PayloadIterator {
    private CategoryEnhancement[] EnhancedCategories;
    int nEnhancements;
    private int[] enhancementLength;
    private int[] enhancementStart;

    public EnhancementsPayloadIterator(List<CategoryEnhancement> enhancementsList, IndexReader indexReader, Term term) throws IOException {
        super(indexReader, term);
        this.EnhancedCategories = enhancementsList.toArray(new CategoryEnhancement[enhancementsList.size()]);
        this.enhancementLength = new int[this.EnhancedCategories.length];
        this.enhancementStart = new int[this.EnhancedCategories.length];
    }

    @Override
    public boolean setdoc(int docId) throws IOException {
        int i;
        if (!super.setdoc(docId)) {
            return false;
        }
        Vint8.Position position = new Vint8.Position();
        this.nEnhancements = Vint8.decode(this.buffer, position);
        for (i = 0; i < this.nEnhancements; ++i) {
            this.enhancementLength[i] = Vint8.decode(this.buffer, position);
        }
        this.enhancementStart[0] = position.pos;
        for (i = 1; i < this.nEnhancements; ++i) {
            this.enhancementStart[i] = this.enhancementStart[i - 1] + this.enhancementLength[i - 1];
        }
        return true;
    }

    public Object getCategoryData(CategoryEnhancement enhancedCategory) {
        for (int i = 0; i < this.nEnhancements; ++i) {
            if (!enhancedCategory.equals(this.EnhancedCategories[i])) continue;
            return enhancedCategory.extractCategoryTokenData(this.buffer, this.enhancementStart[i], this.enhancementLength[i]);
        }
        return null;
    }
}

