/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.security.ssl.mock;

import java.io.File;
import java.io.IOException;
import java.net.Socket;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactorySpi;
import javax.net.ssl.ManagerFactoryParameters;
import javax.net.ssl.X509ExtendedKeyManager;
import org.apache.kafka.common.config.types.Password;
import org.apache.kafka.test.TestSslUtils;
import org.apache.kafka.test.TestUtils;

public class TestKeyManagerFactory
extends KeyManagerFactorySpi {
    public static final String ALGORITHM = "TestAlgorithm";

    @Override
    protected void engineInit(KeyStore keyStore, char[] chars) {
    }

    @Override
    protected void engineInit(ManagerFactoryParameters managerFactoryParameters) {
    }

    @Override
    protected KeyManager[] engineGetKeyManagers() {
        return new KeyManager[]{new TestKeyManager()};
    }

    public static class TestKeyManager
    extends X509ExtendedKeyManager {
        public static String mockTrustStoreFile;
        public static final String ALIAS = "TestAlias";
        private static final String CN = "localhost";
        private static final String SIGNATURE_ALGORITHM = "RSA";
        private final KeyPair keyPair;
        private final X509Certificate certificate;

        protected TestKeyManager() {
            try {
                this.keyPair = TestSslUtils.generateKeyPair(SIGNATURE_ALGORITHM);
                TestSslUtils.CertificateBuilder certBuilder = new TestSslUtils.CertificateBuilder();
                this.certificate = certBuilder.generate("CN=localhost, O=A server", this.keyPair);
                HashMap<String, X509Certificate> certificates = new HashMap<String, X509Certificate>();
                certificates.put(ALIAS, this.certificate);
                File trustStoreFile = TestUtils.tempFile("testTrustStore", ".jks");
                mockTrustStoreFile = trustStoreFile.getPath();
                TestSslUtils.createTrustStore(mockTrustStoreFile, new Password("TrustStorePassword"), certificates);
            }
            catch (IOException | GeneralSecurityException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public String[] getClientAliases(String s, Principal[] principals) {
            return new String[]{ALIAS};
        }

        @Override
        public String chooseClientAlias(String[] strings, Principal[] principals, Socket socket) {
            return ALIAS;
        }

        @Override
        public String[] getServerAliases(String s, Principal[] principals) {
            return new String[]{ALIAS};
        }

        @Override
        public String chooseServerAlias(String s, Principal[] principals, Socket socket) {
            return ALIAS;
        }

        @Override
        public X509Certificate[] getCertificateChain(String s) {
            return new X509Certificate[]{this.certificate};
        }

        @Override
        public PrivateKey getPrivateKey(String s) {
            return this.keyPair.getPrivate();
        }
    }
}

