/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.jca;

import java.io.PrintWriter;
import java.util.Iterator;
import java.util.LinkedList;
import javax.jcr.RepositoryException;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionEvent;
import javax.resource.spi.ConnectionEventListener;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.LocalTransaction;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionMetaData;
import javax.security.auth.Subject;
import javax.transaction.xa.XAResource;
import org.apache.jackrabbit.api.XASession;
import org.apache.jackrabbit.core.RepositoryImpl;
import org.apache.jackrabbit.jca.JCAConnectionRequestInfo;
import org.apache.jackrabbit.jca.JCAManagedConnectionFactory;
import org.apache.jackrabbit.jca.JCASessionHandle;
import org.apache.jackrabbit.jca.TransactionBoundXAResource;

public final class JCAManagedConnection
implements ManagedConnection,
ManagedConnectionMetaData {
    private final JCAManagedConnectionFactory mcf;
    private final JCAConnectionRequestInfo cri;
    private final XASession session;
    private final XAResource xaResource;
    private final LinkedList listeners;
    private final LinkedList handles;
    private PrintWriter logWriter;

    public JCAManagedConnection(JCAManagedConnectionFactory mcf, JCAConnectionRequestInfo cri, XASession session) {
        this.mcf = mcf;
        this.cri = cri;
        this.session = session;
        this.listeners = new LinkedList();
        this.handles = new LinkedList();
        this.xaResource = this.mcf.getBindSessionToTransaction() != false ? new TransactionBoundXAResource(this, session.getXAResource()) : session.getXAResource();
    }

    private RepositoryImpl getRepository() {
        return this.mcf.getRepository();
    }

    public JCAManagedConnectionFactory getManagedConnectionFactory() {
        return this.mcf;
    }

    public JCAConnectionRequestInfo getConnectionRequestInfo() {
        return this.cri;
    }

    public PrintWriter getLogWriter() {
        return this.logWriter;
    }

    public void setLogWriter(PrintWriter logWriter) throws ResourceException {
        this.logWriter = logWriter;
    }

    public Object getConnection(Subject subject, ConnectionRequestInfo cri) throws ResourceException {
        JCASessionHandle handle = new JCASessionHandle(this);
        this.addHandle(handle);
        return handle;
    }

    public void destroy() throws ResourceException {
        this.cleanup();
        this.session.logout();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanup() throws ResourceException {
        LinkedList linkedList = this.handles;
        synchronized (linkedList) {
            try {
                this.session.refresh(false);
            }
            catch (RepositoryException e) {
                ResourceException exception = new ResourceException("unable to cleanup connection");
                exception.setLinkedException((Exception)((Object)e));
                throw exception;
            }
            this.handles.clear();
        }
    }

    public void associateConnection(Object connection) throws ResourceException {
        JCASessionHandle handle = (JCASessionHandle)connection;
        if (handle.getManagedConnection() != this) {
            handle.getManagedConnection().removeHandle(handle);
            handle.setManagedConnection(this);
            this.addHandle(handle);
        }
    }

    public XAResource getXAResource() throws ResourceException {
        return this.xaResource;
    }

    public LocalTransaction getLocalTransaction() throws ResourceException {
        throw new UnsupportedOperationException("Local transaction is not supported");
    }

    public ManagedConnectionMetaData getMetaData() throws ResourceException {
        return this;
    }

    public void closeHandle(JCASessionHandle handle) {
        if (handle != null) {
            this.removeHandle(handle);
            this.sendClosedEvent(handle);
        }
    }

    public XASession getSession(JCASessionHandle handle) {
        LinkedList linkedList = this.handles;
        synchronized (linkedList) {
            if (this.handles.size() > 0 && this.handles.get(0) == handle) {
                return this.session;
            }
            throw new IllegalStateException("Inactive logical session handle called");
        }
    }

    public String getEISProductName() throws ResourceException {
        return this.getRepository().getDescriptor("jcr.repository.name");
    }

    public String getEISProductVersion() throws ResourceException {
        return this.getRepository().getDescriptor("jcr.repository.version");
    }

    public int getMaxConnections() throws ResourceException {
        return Integer.MAX_VALUE;
    }

    public String getUserName() throws ResourceException {
        return this.session.getUserID();
    }

    public void log(String message) {
        this.log(message, null);
    }

    public void log(String message, Throwable exception) {
        if (this.logWriter != null) {
            this.logWriter.println(message);
            if (exception != null) {
                exception.printStackTrace(this.logWriter);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConnectionEventListener(ConnectionEventListener listener) {
        LinkedList linkedList = this.listeners;
        synchronized (linkedList) {
            if (!this.listeners.contains(listener)) {
                this.listeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConnectionEventListener(ConnectionEventListener listener) {
        LinkedList linkedList = this.listeners;
        synchronized (linkedList) {
            this.listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendEvent(ConnectionEvent event) {
        LinkedList linkedList = this.listeners;
        synchronized (linkedList) {
            Iterator i = this.listeners.iterator();
            while (i.hasNext()) {
                ConnectionEventListener listener = (ConnectionEventListener)i.next();
                switch (event.getId()) {
                    case 1: {
                        listener.connectionClosed(event);
                        break;
                    }
                    case 5: {
                        listener.connectionErrorOccurred(event);
                        break;
                    }
                    case 3: {
                        listener.localTransactionCommitted(event);
                        break;
                    }
                    case 4: {
                        listener.localTransactionRolledback(event);
                        break;
                    }
                    case 2: {
                        listener.localTransactionStarted(event);
                        break;
                    }
                }
            }
        }
    }

    private void sendEvent(int type, Object handle, Exception cause) {
        ConnectionEvent event = new ConnectionEvent((ManagedConnection)this, type, cause);
        if (handle != null) {
            event.setConnectionHandle(handle);
        }
        this.sendEvent(event);
    }

    private void sendClosedEvent(JCASessionHandle handle) {
        this.sendEvent(1, handle, null);
    }

    public void sendrrorEvent(JCASessionHandle handle, Exception cause) {
        this.sendEvent(5, handle, cause);
    }

    public void sendTxCommittedEvent(JCASessionHandle handle) {
        this.sendEvent(3, handle, null);
    }

    public void sendTxRolledbackEvent(JCASessionHandle handle) {
        this.sendEvent(4, handle, null);
    }

    public void sendTxStartedEvent(JCASessionHandle handle) {
        this.sendEvent(2, handle, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addHandle(JCASessionHandle handle) {
        LinkedList linkedList = this.handles;
        synchronized (linkedList) {
            this.handles.addFirst(handle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeHandle(JCASessionHandle handle) {
        LinkedList linkedList = this.handles;
        synchronized (linkedList) {
            this.handles.remove(handle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void closeHandles() {
        LinkedList linkedList = this.handles;
        synchronized (linkedList) {
            JCASessionHandle[] handlesArray = new JCASessionHandle[this.handles.size()];
            this.handles.toArray(handlesArray);
            for (int i = 0; i < handlesArray.length; ++i) {
                this.closeHandle(handlesArray[i]);
            }
        }
    }
}

