/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.shims;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.fs.ProxyFileSystem;
import org.apache.hadoop.fs.Trash;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hive.shims.HadoopShims;
import org.apache.hadoop.hive.shims.HadoopShimsSecure;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.mapred.ClusterStatus;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobContext;
import org.apache.hadoop.mapred.JobTracker;
import org.apache.hadoop.mapred.MiniMRCluster;
import org.apache.hadoop.mapred.TaskAttemptID;
import org.apache.hadoop.mapred.TaskLogServlet;
import org.apache.hadoop.mapred.WebHCatJTShim20S;
import org.apache.hadoop.mapred.lib.TotalOrderPartitioner;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.JobStatus;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskID;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.Progressable;

public class Hadoop20SShims
extends HadoopShimsSecure {
    private volatile HadoopShims.HCatHadoopShims hcatShimInstance;

    public String getTaskAttemptLogUrl(JobConf conf, String taskTrackerHttpAddress, String taskAttemptId) throws MalformedURLException {
        URL taskTrackerHttpURL = new URL(taskTrackerHttpAddress);
        return TaskLogServlet.getTaskLogUrl((String)taskTrackerHttpURL.getHost(), (String)Integer.toString(taskTrackerHttpURL.getPort()), (String)taskAttemptId);
    }

    public HadoopShims.JobTrackerState getJobTrackerState(ClusterStatus clusterStatus) throws Exception {
        switch (clusterStatus.getJobTrackerState()) {
            case INITIALIZING: {
                return HadoopShims.JobTrackerState.INITIALIZING;
            }
            case RUNNING: {
                return HadoopShims.JobTrackerState.RUNNING;
            }
        }
        String errorMsg = "Unrecognized JobTracker state: " + clusterStatus.getJobTrackerState();
        throw new Exception(errorMsg);
    }

    public TaskAttemptContext newTaskAttemptContext(Configuration conf, final Progressable progressable) {
        return new TaskAttemptContext(conf, new org.apache.hadoop.mapreduce.TaskAttemptID()){

            public void progress() {
                progressable.progress();
            }
        };
    }

    public org.apache.hadoop.mapreduce.TaskAttemptID newTaskAttemptID(JobID jobId, boolean isMap, int taskId, int id) {
        return new org.apache.hadoop.mapreduce.TaskAttemptID(jobId.getJtIdentifier(), jobId.getId(), isMap, taskId, id);
    }

    public org.apache.hadoop.mapreduce.JobContext newJobContext(Job job) {
        return new org.apache.hadoop.mapreduce.JobContext(job.getConfiguration(), job.getJobID());
    }

    public boolean isLocalMode(Configuration conf) {
        return "local".equals(this.getJobLauncherRpcAddress(conf));
    }

    public String getJobLauncherRpcAddress(Configuration conf) {
        return conf.get("mapred.job.tracker");
    }

    public void setJobLauncherRpcAddress(Configuration conf, String val) {
        conf.set("mapred.job.tracker", val);
    }

    public String getJobLauncherHttpAddress(Configuration conf) {
        return conf.get("mapred.job.tracker.http.address");
    }

    public boolean moveToAppropriateTrash(FileSystem fs, Path path, Configuration conf) throws IOException {
        Configuration dupConf = new Configuration(conf);
        FileSystem.setDefaultUri((Configuration)dupConf, (URI)fs.getUri());
        Trash trash = new Trash(dupConf);
        return trash.moveToTrash(path);
    }

    public long getDefaultBlockSize(FileSystem fs, Path path) {
        return fs.getDefaultBlockSize();
    }

    public short getDefaultReplication(FileSystem fs, Path path) {
        return fs.getDefaultReplication();
    }

    public void setTotalOrderPartitionFile(JobConf jobConf, Path partitionFile) {
        TotalOrderPartitioner.setPartitionFile((JobConf)jobConf, (Path)partitionFile);
    }

    public Comparator<LongWritable> getLongComparator() {
        return new Comparator<LongWritable>(){

            @Override
            public int compare(LongWritable o1, LongWritable o2) {
                return o1.compareTo((Object)o2);
            }
        };
    }

    public MiniMrShim getMiniMrCluster(Configuration conf, int numberOfTaskTrackers, String nameNode, int numDir) throws IOException {
        return new MiniMrShim(conf, numberOfTaskTrackers, nameNode, numDir);
    }

    public HadoopShims.MiniDFSShim getMiniDfs(Configuration conf, int numDataNodes, boolean format, String[] racks) throws IOException {
        return new MiniDFSShim(new MiniDFSCluster(conf, numDataNodes, format, racks));
    }

    public HadoopShims.HCatHadoopShims getHCatShim() {
        if (this.hcatShimInstance == null) {
            this.hcatShimInstance = new HCatHadoopShims20S();
        }
        return this.hcatShimInstance;
    }

    public HadoopShims.WebHCatJTShim getWebHCatShim(Configuration conf, UserGroupInformation ugi) throws IOException {
        return new WebHCatJTShim20S(conf, ugi);
    }

    public List<FileStatus> listLocatedStatus(FileSystem fs, Path path, PathFilter filter) throws IOException {
        return Arrays.asList(fs.listStatus(path, filter));
    }

    public BlockLocation[] getLocations(FileSystem fs, FileStatus status) throws IOException {
        return fs.getFileBlockLocations(status, 0L, status.getLen());
    }

    public void hflush(FSDataOutputStream stream) throws IOException {
        stream.sync();
    }

    public FileSystem createProxyFileSystem(FileSystem fs, URI uri) {
        return new ProxyFileSystem(fs, uri);
    }

    public Map<String, String> getHadoopConfNames() {
        HashMap<String, String> ret = new HashMap<String, String>();
        ret.put("HADOOPFS", "fs.default.name");
        ret.put("HADOOPMAPFILENAME", "map.input.file");
        ret.put("HADOOPMAPREDINPUTDIR", "mapred.input.dir");
        ret.put("HADOOPMAPREDINPUTDIRRECURSIVE", "mapred.input.dir.recursive");
        ret.put("MAPREDMAXSPLITSIZE", "mapred.max.split.size");
        ret.put("MAPREDMINSPLITSIZE", "mapred.min.split.size");
        ret.put("MAPREDMINSPLITSIZEPERNODE", "mapred.min.split.size.per.node");
        ret.put("MAPREDMINSPLITSIZEPERRACK", "mapred.min.split.size.per.rack");
        ret.put("HADOOPNUMREDUCERS", "mapred.reduce.tasks");
        ret.put("HADOOPJOBNAME", "mapred.job.name");
        ret.put("HADOOPSPECULATIVEEXECREDUCERS", "mapred.reduce.tasks.speculative.execution");
        ret.put("MAPREDSETUPCLEANUPNEEDED", "mapred.committer.job.setup.cleanup.needed");
        ret.put("MAPREDTASKCLEANUPNEEDED", "mapreduce.job.committer.task.cleanup.needed");
        return ret;
    }

    public HadoopShims.ZeroCopyReaderShim getZeroCopyReader(FSDataInputStream in, HadoopShims.ByteBufferPoolShim pool) throws IOException {
        return null;
    }

    public HadoopShims.DirectDecompressorShim getDirectDecompressor(HadoopShims.DirectCompressionType codec) {
        return null;
    }

    public Configuration getConfiguration(org.apache.hadoop.mapreduce.JobContext context) {
        return context.getConfiguration();
    }

    public FileSystem getNonCachedFileSystem(URI uri, Configuration conf) throws IOException {
        boolean origDisableHDFSCache = conf.getBoolean("fs." + uri.getScheme() + ".impl.disable.cache", false);
        conf.setBoolean("fs." + uri.getScheme() + ".impl.disable.cache", true);
        FileSystem fs = FileSystem.get((URI)uri, (Configuration)conf);
        conf.setBoolean("fs." + uri.getScheme() + ".impl.disable.cache", origDisableHDFSCache);
        return fs;
    }

    private final class HCatHadoopShims20S
    implements HadoopShims.HCatHadoopShims {
        private HCatHadoopShims20S() {
        }

        public TaskID createTaskID() {
            return new TaskID();
        }

        public org.apache.hadoop.mapreduce.TaskAttemptID createTaskAttemptID() {
            return new org.apache.hadoop.mapreduce.TaskAttemptID();
        }

        public TaskAttemptContext createTaskAttemptContext(Configuration conf, org.apache.hadoop.mapreduce.TaskAttemptID taskId) {
            return new TaskAttemptContext(conf, taskId);
        }

        public org.apache.hadoop.mapred.TaskAttemptContext createTaskAttemptContext(JobConf conf, TaskAttemptID taskId, Progressable progressable) {
            org.apache.hadoop.mapred.TaskAttemptContext newContext = null;
            try {
                Constructor construct = org.apache.hadoop.mapred.TaskAttemptContext.class.getDeclaredConstructor(JobConf.class, TaskAttemptID.class, Progressable.class);
                construct.setAccessible(true);
                newContext = (org.apache.hadoop.mapred.TaskAttemptContext)construct.newInstance(conf, taskId, progressable);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return newContext;
        }

        public org.apache.hadoop.mapreduce.JobContext createJobContext(Configuration conf, JobID jobId) {
            return new org.apache.hadoop.mapreduce.JobContext(conf, jobId);
        }

        public JobContext createJobContext(JobConf conf, JobID jobId, Progressable progressable) {
            JobContext newContext = null;
            try {
                Constructor construct = JobContext.class.getDeclaredConstructor(JobConf.class, JobID.class, Progressable.class);
                construct.setAccessible(true);
                newContext = (JobContext)construct.newInstance(conf, jobId, progressable);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return newContext;
        }

        public void commitJob(OutputFormat outputFormat, Job job) throws IOException {
            if (job.getConfiguration().get("mapred.job.tracker", "").equalsIgnoreCase("local")) {
                try {
                    outputFormat.getOutputCommitter(this.createTaskAttemptContext(job.getConfiguration(), this.createTaskAttemptID())).commitJob((org.apache.hadoop.mapreduce.JobContext)job);
                }
                catch (IOException e) {
                    throw new IOException("Failed to cleanup job", e);
                }
                catch (InterruptedException e) {
                    throw new IOException("Failed to cleanup job", e);
                }
            }
        }

        public void abortJob(OutputFormat outputFormat, Job job) throws IOException {
            if (job.getConfiguration().get("mapred.job.tracker", "").equalsIgnoreCase("local")) {
                try {
                    outputFormat.getOutputCommitter(this.createTaskAttemptContext(job.getConfiguration(), new org.apache.hadoop.mapreduce.TaskAttemptID())).abortJob((org.apache.hadoop.mapreduce.JobContext)job, JobStatus.State.FAILED);
                }
                catch (IOException e) {
                    throw new IOException("Failed to abort job", e);
                }
                catch (InterruptedException e) {
                    throw new IOException("Failed to abort job", e);
                }
            }
        }

        public InetSocketAddress getResourceManagerAddress(Configuration conf) {
            return JobTracker.getAddress((Configuration)conf);
        }

        public String getPropertyName(HadoopShims.HCatHadoopShims.PropertyName name) {
            switch (name) {
                case CACHE_ARCHIVES: {
                    return "mapred.cache.archives";
                }
                case CACHE_FILES: {
                    return "mapred.cache.files";
                }
                case CACHE_SYMLINK: {
                    return "mapred.create.symlink";
                }
            }
            return "";
        }

        public boolean isFileInHDFS(FileSystem fs, Path path) throws IOException {
            return "hdfs".equals(fs.getUri().getScheme());
        }
    }

    public class MiniDFSShim
    implements HadoopShims.MiniDFSShim {
        private final MiniDFSCluster cluster;

        public MiniDFSShim(MiniDFSCluster cluster) {
            this.cluster = cluster;
        }

        public FileSystem getFileSystem() throws IOException {
            return this.cluster.getFileSystem();
        }

        public void shutdown() {
            this.cluster.shutdown();
        }
    }

    public class MiniMrShim
    implements HadoopShims.MiniMrShim {
        private final MiniMRCluster mr;

        public MiniMrShim(Configuration conf, int numberOfTaskTrackers, String nameNode, int numDir) throws IOException {
            this.mr = new MiniMRCluster(numberOfTaskTrackers, nameNode, numDir);
        }

        public int getJobTrackerPort() throws UnsupportedOperationException {
            return this.mr.getJobTrackerPort();
        }

        public void shutdown() throws IOException {
            this.mr.shutdown();
        }

        public void setupConfiguration(Configuration conf) {
            Hadoop20SShims.this.setJobLauncherRpcAddress(conf, "localhost:" + this.mr.getJobTrackerPort());
        }
    }
}

