/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.protocol;

import java.io.FileNotFoundException;
import java.io.IOException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.FsServerDefaults;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.ParentNotDirectoryException;
import org.apache.hadoop.fs.UnresolvedLinkException;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.protocol.AlreadyBeingCreatedException;
import org.apache.hadoop.hdfs.protocol.CorruptFileBlocks;
import org.apache.hadoop.hdfs.protocol.DSQuotaExceededException;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.DirectoryListing;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.protocol.HdfsFileStatus;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.hdfs.protocol.NSQuotaExceededException;
import org.apache.hadoop.hdfs.security.token.block.DataEncryptionKey;
import org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenIdentifier;
import org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenSelector;
import org.apache.hadoop.hdfs.server.namenode.NotReplicatedYetException;
import org.apache.hadoop.hdfs.server.namenode.SafeModeException;
import org.apache.hadoop.io.EnumSetWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.retry.Idempotent;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.KerberosInfo;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenInfo;

@KerberosInfo(serverPrincipal="dfs.namenode.kerberos.principal")
@TokenInfo(value=DelegationTokenSelector.class)
@InterfaceAudience.Private
@InterfaceStability.Evolving
public interface ClientProtocol {
    public static final long versionID = 69L;
    public static final int GET_STATS_CAPACITY_IDX = 0;
    public static final int GET_STATS_USED_IDX = 1;
    public static final int GET_STATS_REMAINING_IDX = 2;
    public static final int GET_STATS_UNDER_REPLICATED_IDX = 3;
    public static final int GET_STATS_CORRUPT_BLOCKS_IDX = 4;
    public static final int GET_STATS_MISSING_BLOCKS_IDX = 5;

    @Idempotent
    public LocatedBlocks getBlockLocations(String var1, long var2, long var4) throws AccessControlException, FileNotFoundException, UnresolvedLinkException, IOException;

    @Idempotent
    public FsServerDefaults getServerDefaults() throws IOException;

    public void create(String var1, FsPermission var2, String var3, EnumSetWritable<CreateFlag> var4, boolean var5, short var6, long var7) throws AccessControlException, AlreadyBeingCreatedException, DSQuotaExceededException, FileAlreadyExistsException, FileNotFoundException, NSQuotaExceededException, ParentNotDirectoryException, SafeModeException, UnresolvedLinkException, IOException;

    public LocatedBlock append(String var1, String var2) throws AccessControlException, DSQuotaExceededException, FileNotFoundException, SafeModeException, UnresolvedLinkException, IOException;

    @Idempotent
    public boolean setReplication(String var1, short var2) throws AccessControlException, DSQuotaExceededException, FileNotFoundException, SafeModeException, UnresolvedLinkException, IOException;

    @Idempotent
    public void setPermission(String var1, FsPermission var2) throws AccessControlException, FileNotFoundException, SafeModeException, UnresolvedLinkException, IOException;

    @Idempotent
    public void setOwner(String var1, String var2, String var3) throws AccessControlException, FileNotFoundException, SafeModeException, UnresolvedLinkException, IOException;

    public void abandonBlock(ExtendedBlock var1, String var2, String var3) throws AccessControlException, FileNotFoundException, UnresolvedLinkException, IOException;

    @Idempotent
    public LocatedBlock addBlock(String var1, String var2, ExtendedBlock var3, DatanodeInfo[] var4) throws AccessControlException, FileNotFoundException, NotReplicatedYetException, SafeModeException, UnresolvedLinkException, IOException;

    @Idempotent
    public LocatedBlock getAdditionalDatanode(String var1, ExtendedBlock var2, DatanodeInfo[] var3, DatanodeInfo[] var4, int var5, String var6) throws AccessControlException, FileNotFoundException, SafeModeException, UnresolvedLinkException, IOException;

    @Idempotent
    public boolean complete(String var1, String var2, ExtendedBlock var3) throws AccessControlException, FileNotFoundException, SafeModeException, UnresolvedLinkException, IOException;

    @Idempotent
    public void reportBadBlocks(LocatedBlock[] var1) throws IOException;

    public boolean rename(String var1, String var2) throws UnresolvedLinkException, IOException;

    public void concat(String var1, String[] var2) throws IOException, UnresolvedLinkException;

    public void rename2(String var1, String var2, Options.Rename ... var3) throws AccessControlException, DSQuotaExceededException, FileAlreadyExistsException, FileNotFoundException, NSQuotaExceededException, ParentNotDirectoryException, SafeModeException, UnresolvedLinkException, IOException;

    public boolean delete(String var1, boolean var2) throws AccessControlException, FileNotFoundException, SafeModeException, UnresolvedLinkException, IOException;

    @Idempotent
    public boolean mkdirs(String var1, FsPermission var2, boolean var3) throws AccessControlException, FileAlreadyExistsException, FileNotFoundException, NSQuotaExceededException, ParentNotDirectoryException, SafeModeException, UnresolvedLinkException, IOException;

    @Idempotent
    public DirectoryListing getListing(String var1, byte[] var2, boolean var3) throws AccessControlException, FileNotFoundException, UnresolvedLinkException, IOException;

    @Idempotent
    public void renewLease(String var1) throws AccessControlException, IOException;

    @Idempotent
    public boolean recoverLease(String var1, String var2) throws IOException;

    @Idempotent
    public long[] getStats() throws IOException;

    @Idempotent
    public DatanodeInfo[] getDatanodeReport(HdfsConstants.DatanodeReportType var1) throws IOException;

    @Idempotent
    public long getPreferredBlockSize(String var1) throws IOException, UnresolvedLinkException;

    @Idempotent
    public boolean setSafeMode(HdfsConstants.SafeModeAction var1, boolean var2) throws IOException;

    public void saveNamespace() throws AccessControlException, IOException;

    @Idempotent
    public long rollEdits() throws AccessControlException, IOException;

    public boolean restoreFailedStorage(String var1) throws AccessControlException, IOException;

    public void refreshNodes() throws IOException;

    public void finalizeUpgrade() throws IOException;

    @Idempotent
    public CorruptFileBlocks listCorruptFileBlocks(String var1, String var2) throws IOException;

    public void metaSave(String var1) throws IOException;

    @Idempotent
    public void setBalancerBandwidth(long var1) throws IOException;

    @Idempotent
    public HdfsFileStatus getFileInfo(String var1) throws AccessControlException, FileNotFoundException, UnresolvedLinkException, IOException;

    @Idempotent
    public HdfsFileStatus getFileLinkInfo(String var1) throws AccessControlException, UnresolvedLinkException, IOException;

    @Idempotent
    public ContentSummary getContentSummary(String var1) throws AccessControlException, FileNotFoundException, UnresolvedLinkException, IOException;

    @Idempotent
    public void setQuota(String var1, long var2, long var4) throws AccessControlException, FileNotFoundException, UnresolvedLinkException, IOException;

    @Idempotent
    public void fsync(String var1, String var2, long var3) throws AccessControlException, FileNotFoundException, UnresolvedLinkException, IOException;

    @Idempotent
    public void setTimes(String var1, long var2, long var4) throws AccessControlException, FileNotFoundException, UnresolvedLinkException, IOException;

    public void createSymlink(String var1, String var2, FsPermission var3, boolean var4) throws AccessControlException, FileAlreadyExistsException, FileNotFoundException, ParentNotDirectoryException, SafeModeException, UnresolvedLinkException, IOException;

    @Idempotent
    public String getLinkTarget(String var1) throws AccessControlException, FileNotFoundException, IOException;

    @Idempotent
    public LocatedBlock updateBlockForPipeline(ExtendedBlock var1, String var2) throws IOException;

    public void updatePipeline(String var1, ExtendedBlock var2, ExtendedBlock var3, DatanodeID[] var4) throws IOException;

    @Idempotent
    public Token<DelegationTokenIdentifier> getDelegationToken(Text var1) throws IOException;

    @Idempotent
    public long renewDelegationToken(Token<DelegationTokenIdentifier> var1) throws IOException;

    public void cancelDelegationToken(Token<DelegationTokenIdentifier> var1) throws IOException;

    public DataEncryptionKey getDataEncryptionKey() throws IOException;
}

