/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.scrplugin.tags.annotation.sling;

import com.thoughtworks.qdox.model.Annotation;
import java.util.ArrayList;
import java.util.List;
import org.apache.felix.scr.annotations.sling.SlingFilter;
import org.apache.felix.scr.annotations.sling.SlingFilterScope;
import org.apache.felix.scr.annotations.sling.SlingServlet;
import org.apache.felix.scrplugin.tags.JavaField;
import org.apache.felix.scrplugin.tags.JavaTag;
import org.apache.felix.scrplugin.tags.annotation.AnnotationJavaClassDescription;
import org.apache.felix.scrplugin.tags.annotation.AnnotationTagProvider;
import org.apache.felix.scrplugin.tags.annotation.defaulttag.Util;
import org.apache.felix.scrplugin.tags.annotation.sling.SlingFilterComponentTag;
import org.apache.felix.scrplugin.tags.annotation.sling.SlingFilterServiceTag;
import org.apache.felix.scrplugin.tags.annotation.sling.SlingServletComponentTag;
import org.apache.felix.scrplugin.tags.annotation.sling.SlingServletPropertyTag;
import org.apache.felix.scrplugin.tags.annotation.sling.SlingServletServiceTag;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SlingAnnotationTagProvider
implements AnnotationTagProvider {
    @Override
    public List<JavaTag> getTags(Annotation annotation, AnnotationJavaClassDescription description, JavaField field) {
        String annotationName = annotation.getType().getJavaClass().getFullyQualifiedName();
        ArrayList<JavaTag> tags = new ArrayList<JavaTag>();
        if (annotationName.equals(SlingServlet.class.getName())) {
            String[] methods;
            String[] extensions;
            String[] selectors;
            String[] resourceTypes;
            String[] paths;
            boolean generateService;
            boolean generateComponent = Util.getBooleanValue(annotation, "generateComponent", SlingServlet.class);
            if (generateComponent) {
                tags.add(new SlingServletComponentTag(annotation, description));
            }
            if (generateService = Util.getBooleanValue(annotation, "generateService", SlingServlet.class)) {
                tags.add(new SlingServletServiceTag(annotation, description));
            }
            if ((paths = Util.getStringValues(annotation, description, "paths")) != null && paths.length != 0) {
                tags.add(new SlingServletPropertyTag(annotation, "sling.servlet.paths", paths, description));
            }
            if ((resourceTypes = Util.getStringValues(annotation, description, "resourceTypes")) != null && resourceTypes.length != 0) {
                tags.add(new SlingServletPropertyTag(annotation, "sling.servlet.resourceTypes", resourceTypes, description));
            }
            if ((selectors = Util.getStringValues(annotation, description, "selectors")) != null && selectors.length != 0) {
                tags.add(new SlingServletPropertyTag(annotation, "sling.servlet.selectors", selectors, description));
            }
            if ((extensions = Util.getStringValues(annotation, description, "extensions")) != null && extensions.length != 0) {
                tags.add(new SlingServletPropertyTag(annotation, "sling.servlet.extensions", extensions, description));
            }
            if ((methods = Util.getStringValues(annotation, description, "methods")) != null && methods.length != 0) {
                tags.add(new SlingServletPropertyTag(annotation, "sling.servlet.methods", methods, description));
            }
        } else if (annotationName.equals(SlingFilter.class.getName())) {
            boolean generateService;
            boolean generateComponent = Util.getBooleanValue(annotation, "generateComponent", SlingFilter.class);
            if (generateComponent) {
                String desc;
                String label;
                String name = Util.getStringValue(annotation, description, "name", SlingFilter.class);
                if (name != null && name.trim().length() == 0) {
                    name = null;
                }
                if ((label = Util.getStringValue(annotation, description, "label", SlingFilter.class)) != null && label.trim().length() == 0) {
                    label = null;
                }
                if ((desc = Util.getStringValue(annotation, description, "description", SlingFilter.class)) != null && desc.trim().length() == 0) {
                    desc = null;
                }
                boolean createMetatype = Util.getBooleanValue(annotation, "metatype", SlingFilter.class);
                tags.add(new SlingFilterComponentTag(annotation, description, createMetatype, name, label, desc));
            }
            if (generateService = Util.getBooleanValue(annotation, "generateService", SlingFilter.class)) {
                tags.add(new SlingFilterServiceTag(annotation, description));
            }
            int order = Util.getIntValue(annotation, "order", SlingFilter.class);
            tags.add(new SlingServletPropertyTag(annotation, "filter.order", String.valueOf(order), description, "Integer", true));
            SlingFilterScope scope = Util.getEnumValue(annotation, "scope", SlingFilterScope.class, SlingFilter.class);
            tags.add(new SlingServletPropertyTag(annotation, "filter.scope", scope.getScope(), description, null, true));
        }
        return tags;
    }
}

