/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.scrplugin.helper;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.felix.scrplugin.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IssueLog {
    private final boolean strictMode;
    private final List<Entry> errors = new ArrayList<Entry>();
    private final List<Entry> warnings = new ArrayList<Entry>();

    public IssueLog(boolean strictMode) {
        this.strictMode = strictMode;
    }

    public int getNumberOfErrors() {
        return this.errors.size();
    }

    public boolean hasErrors() {
        return this.errors.size() > 0 || this.strictMode && this.warnings.size() > 0;
    }

    public void addError(String message, String location, int lineNumber) {
        this.errors.add(new Entry(message, location, lineNumber));
    }

    public void addWarning(String message, String location, int lineNumber) {
        this.warnings.add(new Entry(message, location, lineNumber));
    }

    public void logMessages(Log log) {
        for (Entry entry : this.warnings) {
            if (this.strictMode) {
                log.error(entry.message, entry.location, entry.lineNumber);
                continue;
            }
            log.warn(entry.message, entry.location, entry.lineNumber);
        }
        for (Entry entry : this.errors) {
            log.error(entry.message, entry.location, entry.lineNumber);
        }
    }

    public Iterator<String> getWarnings() {
        return null;
    }

    public Iterator<String> getErrors() {
        return null;
    }

    private static class Entry {
        final String message;
        final String location;
        final int lineNumber;

        Entry(String message, String location, int lineNumber) {
            this.message = message;
            this.location = location;
            this.lineNumber = lineNumber;
        }
    }
}

