/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.changepw.service;

import java.nio.ByteBuffer;
import javax.security.auth.kerberos.KerberosPrincipal;
import org.apache.directory.server.changepw.ChangePasswordConfiguration;
import org.apache.directory.server.changepw.exceptions.ChangePasswordException;
import org.apache.directory.server.changepw.messages.ChangePasswordErrorModifier;
import org.apache.directory.server.changepw.service.ChangePasswordContext;
import org.apache.directory.server.kerberos.shared.exceptions.KerberosException;
import org.apache.directory.server.kerberos.shared.messages.ErrorMessage;
import org.apache.directory.server.kerberos.shared.messages.ErrorMessageModifier;
import org.apache.directory.server.kerberos.shared.messages.value.KerberosTime;
import org.apache.directory.server.protocol.shared.chain.Context;
import org.apache.directory.server.protocol.shared.chain.Filter;
import org.apache.directory.server.protocol.shared.chain.impl.CommandBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChangePasswordExceptionHandler
extends CommandBase
implements Filter {
    private static final Logger log = LoggerFactory.getLogger((Class)ChangePasswordExceptionHandler.class);

    public boolean execute(Context context) throws Exception {
        return false;
    }

    public boolean postprocess(Context context, Exception exception) {
        if (exception == null) {
            return false;
        }
        if (log.isDebugEnabled()) {
            log.debug(exception.getMessage(), (Throwable)exception);
        } else {
            log.info(exception.getMessage());
        }
        ChangePasswordContext changepwContext = (ChangePasswordContext)context;
        ChangePasswordConfiguration config = changepwContext.getConfig();
        ChangePasswordException cpe = (ChangePasswordException)((Object)exception);
        ErrorMessage errorMessage = this.getErrorMessage(config.getChangepwPrincipal(), cpe);
        ChangePasswordErrorModifier modifier = new ChangePasswordErrorModifier();
        modifier.setErrorMessage(errorMessage);
        changepwContext.setReply(modifier.getChangePasswordError());
        return true;
    }

    private ErrorMessage getErrorMessage(KerberosPrincipal principal, KerberosException exception) {
        ErrorMessageModifier modifier = new ErrorMessageModifier();
        KerberosTime now = new KerberosTime();
        modifier.setErrorCode(exception.getErrorCode());
        modifier.setExplanatoryText(exception.getMessage());
        modifier.setServerPrincipal(principal);
        modifier.setServerTime(now);
        modifier.setServerMicroSecond(0);
        modifier.setExplanatoryData(this.buildExplanatoryData(exception));
        return modifier.getErrorMessage();
    }

    private byte[] buildExplanatoryData(KerberosException exception) {
        short resultCode = (short)exception.getErrorCode();
        byte[] resultString = exception.getExplanatoryData();
        ByteBuffer byteBuffer = ByteBuffer.allocate(256);
        byteBuffer.putShort(resultCode);
        byteBuffer.put(resultString);
        byteBuffer.flip();
        byte[] explanatoryData = new byte[byteBuffer.remaining()];
        byteBuffer.get(explanatoryData, 0, explanatoryData.length);
        return explanatoryData;
    }
}

