/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.kerberos.shared.messages.value;

import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import org.apache.directory.server.kerberos.shared.crypto.encryption.EncryptionType;
import org.apache.directory.shared.asn1.AbstractAsn1Object;
import org.apache.directory.shared.asn1.ber.tlv.TLV;
import org.apache.directory.shared.asn1.ber.tlv.Value;
import org.apache.directory.shared.asn1.codec.EncoderException;
import org.apache.directory.shared.ldap.util.StringTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EncryptedData
extends AbstractAsn1Object {
    private static final Logger log = LoggerFactory.getLogger(EncryptedData.class);
    private static final boolean IS_DEBUG = log.isDebugEnabled();
    private EncryptionType eType;
    private int kvno;
    private boolean hasKvno;
    private byte[] cipher;
    public static final boolean HAS_KVNO = true;
    private transient int eTypeTagLength;
    private transient int kvnoTagLength;
    private transient int cipherTagLength;
    private transient int encryptedDataSeqLength;

    public EncryptedData() {
        this.hasKvno = false;
    }

    public EncryptedData(EncryptionType eType, int kvno, byte[] cipher) {
        this.eType = eType;
        this.hasKvno = kvno > 0;
        this.kvno = kvno;
        this.cipher = cipher;
    }

    public EncryptedData(EncryptionType eType, byte[] cipher) {
        this.eType = eType;
        this.hasKvno = false;
        this.kvno = -1;
        this.cipher = cipher;
    }

    public EncryptionType getEType() {
        return this.eType;
    }

    public void setEType(EncryptionType eType) {
        this.eType = eType;
    }

    public int getKvno() {
        return this.hasKvno ? this.kvno : -1;
    }

    public void setKvno(int kvno) {
        this.kvno = kvno;
    }

    public boolean hasKvno() {
        return this.hasKvno;
    }

    public byte[] getCipher() {
        return this.cipher;
    }

    public void setCipher(byte[] cipher) {
        this.cipher = cipher;
    }

    public int computeLength() {
        this.encryptedDataSeqLength = 0;
        int eTypeLength = Value.getNbBytes(this.eType.getOrdinal());
        this.eTypeTagLength = 1 + TLV.getNbBytes(eTypeLength) + eTypeLength;
        this.encryptedDataSeqLength = 1 + TLV.getNbBytes(this.eTypeTagLength) + this.eTypeTagLength;
        if (this.hasKvno) {
            int kvnoLength = Value.getNbBytes(this.kvno);
            this.kvnoTagLength = 1 + TLV.getNbBytes(kvnoLength) + kvnoLength;
            this.encryptedDataSeqLength += 1 + TLV.getNbBytes(this.kvnoTagLength) + this.kvnoTagLength;
        } else {
            this.kvnoTagLength = 0;
        }
        this.cipherTagLength = this.cipher == null || this.cipher.length == 0 ? 2 : 1 + TLV.getNbBytes(this.cipher.length) + this.cipher.length;
        this.encryptedDataSeqLength += 1 + TLV.getNbBytes(this.cipherTagLength) + this.cipherTagLength;
        return 1 + TLV.getNbBytes(this.encryptedDataSeqLength) + this.encryptedDataSeqLength;
    }

    public ByteBuffer encode(ByteBuffer buffer) throws EncoderException {
        if (buffer == null) {
            throw new EncoderException("Cannot put a PDU in a null buffer !");
        }
        try {
            buffer.put((byte)48);
            buffer.put(TLV.getBytes(this.encryptedDataSeqLength));
            buffer.put((byte)-96);
            buffer.put(TLV.getBytes(this.eTypeTagLength));
            Value.encode(buffer, this.eType.getOrdinal());
            if (this.hasKvno) {
                buffer.put((byte)-95);
                buffer.put(TLV.getBytes(this.kvnoTagLength));
                Value.encode(buffer, this.kvno);
            }
            buffer.put((byte)-94);
            buffer.put(TLV.getBytes(this.cipherTagLength));
            Value.encode(buffer, this.cipher);
        }
        catch (BufferOverflowException boe) {
            log.error("Cannot encode the EncryptedData object, the PDU size is {} when only {} bytes has been allocated", 1 + TLV.getNbBytes(this.encryptedDataSeqLength) + this.encryptedDataSeqLength, (Object)buffer.capacity());
            throw new EncoderException("The PDU buffer size is too small !");
        }
        if (IS_DEBUG) {
            log.debug("EncryptedData encoding : {}", (Object)StringTools.dumpBytes(buffer.array()));
            log.debug("EncryptedData initial value : {}", (Object)this.toString());
        }
        return buffer;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("EncryptedData : {\n");
        sb.append("    etype: ").append((Object)this.eType).append('\n');
        if (this.hasKvno) {
            sb.append("    kvno: ").append(this.kvno).append('\n');
        }
        sb.append("    cipher: ").append(StringTools.dumpBytes(this.cipher)).append("\n}\n");
        return sb.toString();
    }
}

