/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.invocation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.apache.directory.server.core.interceptor.context.OperationContext;

public final class InvocationStack {
    private static final Map<Thread, InvocationStack> stacks = Collections.synchronizedMap(new IdentityHashMap());
    private final Thread thread;
    private final List<OperationContext> stack = new ArrayList<OperationContext>();

    public static InvocationStack getInstance() {
        Thread currentThread = Thread.currentThread();
        InvocationStack ctx = stacks.get(currentThread);
        if (ctx == null) {
            ctx = new InvocationStack(currentThread);
        }
        return ctx;
    }

    private InvocationStack(Thread currentThread) {
        this.thread = currentThread;
        stacks.put(currentThread, this);
    }

    public OperationContext[] toArray() {
        OperationContext[] result = new OperationContext[this.stack.size()];
        result = this.stack.toArray(result);
        return result;
    }

    public OperationContext peek() {
        return this.stack.get(0);
    }

    public boolean isEmpty() {
        return this.stack.isEmpty();
    }

    public void push(OperationContext opContext) {
        this.stack.add(0, opContext);
    }

    public OperationContext pop() {
        OperationContext invocation = this.stack.remove(0);
        if (this.stack.size() == 0) {
            stacks.remove(this.thread);
        }
        return invocation;
    }
}

