/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.model.filter;

import java.util.HashMap;
import java.util.Map;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.model.filter.AssertionType;
import org.apache.directory.api.ldap.model.filter.ExprNode;

public abstract class AbstractExprNode
implements ExprNode {
    protected Map<String, Object> annotations;
    protected final AssertionType assertionType;

    protected AbstractExprNode(AssertionType assertionType) {
        this.assertionType = assertionType;
    }

    @Override
    public AssertionType getAssertionType() {
        return this.assertionType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AbstractExprNode)) {
            return false;
        }
        AbstractExprNode that = (AbstractExprNode)o;
        if (this.assertionType != that.assertionType) {
            return false;
        }
        if (this.annotations == null) {
            return that.annotations == null;
        }
        if (that.annotations == null) {
            return false;
        }
        for (Map.Entry<String, Object> entry : this.annotations.entrySet()) {
            String key = entry.getKey();
            if (!that.annotations.containsKey(key)) {
                return false;
            }
            Object thisAnnotation = entry.getValue();
            Object thatAnnotation = that.annotations.get(key);
            if (!(thisAnnotation == null ? thatAnnotation != null : !thisAnnotation.equals(thatAnnotation))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int h = 37;
        if (this.annotations != null) {
            for (Map.Entry<String, Object> entry : this.annotations.entrySet()) {
                String key = entry.getKey();
                Object value = entry.getValue();
                h = h * 17 + key.hashCode();
                h = h * 17 + (value == null ? 0 : value.hashCode());
            }
        }
        return h;
    }

    @Override
    public Object get(Object key) {
        if (null == this.annotations) {
            return null;
        }
        return this.annotations.get(key);
    }

    @Override
    public void set(String key, Object value) {
        if (null == this.annotations) {
            this.annotations = new HashMap<String, Object>(2);
        }
        this.annotations.put(key, value);
    }

    protected Map<String, Object> getAnnotations() {
        return this.annotations;
    }

    @Override
    public StringBuilder printRefinementToBuffer(StringBuilder buf) {
        throw new UnsupportedOperationException(I18n.err((I18n)I18n.ERR_13303_SCOPENODE_IN_REFINEMENT, (Object[])new Object[0]));
    }

    @Override
    public ExprNode clone() {
        try {
            ExprNode clone = (ExprNode)super.clone();
            if (this.annotations != null) {
                for (Map.Entry<String, Object> entry : this.annotations.entrySet()) {
                    ((AbstractExprNode)clone).annotations.put(entry.getKey(), entry.getValue());
                }
            }
            return clone;
        }
        catch (CloneNotSupportedException cnse) {
            return null;
        }
    }

    public String toString() {
        if (null != this.annotations && this.annotations.containsKey("count")) {
            Long count = (Long)this.annotations.get("count");
            if (count == Long.MAX_VALUE) {
                return ":[\u221e]";
            }
            return ":[" + count + "]";
        }
        return "";
    }
}

