/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.client.bindings.spi;

import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.util.List;
import java.util.Map;
import org.apache.chemistry.opencmis.client.bindings.spi.AbstractAuthenticationProvider;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NTLMAuthenticationProvider
extends AbstractAuthenticationProvider {
    private static final long serialVersionUID = 1L;
    private static final OpenCMISAuthenticator AUTHENTICATOR = new OpenCMISAuthenticator();

    @Override
    public Map<String, List<String>> getHTTPHeaders(String url) {
        String user = this.getUser();
        String password = this.getPassword();
        if (user == null) {
            AUTHENTICATOR.reset();
            return null;
        }
        if (password == null) {
            password = "";
        }
        AUTHENTICATOR.setPasswordAuthentication(user, password);
        return null;
    }

    @Override
    public Element getSOAPHeaders(Object portObject) {
        return null;
    }

    static {
        Authenticator.setDefault(AUTHENTICATOR);
    }

    static class OpenCMISAuthenticator
    extends Authenticator {
        private PasswordAuthentication passwordAuthentication;

        OpenCMISAuthenticator() {
        }

        public synchronized void reset() {
            this.passwordAuthentication = null;
        }

        public synchronized void setPasswordAuthentication(String user, String password) {
            this.passwordAuthentication = new PasswordAuthentication(user, password.toCharArray());
        }

        protected synchronized PasswordAuthentication getPasswordAuthentication() {
            return this.passwordAuthentication;
        }
    }
}

