/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.tools;

import java.io.IOException;
import java.io.PrintStream;
import org.apache.cassandra.config.ConfigurationException;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.io.sstable.SSTableMetadata;

public class SSTableMetadataViewer {
    public static void main(String[] args) throws IOException, ConfigurationException {
        PrintStream out = System.out;
        if (args.length == 0) {
            out.println("Usage: sstablemetadata <sstable filenames>");
            System.exit(1);
        }
        for (String fname : args) {
            Descriptor descriptor = Descriptor.fromFilename(fname);
            SSTableMetadata metadata = SSTableMetadata.serializer.deserialize(descriptor);
            out.printf("SSTable: %s\n", descriptor);
            out.printf("Partitioner: %s\n", metadata.partitioner);
            out.printf("Maximum timestamp: %s\n", metadata.maxTimestamp);
            out.printf("Compression ratio: %s\n", metadata.compressionRatio);
            out.println(metadata.replayPosition);
            SSTableMetadataViewer.printHistograms(metadata, out);
        }
    }

    private static void printHistograms(SSTableMetadata metadata, PrintStream out) {
        long[] offsets = metadata.estimatedRowSize.getBucketOffsets();
        long[] ersh = metadata.estimatedRowSize.getBuckets(false);
        long[] ecch = metadata.estimatedColumnCount.getBuckets(false);
        out.println(String.format("%-10s%18s%18s", "Count", "Row Size", "Column Count"));
        for (int i = 0; i < offsets.length; ++i) {
            out.println(String.format("%-10d%18s%18s", offsets[i], i < ersh.length ? Long.valueOf(ersh[i]) : "", i < ecch.length ? Long.valueOf(ecch[i]) : ""));
        }
    }
}

