/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.index;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.SortedSet;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.Table;
import org.apache.cassandra.db.compaction.CompactionInfo;
import org.apache.cassandra.db.compaction.CompactionInterruptedException;
import org.apache.cassandra.db.compaction.OperationType;
import org.apache.cassandra.io.sstable.ReducingKeyIterator;

public class SecondaryIndexBuilder
extends CompactionInfo.Holder {
    private final ColumnFamilyStore cfs;
    private final SortedSet<ByteBuffer> columns;
    private final ReducingKeyIterator iter;

    public SecondaryIndexBuilder(ColumnFamilyStore cfs, SortedSet<ByteBuffer> columns, ReducingKeyIterator iter) {
        this.cfs = cfs;
        this.columns = columns;
        this.iter = iter;
    }

    @Override
    public CompactionInfo getCompactionInfo() {
        return new CompactionInfo(this.hashCode(), OperationType.INDEX_BUILD, this.iter.getBytesRead(), this.iter.getTotalBytes());
    }

    public void build() {
        while (this.iter.hasNext()) {
            if (this.isStopRequested()) {
                throw new CompactionInterruptedException(this.getCompactionInfo());
            }
            Object key = this.iter.next();
            Table.indexRow(key, this.cfs, this.columns);
        }
        try {
            this.iter.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

