/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.compaction;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.DataTracker;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.EchoedRow;
import org.apache.cassandra.db.compaction.AbstractCompactedRow;
import org.apache.cassandra.db.compaction.CompactionManager;
import org.apache.cassandra.db.compaction.LazilyCompactedRow;
import org.apache.cassandra.db.compaction.PrecompactedRow;
import org.apache.cassandra.io.sstable.SSTable;
import org.apache.cassandra.io.sstable.SSTableIdentityIterator;
import org.apache.cassandra.io.sstable.SSTableReader;
import org.apache.cassandra.service.CacheService;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.utils.IntervalTree.Interval;
import org.apache.cassandra.utils.IntervalTree.IntervalTree;
import org.apache.cassandra.utils.Throttle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompactionController {
    private static Logger logger = LoggerFactory.getLogger(CompactionController.class);
    private final ColumnFamilyStore cfs;
    private final boolean deserializeRequired;
    private final IntervalTree<SSTableReader> overlappingTree;
    public final int gcBefore;
    public boolean keyExistenceIsExpensive;
    public final int mergeShardBefore;
    private final Throttle throttle = new Throttle("Cassandra_Throttle", new Throttle.ThroughputFunction(){

        @Override
        public int targetThroughput() {
            if (DatabaseDescriptor.getCompactionThroughputMbPerSec() < 1 || StorageService.instance.isBootstrapMode()) {
                return 0;
            }
            int totalBytesPerMS = DatabaseDescriptor.getCompactionThroughputMbPerSec() * 1024 * 1024 / 1000;
            return totalBytesPerMS / Math.max(1, CompactionManager.instance.getActiveCompactions());
        }
    });

    public CompactionController(ColumnFamilyStore cfs, Collection<SSTableReader> sstables, int gcBefore, boolean forceDeserialize) {
        assert (cfs != null);
        this.cfs = cfs;
        this.gcBefore = gcBefore;
        this.mergeShardBefore = (int)((cfs.oldestUnflushedMemtable() + 18000L) / 1000L);
        this.deserializeRequired = forceDeserialize || !CompactionController.allLatestVersion(sstables);
        Set<SSTableReader> overlappingSSTables = cfs.getOverlappingSSTables(sstables);
        this.overlappingTree = DataTracker.buildIntervalTree(overlappingSSTables);
        this.keyExistenceIsExpensive = cfs.getCompactionStrategy().isKeyExistenceExpensive((Set<? extends SSTable>)ImmutableSet.copyOf(sstables));
    }

    public String getKeyspace() {
        return this.cfs.table.name;
    }

    public String getColumnFamily() {
        return this.cfs.columnFamily;
    }

    public boolean shouldPurge(DecoratedKey key) {
        List<SSTableReader> filteredSSTables = this.overlappingTree.search(new Interval(key, key));
        for (SSTableReader sstable : filteredSSTables) {
            if (!sstable.getBloomFilter().isPresent(key.key)) continue;
            return false;
        }
        return true;
    }

    private static boolean allLatestVersion(Iterable<SSTableReader> sstables) {
        for (SSTableReader sstable : sstables) {
            if (sstable.descriptor.isLatestVersion) continue;
            return false;
        }
        return true;
    }

    public void invalidateCachedRow(DecoratedKey key) {
        this.cfs.invalidateCachedRow(key);
    }

    public void removeDeletedInCache(DecoratedKey key) {
        if (CacheService.instance.rowCache.isPutCopying()) {
            return;
        }
        ColumnFamily cachedRow = this.cfs.getRawCachedRow(key);
        if (cachedRow != null) {
            ColumnFamilyStore.removeDeleted(cachedRow, this.gcBefore);
        }
    }

    public AbstractCompactedRow getCompactedRow(List<SSTableIdentityIterator> rows) {
        long rowSize = 0L;
        for (SSTableIdentityIterator row : rows) {
            rowSize += row.dataSize;
        }
        if (!(rows.size() != 1 || this.deserializeRequired || rowSize <= (long)DatabaseDescriptor.getInMemoryCompactionLimit() && this.keyExistenceIsExpensive || this.shouldPurge(rows.get(0).getKey()))) {
            return new EchoedRow(rows.get(0));
        }
        if (rowSize > (long)DatabaseDescriptor.getInMemoryCompactionLimit()) {
            String keyString = this.cfs.metadata.getKeyValidator().getString(rows.get((int)0).getKey().key);
            logger.info(String.format("Compacting large row %s/%s:%s (%d bytes) incrementally", this.cfs.table.name, this.cfs.columnFamily, keyString, rowSize));
            return new LazilyCompactedRow(this, rows);
        }
        return new PrecompactedRow(this, rows);
    }

    public AbstractCompactedRow getCompactedRow(SSTableIdentityIterator row) {
        return this.getCompactedRow(Collections.singletonList(row));
    }

    public void mayThrottle(long currentBytes) {
        this.throttle.throttle(currentBytes);
    }
}

