/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import com.google.common.collect.AbstractIterator;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.io.File;
import java.io.IOError;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Pattern;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.cassandra.cache.AutoSavingCache;
import org.apache.cassandra.cache.IRowCacheEntry;
import org.apache.cassandra.cache.RowCacheKey;
import org.apache.cassandra.cache.RowCacheSentinel;
import org.apache.cassandra.concurrent.JMXEnabledThreadPoolExecutor;
import org.apache.cassandra.concurrent.NamedThreadFactory;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.config.ConfigurationException;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.config.KSMetaData;
import org.apache.cassandra.config.Schema;
import org.apache.cassandra.db.ArrayBackedSortedColumns;
import org.apache.cassandra.db.CollationController;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.ColumnFamilyStoreMBean;
import org.apache.cassandra.db.DataTracker;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.Directories;
import org.apache.cassandra.db.IColumn;
import org.apache.cassandra.db.ISortedColumns;
import org.apache.cassandra.db.Memtable;
import org.apache.cassandra.db.MeteredFlusher;
import org.apache.cassandra.db.Row;
import org.apache.cassandra.db.RowIteratorFactory;
import org.apache.cassandra.db.RowPosition;
import org.apache.cassandra.db.SuperColumn;
import org.apache.cassandra.db.Table;
import org.apache.cassandra.db.columniterator.IColumnIterator;
import org.apache.cassandra.db.commitlog.CommitLog;
import org.apache.cassandra.db.commitlog.ReplayPosition;
import org.apache.cassandra.db.compaction.AbstractCompactionStrategy;
import org.apache.cassandra.db.compaction.CompactionManager;
import org.apache.cassandra.db.compaction.LeveledCompactionStrategy;
import org.apache.cassandra.db.compaction.OperationType;
import org.apache.cassandra.db.filter.ExtendedFilter;
import org.apache.cassandra.db.filter.IFilter;
import org.apache.cassandra.db.filter.QueryFilter;
import org.apache.cassandra.db.filter.QueryPath;
import org.apache.cassandra.db.index.SecondaryIndex;
import org.apache.cassandra.db.index.SecondaryIndexManager;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.dht.AbstractBounds;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.dht.LocalPartitioner;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.io.compress.CompressionParameters;
import org.apache.cassandra.io.sstable.Component;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.io.sstable.SSTable;
import org.apache.cassandra.io.sstable.SSTableMetadata;
import org.apache.cassandra.io.sstable.SSTableReader;
import org.apache.cassandra.io.sstable.SSTableWriter;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.cassandra.service.CacheService;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.thrift.IndexExpression;
import org.apache.cassandra.utils.Allocator;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.CloseableIterator;
import org.apache.cassandra.utils.DefaultInteger;
import org.apache.cassandra.utils.EstimatedHistogram;
import org.apache.cassandra.utils.HeapAllocator;
import org.apache.cassandra.utils.IntervalTree.Interval;
import org.apache.cassandra.utils.IntervalTree.IntervalTree;
import org.apache.cassandra.utils.LatencyTracker;
import org.apache.cassandra.utils.NodeId;
import org.apache.cassandra.utils.Pair;
import org.apache.cassandra.utils.WrappedRunnable;
import org.cliffc.high_scale_lib.NonBlockingHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ColumnFamilyStore
implements ColumnFamilyStoreMBean {
    private static Logger logger = LoggerFactory.getLogger(ColumnFamilyStore.class);
    private static final ExecutorService flushWriter = new JMXEnabledThreadPoolExecutor(DatabaseDescriptor.getFlushWriters(), 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(DatabaseDescriptor.getFlushQueueSize()), new NamedThreadFactory("FlushWriter"), "internal");
    public static final ExecutorService postFlushExecutor = new JMXEnabledThreadPoolExecutor("MemtablePostFlusher");
    public final Table table;
    public final String columnFamily;
    public final CFMetaData metadata;
    public final IPartitioner partitioner;
    private final String mbeanName;
    private volatile boolean valid = true;
    private final DataTracker data;
    private volatile int memtableSwitchCount = 0;
    private AtomicInteger fileIndexGenerator = new AtomicInteger(0);
    public final SecondaryIndexManager indexManager;
    private LatencyTracker readStats = new LatencyTracker();
    private LatencyTracker writeStats = new LatencyTracker();
    private final EstimatedHistogram recentSSTablesPerRead = new EstimatedHistogram(35);
    private final EstimatedHistogram sstablesPerRead = new EstimatedHistogram(35);
    private static final int INTERN_CUTOFF = 256;
    public final ConcurrentMap<ByteBuffer, ByteBuffer> internedNames = new NonBlockingHashMap();
    private volatile DefaultInteger minCompactionThreshold;
    private volatile DefaultInteger maxCompactionThreshold;
    private volatile AbstractCompactionStrategy compactionStrategy;
    public final Directories directories;
    volatile double liveRatio = 1.0;
    private final AtomicLong liveRatioComputedAt = new AtomicLong(32L);

    public void reload() throws IOException {
        if (!this.minCompactionThreshold.isModified()) {
            for (ColumnFamilyStore cfs : this.concatWithIndexes()) {
                cfs.minCompactionThreshold = new DefaultInteger(this.metadata.getMinCompactionThreshold());
            }
        }
        if (!this.maxCompactionThreshold.isModified()) {
            for (ColumnFamilyStore cfs : this.concatWithIndexes()) {
                cfs.maxCompactionThreshold = new DefaultInteger(this.metadata.getMaxCompactionThreshold());
            }
        }
        this.maybeReloadCompactionStrategy();
        this.indexManager.reload();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void maybeReloadCompactionStrategy() {
        if (this.metadata.compactionStrategyClass.equals(this.compactionStrategy.getClass()) && ((Object)this.metadata.compactionStrategyOptions).equals(this.compactionStrategy.getOptions())) {
            return;
        }
        CompactionManager.instance.getCompactionLock().lock();
        try {
            this.compactionStrategy.shutdown();
            this.compactionStrategy = this.metadata.createCompactionStrategyInstance(this);
        }
        finally {
            CompactionManager.instance.getCompactionLock().unlock();
        }
    }

    @Override
    public void setCompactionStrategyClass(String compactionStrategyClass) throws ConfigurationException {
        this.metadata.compactionStrategyClass = CFMetaData.createCompactionStrategy(compactionStrategyClass);
        this.maybeReloadCompactionStrategy();
    }

    @Override
    public String getCompactionStrategyClass() {
        return this.metadata.compactionStrategyClass.getName();
    }

    @Override
    public Map<String, String> getCompressionParameters() {
        return this.metadata.compressionParameters().asThriftOptions();
    }

    @Override
    public void setCompressionParameters(Map<String, String> opts) throws ConfigurationException {
        this.metadata.compressionParameters = CompressionParameters.create(opts);
    }

    private ColumnFamilyStore(Table table, String columnFamilyName, IPartitioner partitioner, int generation, CFMetaData metadata, Directories directories) {
        assert (metadata != null) : "null metadata for " + table + ":" + columnFamilyName;
        this.table = table;
        this.columnFamily = columnFamilyName;
        this.metadata = metadata;
        this.minCompactionThreshold = new DefaultInteger(metadata.getMinCompactionThreshold());
        this.maxCompactionThreshold = new DefaultInteger(metadata.getMaxCompactionThreshold());
        this.partitioner = partitioner;
        this.directories = directories;
        this.indexManager = new SecondaryIndexManager(this);
        this.fileIndexGenerator.set(generation);
        CFMetaData.Caching caching = metadata.getCaching();
        if (logger.isDebugEnabled()) {
            logger.debug("Starting CFS {}", (Object)this.columnFamily);
        }
        this.data = new DataTracker(this);
        Set<DecoratedKey> savedKeys = caching == CFMetaData.Caching.NONE || caching == CFMetaData.Caching.ROWS_ONLY ? Collections.emptySet() : CacheService.instance.keyCache.readSaved(table.name, this.columnFamily);
        Directories.SSTableLister sstables = directories.sstableLister().skipCompacted(true).skipTemporary(true);
        this.data.addInitialSSTables(SSTableReader.batchOpen(sstables.list().entrySet(), savedKeys, this.data, metadata, this.partitioner));
        this.compactionStrategy = metadata.createCompactionStrategyInstance(this);
        for (ColumnDefinition info : metadata.getColumn_metadata().values()) {
            if (info.getIndexType() == null) continue;
            this.indexManager.addIndexedColumn(info);
        }
        String type = this.partitioner instanceof LocalPartitioner ? "IndexColumnFamilies" : "ColumnFamilies";
        this.mbeanName = "org.apache.cassandra.db:type=" + type + ",keyspace=" + this.table.name + ",columnfamily=" + this.columnFamily;
        try {
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            ObjectName nameObj = new ObjectName(this.mbeanName);
            mbs.registerMBean(this, nameObj);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void invalidate() {
        try {
            this.valid = false;
            this.unregisterMBean();
            this.data.unreferenceSSTables();
            this.indexManager.invalidate();
        }
        catch (Exception e) {
            logger.warn("Failed unregistering mbean: " + this.mbeanName, (Throwable)e);
        }
    }

    void unregisterMBean() throws MalformedObjectNameException, InstanceNotFoundException, MBeanRegistrationException {
        ObjectName nameObj;
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        if (mbs.isRegistered(nameObj = new ObjectName(this.mbeanName))) {
            mbs.unregisterMBean(nameObj);
        }
    }

    @Override
    public long getMinRowSize() {
        return this.data.getMinRowSize();
    }

    @Override
    public long getMaxRowSize() {
        return this.data.getMaxRowSize();
    }

    @Override
    public long getMeanRowSize() {
        return this.data.getMeanRowSize();
    }

    public int getMeanColumns() {
        return this.data.getMeanColumns();
    }

    public static ColumnFamilyStore createColumnFamilyStore(Table table, String columnFamily) {
        return ColumnFamilyStore.createColumnFamilyStore(table, columnFamily, StorageService.getPartitioner(), Schema.instance.getCFMetaData(table.name, columnFamily));
    }

    public static synchronized ColumnFamilyStore createColumnFamilyStore(Table table, String columnFamily, IPartitioner partitioner, CFMetaData metadata) {
        Directories directories = Directories.create(table.name, columnFamily);
        Directories.SSTableLister lister = directories.sstableLister().includeBackups(true);
        ArrayList<Integer> generations = new ArrayList<Integer>();
        for (Map.Entry<Descriptor, Set<Component>> entry : lister.list().entrySet()) {
            Descriptor desc = entry.getKey();
            generations.add(desc.generation);
            if (desc.isCompatible()) continue;
            throw new RuntimeException(String.format("Can't open incompatible SSTable! Current version %s, found file: %s", "hd", desc));
        }
        Collections.sort(generations);
        int value = generations.size() > 0 ? (Integer)generations.get(generations.size() - 1) : 0;
        return new ColumnFamilyStore(table, columnFamily, partitioner, value, metadata, directories);
    }

    public static void scrubDataDirectories(String table, String columnFamily) {
        CFMetaData cfm;
        logger.debug("Removing compacted SSTable files from {} (see http://wiki.apache.org/cassandra/MemtableSSTable)", (Object)columnFamily);
        Directories directories = Directories.create(table, columnFamily);
        for (Map.Entry<Descriptor, Set<Component>> sstableFiles : directories.sstableLister().list().entrySet()) {
            Descriptor desc = sstableFiles.getKey();
            Set<Component> components = sstableFiles.getValue();
            if (components.contains(Component.COMPACTED_MARKER) || desc.temporary) {
                try {
                    SSTable.delete(desc, components);
                    continue;
                }
                catch (IOException e) {
                    throw new IOError(e);
                }
            }
            File dataFile = new File(desc.filenameFor(Component.DATA));
            if (components.contains(Component.DATA) && dataFile.length() > 0L) continue;
            logger.warn("Removing orphans for {}: {}", (Object)desc, components);
            for (Component component : components) {
                try {
                    FileUtils.deleteWithConfirm(desc.filenameFor(component));
                }
                catch (IOException e) {
                    throw new IOError(e);
                }
            }
        }
        Pattern tmpCacheFilePattern = Pattern.compile(table + "-" + columnFamily + "-(Key|Row)Cache.*\\.tmp$");
        File dir = new File(DatabaseDescriptor.getSavedCachesLocation());
        if (dir.exists()) {
            assert (dir.isDirectory());
            for (File file : dir.listFiles()) {
                if (!tmpCacheFilePattern.matcher(file.getName()).matches() || file.delete()) continue;
                logger.warn("could not delete " + file.getAbsolutePath());
            }
        }
        if ((cfm = Schema.instance.getCFMetaData(table, columnFamily)) != null) {
            for (ColumnDefinition def : cfm.getColumn_metadata().values()) {
                ColumnFamilyStore.scrubDataDirectories(table, cfm.indexColumnFamilyName(def));
            }
        }
    }

    public void initRowCache() {
        if (!this.isRowCacheEnabled()) {
            return;
        }
        long start = System.currentTimeMillis();
        AutoSavingCache<RowCacheKey, IRowCacheEntry> rowCache = CacheService.instance.rowCache;
        int cachedRowsRead = 0;
        for (DecoratedKey key : rowCache.readSaved(this.table.name, this.columnFamily)) {
            ColumnFamily data = this.getTopLevelColumns(QueryFilter.getIdentityFilter(key, new QueryPath(this.columnFamily)), Integer.MIN_VALUE, true);
            CacheService.instance.rowCache.put(new RowCacheKey((int)this.metadata.cfId, key), data);
            ++cachedRowsRead;
        }
        if (cachedRowsRead > 0) {
            logger.info(String.format("completed loading (%d ms; %d keys) row cache for %s.%s", System.currentTimeMillis() - start, cachedRowsRead, this.table.name, this.columnFamily));
        }
    }

    public static synchronized void loadNewSSTables(String ksName, String cfName) {
        Table table = Table.open(ksName);
        table.getColumnFamilyStore(cfName).loadNewSSTables();
    }

    @Override
    public synchronized void loadNewSSTables() {
        logger.info("Loading new SSTables for " + this.table.name + "/" + this.columnFamily + "...");
        HashSet<Descriptor> currentDescriptors = new HashSet<Descriptor>();
        for (SSTableReader sstable : this.data.getView().sstables) {
            currentDescriptors.add(sstable.descriptor);
        }
        HashSet<SSTableReader> newSSTables = new HashSet<SSTableReader>();
        Directories.SSTableLister lister = this.directories.sstableLister().skipCompacted(true).skipTemporary(true);
        for (Map.Entry<Descriptor, Set<Component>> entry : lister.list().entrySet()) {
            SSTableReader reader;
            Descriptor descriptor = entry.getKey();
            if (currentDescriptors.contains(descriptor) || descriptor.temporary) continue;
            if (!descriptor.isCompatible()) {
                throw new RuntimeException(String.format("Can't open incompatible SSTable! Current version %s, found file: %s", "hd", descriptor));
            }
            Descriptor newDescriptor = new Descriptor(descriptor.version, descriptor.directory, descriptor.ksname, descriptor.cfname, this.fileIndexGenerator.incrementAndGet(), false);
            logger.info("Renaming new SSTable {} to {}", (Object)descriptor, (Object)newDescriptor);
            SSTableWriter.rename(descriptor, newDescriptor, entry.getValue());
            try {
                reader = SSTableReader.open(newDescriptor, entry.getValue(), Collections.<DecoratedKey>emptySet(), this.data, this.metadata, this.partitioner);
            }
            catch (IOException e) {
                SSTableReader.logOpenException(entry.getKey(), e);
                continue;
            }
            newSSTables.add(reader);
        }
        if (newSSTables.isEmpty()) {
            logger.info("No new SSTables where found for " + this.table.name + "/" + this.columnFamily);
            return;
        }
        logger.info("Loading new SSTables and building secondary indexes for " + this.table.name + "/" + this.columnFamily + ": " + newSSTables);
        SSTableReader.acquireReferences(newSSTables);
        this.data.addSSTables(newSSTables);
        try {
            this.indexManager.maybeBuildSecondaryIndexes(newSSTables, this.indexManager.getIndexedColumns());
        }
        catch (IOException e) {
            throw new IOError(e);
        }
        finally {
            SSTableReader.releaseReferences(newSSTables);
        }
        logger.info("Done loading load new SSTables for " + this.table.name + "/" + this.columnFamily);
    }

    public static void rebuildSecondaryIndex(String ksName, String cfName, String ... idxNames) {
        ColumnFamilyStore cfs = Table.open(ksName).getColumnFamilyStore(cfName);
        TreeSet<ByteBuffer> indexes = new TreeSet<ByteBuffer>(cfs.metadata.comparator);
        if (idxNames.length == 0) {
            indexes.addAll(cfs.indexManager.getIndexedColumns());
        }
        for (String idxName : idxNames) {
            indexes.add(cfs.indexManager.getColumnByIdxName(idxName));
        }
        Collection<SSTableReader> sstables = cfs.getSSTables();
        try {
            cfs.indexManager.setIndexRemoved(indexes);
            SSTableReader.acquireReferences(sstables);
            logger.info(String.format("User Requested secondary index re-build for %s/%s indexes", ksName, cfName));
            cfs.indexManager.maybeBuildSecondaryIndexes(sstables, indexes);
            cfs.indexManager.setIndexBuilt(indexes);
        }
        catch (IOException e) {
            throw new IOError(e);
        }
        finally {
            SSTableReader.releaseReferences(sstables);
        }
    }

    @Override
    public String getColumnFamilyName() {
        return this.columnFamily;
    }

    public String getFlushPath(long estimatedSize, String version) {
        File location = this.directories.getDirectoryForNewSSTables(estimatedSize);
        if (location == null) {
            throw new RuntimeException("Insufficient disk space to flush " + estimatedSize + " bytes");
        }
        return this.getTempSSTablePath(location, version);
    }

    public String getTempSSTablePath(File directory, String version) {
        Descriptor desc = new Descriptor(version, directory, this.table.name, this.columnFamily, this.fileIndexGenerator.incrementAndGet(), true);
        return desc.filenameFor(Component.DATA);
    }

    public String getTempSSTablePath(File directory) {
        return this.getTempSSTablePath(directory, "hd");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Future<?> maybeSwitchMemtable(Memtable oldMemtable, final boolean writeCommitLog) {
        if (oldMemtable.isFrozen()) {
            logger.debug("memtable is already frozen; another thread must be flushing it");
            return null;
        }
        Table.switchLock.writeLock().lock();
        try {
            if (oldMemtable.isFrozen()) {
                logger.debug("memtable is already frozen; another thread must be flushing it");
                Future<?> future = null;
                return future;
            }
            assert (this.getMemtableThreadSafe() == oldMemtable);
            ListenableFuture ctx = writeCommitLog ? CommitLog.instance.getContext() : Futures.immediateFuture((Object)ReplayPosition.NONE);
            final ArrayList<ColumnFamilyStore> icc = new ArrayList<ColumnFamilyStore>();
            for (ColumnFamilyStore cfs : this.concatWithIndexes()) {
                Memtable mt = cfs.getMemtableThreadSafe();
                if (mt.isClean() || mt.isFrozen()) continue;
                mt.freeze();
                icc.add(cfs);
            }
            final CountDownLatch latch = new CountDownLatch(icc.size());
            for (ColumnFamilyStore cfs : icc) {
                Memtable memtable = cfs.data.switchMemtable();
                logger.info("Enqueuing flush of {}", (Object)memtable);
                memtable.flushAndSignal(latch, flushWriter, (Future<ReplayPosition>)ctx);
            }
            if (this.memtableSwitchCount == Integer.MAX_VALUE) {
                this.memtableSwitchCount = 0;
            }
            ++this.memtableSwitchCount;
            Future<?> future = postFlushExecutor.submit(new WrappedRunnable((Future)ctx){
                final /* synthetic */ Future val$ctx;
                {
                    this.val$ctx = future;
                }

                @Override
                public void runMayThrow() throws InterruptedException, IOException, ExecutionException {
                    latch.await();
                    if (!icc.isEmpty()) {
                        for (SecondaryIndex index : ColumnFamilyStore.this.indexManager.getIndexesNotBackedByCfs()) {
                            logger.info("Flushing SecondaryIndex {}", (Object)index);
                            index.forceBlockingFlush();
                        }
                    }
                    if (writeCommitLog) {
                        CommitLog.instance.discardCompletedSegments(ColumnFamilyStore.this.metadata.cfId, (ReplayPosition)this.val$ctx.get());
                    }
                }
            });
            return future;
        }
        finally {
            Table.switchLock.writeLock().unlock();
        }
    }

    public Future<?> forceFlush() {
        boolean clean = true;
        for (ColumnFamilyStore cfs : this.concatWithIndexes()) {
            clean &= cfs.getMemtableThreadSafe().isClean();
        }
        if (clean) {
            logger.debug("forceFlush requested but everything is clean in {}", (Object)this.columnFamily);
            return null;
        }
        return this.maybeSwitchMemtable(this.getMemtableThreadSafe(), true);
    }

    public void forceBlockingFlush() throws ExecutionException, InterruptedException {
        Future<?> future = this.forceFlush();
        if (future != null) {
            future.get();
        }
    }

    public void updateRowCache(DecoratedKey key, ColumnFamily columnFamily) {
        if (this.metadata.cfId == null) {
            return;
        }
        RowCacheKey cacheKey = new RowCacheKey((int)this.metadata.cfId, key);
        if (CacheService.instance.rowCache.isPutCopying()) {
            this.invalidateCachedRow(cacheKey);
            return;
        }
        IRowCacheEntry cachedRow = this.getCachedRowInternal(cacheKey);
        if (cachedRow != null) {
            if (cachedRow instanceof RowCacheSentinel) {
                this.invalidateCachedRow(cacheKey);
            } else {
                ((ColumnFamily)cachedRow).addAllWithSCCopy(columnFamily, HeapAllocator.instance);
            }
        }
    }

    public void apply(DecoratedKey key, ColumnFamily columnFamily) {
        long start = System.nanoTime();
        Memtable mt = this.getMemtableThreadSafe();
        mt.put(key, columnFamily);
        this.updateRowCache(key, columnFamily);
        this.writeStats.addNano(System.nanoTime() - start);
        while (true) {
            long last = this.liveRatioComputedAt.get();
            long operations = this.writeStats.getOpCount();
            if (operations < 2L * last) break;
            if (!this.liveRatioComputedAt.compareAndSet(last, operations)) continue;
            logger.debug("computing liveRatio of {} at {} ops", (Object)this, (Object)operations);
            mt.updateLiveRatio();
        }
    }

    public static ColumnFamily removeDeletedCF(ColumnFamily cf, int gcBefore) {
        if (!(cf.getColumnCount() != 0 || cf.isMarkedForDelete() && cf.getLocalDeletionTime() >= gcBefore)) {
            return null;
        }
        cf.maybeResetDeletionTimes(gcBefore);
        return cf;
    }

    public static ColumnFamily removeDeleted(ColumnFamily cf, int gcBefore) {
        if (cf == null) {
            return null;
        }
        ColumnFamilyStore.removeDeletedColumnsOnly(cf, gcBefore);
        return ColumnFamilyStore.removeDeletedCF(cf, gcBefore);
    }

    public static void removeDeletedColumnsOnly(ColumnFamily cf, int gcBefore) {
        if (cf.isSuper()) {
            ColumnFamilyStore.removeDeletedSuper(cf, gcBefore);
        } else {
            ColumnFamilyStore.removeDeletedStandard(cf, gcBefore);
        }
    }

    private static void removeDeletedStandard(ColumnFamily cf, int gcBefore) {
        Iterator<IColumn> iter = cf.iterator();
        while (iter.hasNext()) {
            IColumn c = iter.next();
            ByteBuffer cname = c.name();
            if (c.getLocalDeletionTime() >= gcBefore && c.timestamp() > cf.getMarkedForDeleteAt()) continue;
            iter.remove();
        }
    }

    private static void removeDeletedSuper(ColumnFamily cf, int gcBefore) {
        Iterator<IColumn> iter = cf.iterator();
        while (iter.hasNext()) {
            SuperColumn c = (SuperColumn)iter.next();
            long minTimestamp = Math.max(c.getMarkedForDeleteAt(), cf.getMarkedForDeleteAt());
            Iterator<IColumn> subIter = c.getSubColumns().iterator();
            while (subIter.hasNext()) {
                IColumn subColumn = subIter.next();
                if (subColumn.timestamp() > minTimestamp && subColumn.getLocalDeletionTime() >= gcBefore) continue;
                subIter.remove();
            }
            if (c.getSubColumns().isEmpty() && (!c.isMarkedForDelete() || c.getLocalDeletionTime() < gcBefore)) {
                iter.remove();
                continue;
            }
            c.maybeResetDeletionTimes(gcBefore);
        }
    }

    public Set<SSTableReader> getOverlappingSSTables(Collection<SSTableReader> sstables) {
        if (sstables.isEmpty()) {
            return ImmutableSet.of();
        }
        IntervalTree<SSTableReader> tree = this.data.getView().intervalTree;
        Sets.SetView results = null;
        for (SSTableReader sstable : sstables) {
            ImmutableSet overlaps = ImmutableSet.copyOf(tree.search(new Interval(sstable.first, sstable.last)));
            assert (overlaps.contains(sstable));
            results = results == null ? overlaps : Sets.union((Set)results, (Set)overlaps);
        }
        results = Sets.difference(results, (Set)ImmutableSet.copyOf(sstables));
        return results;
    }

    public void addSSTable(SSTableReader sstable) {
        assert (sstable.getColumnFamilyName().equals(this.columnFamily));
        this.addSSTables(Arrays.asList(sstable));
    }

    public void addSSTables(Collection<SSTableReader> sstables) {
        this.data.addSSTables(sstables);
        CompactionManager.instance.submitBackground(this);
    }

    public long getExpectedCompactedFileSize(Iterable<SSTableReader> sstables, OperationType operation) {
        long expectedFileSize = 0L;
        if (operation == OperationType.CLEANUP) {
            Collection<Range<Token>> ranges = StorageService.instance.getLocalRanges(this.table.name);
            for (SSTableReader sstable : sstables) {
                List<Pair<Long, Long>> positions = sstable.getPositionsForRanges(ranges);
                for (Pair<Long, Long> position : positions) {
                    expectedFileSize += (Long)position.right - (Long)position.left;
                }
            }
        } else {
            for (SSTableReader sstable : sstables) {
                expectedFileSize += sstable.onDiskLength();
            }
        }
        return expectedFileSize;
    }

    public SSTableReader getMaxSizeFile(Iterable<SSTableReader> sstables) {
        long maxSize = 0L;
        SSTableReader maxFile = null;
        for (SSTableReader sstable : sstables) {
            if (sstable.onDiskLength() <= maxSize) continue;
            maxSize = sstable.onDiskLength();
            maxFile = sstable;
        }
        return maxFile;
    }

    public void forceCleanup(NodeId.OneShotRenewer renewer) throws ExecutionException, InterruptedException {
        CompactionManager.instance.performCleanup(this, renewer);
    }

    public void scrub() throws ExecutionException, InterruptedException {
        this.snapshotWithoutFlush("pre-scrub-" + System.currentTimeMillis());
        CompactionManager.instance.performScrub(this);
    }

    public void sstablesRewrite() throws ExecutionException, InterruptedException {
        CompactionManager.instance.performSSTableRewrite(this);
    }

    public void markCompacted(Collection<SSTableReader> sstables, OperationType compactionType) {
        assert (!sstables.isEmpty());
        this.data.markCompacted(sstables, compactionType);
    }

    public void replaceCompactedSSTables(Collection<SSTableReader> sstables, Iterable<SSTableReader> replacements, OperationType compactionType) {
        this.data.replaceCompactedSSTables(sstables, replacements, compactionType);
    }

    void replaceFlushed(Memtable memtable, SSTableReader sstable) {
        this.data.replaceFlushed(memtable, sstable);
        CompactionManager.instance.submitBackground(this);
    }

    public boolean isValid() {
        return this.valid;
    }

    @Override
    public long getMemtableColumnsCount() {
        return this.getMemtableThreadSafe().getOperations();
    }

    @Override
    public long getMemtableDataSize() {
        return this.getMemtableThreadSafe().getLiveSize();
    }

    public long getTotalMemtableLiveSize() {
        return this.getMemtableDataSize() + this.indexManager.getTotalLiveSize();
    }

    @Override
    public int getMemtableSwitchCount() {
        return this.memtableSwitchCount;
    }

    private Memtable getMemtableThreadSafe() {
        return this.data.getMemtable();
    }

    public DataTracker getDataTracker() {
        return this.data;
    }

    public Collection<SSTableReader> getSSTables() {
        return this.data.getSSTables();
    }

    public Set<SSTableReader> getUncompactingSSTables() {
        return this.data.getUncompactingSSTables();
    }

    @Override
    public long[] getRecentSSTablesPerReadHistogram() {
        return this.recentSSTablesPerRead.getBuckets(true);
    }

    @Override
    public long[] getSSTablesPerReadHistogram() {
        return this.sstablesPerRead.getBuckets(false);
    }

    @Override
    public long getReadCount() {
        return this.readStats.getOpCount();
    }

    @Override
    public double getRecentReadLatencyMicros() {
        return this.readStats.getRecentLatencyMicros();
    }

    @Override
    public long[] getLifetimeReadLatencyHistogramMicros() {
        return this.readStats.getTotalLatencyHistogramMicros();
    }

    @Override
    public long[] getRecentReadLatencyHistogramMicros() {
        return this.readStats.getRecentLatencyHistogramMicros();
    }

    @Override
    public long getTotalReadLatencyMicros() {
        return this.readStats.getTotalLatencyMicros();
    }

    @Override
    public int getPendingTasks() {
        return Table.switchLock.getQueueLength();
    }

    @Override
    public long getWriteCount() {
        return this.writeStats.getOpCount();
    }

    @Override
    public long getTotalWriteLatencyMicros() {
        return this.writeStats.getTotalLatencyMicros();
    }

    @Override
    public double getRecentWriteLatencyMicros() {
        return this.writeStats.getRecentLatencyMicros();
    }

    @Override
    public long[] getLifetimeWriteLatencyHistogramMicros() {
        return this.writeStats.getTotalLatencyHistogramMicros();
    }

    @Override
    public long[] getRecentWriteLatencyHistogramMicros() {
        return this.writeStats.getRecentLatencyHistogramMicros();
    }

    public ColumnFamily getColumnFamily(DecoratedKey key, QueryPath path, ByteBuffer start, ByteBuffer finish, boolean reversed, int limit) {
        return this.getColumnFamily(QueryFilter.getSliceFilter(key, path, start, finish, reversed, limit));
    }

    public ColumnFamily getColumnFamily(QueryFilter filter) {
        return this.getColumnFamily(filter, this.gcBefore());
    }

    public ColumnFamily getColumnFamily(QueryFilter filter, ISortedColumns.Factory factory) {
        return this.getColumnFamily(filter, this.gcBefore());
    }

    public int gcBefore() {
        return (int)(System.currentTimeMillis() / 1000L) - this.metadata.getGcGraceSeconds();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ColumnFamily getThroughCache(Integer cfId, QueryFilter filter) {
        assert (this.isRowCacheEnabled()) : String.format("Row cache is not enabled on column family [" + this.getColumnFamilyName() + "]", new Object[0]);
        RowCacheKey key = new RowCacheKey((int)cfId, filter.key);
        IRowCacheEntry cached = (IRowCacheEntry)CacheService.instance.rowCache.get(key);
        if (cached != null) {
            if (cached instanceof RowCacheSentinel) {
                return this.getTopLevelColumns(filter, Integer.MIN_VALUE, false);
            }
            return (ColumnFamily)cached;
        }
        RowCacheSentinel sentinel = new RowCacheSentinel();
        boolean sentinelSuccess = CacheService.instance.rowCache.putIfAbsent(key, sentinel);
        try {
            ColumnFamily data = this.getTopLevelColumns(QueryFilter.getIdentityFilter(filter.key, new QueryPath(this.columnFamily)), Integer.MIN_VALUE, true);
            if (sentinelSuccess && data != null) {
                CacheService.instance.rowCache.replace(key, sentinel, data);
            }
            ColumnFamily columnFamily = data;
            return columnFamily;
        }
        finally {
            if (sentinelSuccess && this.data == null) {
                CacheService.instance.rowCache.remove(key);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ColumnFamily getColumnFamily(QueryFilter filter, int gcBefore) {
        assert (this.columnFamily.equals(filter.getColumnFamilyName())) : filter.getColumnFamilyName();
        long start = System.nanoTime();
        try {
            if (!this.isRowCacheEnabled()) {
                ColumnFamily cf = this.getTopLevelColumns(filter, gcBefore, false);
                if (cf == null) {
                    ColumnFamily columnFamily = null;
                    return columnFamily;
                }
                ColumnFamily columnFamily = cf.isSuper() ? ColumnFamilyStore.removeDeleted(cf, gcBefore) : ColumnFamilyStore.removeDeletedCF(cf, gcBefore);
                return columnFamily;
            }
            Integer cfId = Schema.instance.getId(this.table.name, this.columnFamily);
            if (cfId == null) {
                ColumnFamily columnFamily = null;
                return columnFamily;
            }
            ColumnFamily cached = this.getThroughCache(cfId, filter);
            if (cached == null) {
                ColumnFamily columnFamily = null;
                return columnFamily;
            }
            ColumnFamily columnFamily = this.filterColumnFamily(cached, filter, gcBefore);
            return columnFamily;
        }
        finally {
            this.readStats.addNano(System.nanoTime() - start);
        }
    }

    ColumnFamily filterColumnFamily(ColumnFamily cached, QueryFilter filter, int gcBefore) {
        ColumnFamily cf = cached.cloneMeShallow(ArrayBackedSortedColumns.factory(), filter.filter.isReversed());
        IColumnIterator ci = filter.getMemtableColumnIterator(cached, null);
        filter.collateColumns(cf, Collections.singletonList(ci), gcBefore);
        return cf.isSuper() ? ColumnFamilyStore.removeDeleted(cf, gcBefore) : ColumnFamilyStore.removeDeletedCF(cf, gcBefore);
    }

    private DataTracker.View markCurrentViewReferenced() {
        DataTracker.View currentView;
        do {
            currentView = this.data.getView();
        } while (!SSTableReader.acquireReferences(currentView.sstables));
        return currentView;
    }

    public Collection<SSTableReader> markCurrentSSTablesReferenced() {
        return this.markCurrentViewReferenced().sstables;
    }

    public ViewFragment markReferenced(DecoratedKey key) {
        DataTracker.View view;
        List<SSTableReader> sstables;
        assert (!key.isMinimum());
        do {
            view = this.data.getView();
        } while (!SSTableReader.acquireReferences(sstables = view.intervalTree.search(new Interval(key, key))));
        return new ViewFragment(sstables, Iterables.concat(Collections.singleton(view.memtable), view.memtablesPendingFlush));
    }

    public ViewFragment markReferenced(RowPosition startWith, RowPosition stopAt) {
        RowPosition stopInTree;
        DataTracker.View view;
        List<SSTableReader> sstables;
        do {
            view = this.data.getView();
        } while (!SSTableReader.acquireReferences(sstables = view.intervalTree.search(new Interval(startWith, stopInTree = stopAt.isMinimum() ? view.intervalTree.max() : stopAt))));
        return new ViewFragment(sstables, Iterables.concat(Collections.singleton(view.memtable), view.memtablesPendingFlush));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getSSTablesForKey(String key) {
        DecoratedKey dk = new DecoratedKey(this.partitioner.getToken(ByteBuffer.wrap(key.getBytes())), ByteBuffer.wrap(key.getBytes()));
        ViewFragment view = this.markReferenced(dk);
        try {
            ArrayList<String> files = new ArrayList<String>();
            for (SSTableReader sstr : view.sstables) {
                if (sstr.getPosition(dk, SSTableReader.Operator.EQ, false) <= -1L) continue;
                files.add(sstr.getFilename());
            }
            ArrayList<String> arrayList = files;
            return arrayList;
        }
        finally {
            SSTableReader.releaseReferences(view.sstables);
        }
    }

    private ColumnFamily getTopLevelColumns(QueryFilter filter, int gcBefore, boolean forCache) {
        CollationController controller = new CollationController(this, forCache, filter, gcBefore);
        ColumnFamily columns = controller.getTopLevelColumns();
        this.recentSSTablesPerRead.add(controller.getSstablesIterated());
        this.sstablesPerRead.add(controller.getSstablesIterated());
        return columns;
    }

    public AbstractScanIterator getSequentialIterator(ByteBuffer superColumn, final AbstractBounds<RowPosition> range, IFilter columnFilter) {
        assert (!(range instanceof Range) || !((Range)range).isWrapAround() || ((RowPosition)range.right).isMinimum()) : range;
        RowPosition startWith = (RowPosition)range.left;
        final RowPosition stopAt = (RowPosition)range.right;
        QueryFilter filter = new QueryFilter(null, new QueryPath(this.columnFamily, superColumn, null), columnFilter);
        final ViewFragment view = this.markReferenced(startWith, stopAt);
        try {
            final CloseableIterator<Row> iterator = RowIteratorFactory.getIterator(view.memtables, view.sstables, startWith, stopAt, filter, this);
            final int gcBefore = (int)(System.currentTimeMillis() / 1000L) - this.metadata.getGcGraceSeconds();
            return new AbstractScanIterator(){

                protected Row computeNext() {
                    if (!iterator.hasNext()) {
                        return (Row)this.endOfData();
                    }
                    Row current = (Row)iterator.next();
                    DecoratedKey<?> key = current.key;
                    if (!stopAt.isMinimum() && stopAt.compareTo(key) < 0) {
                        return (Row)this.endOfData();
                    }
                    if (!range.contains(key)) {
                        return this.computeNext();
                    }
                    if (logger.isDebugEnabled()) {
                        logger.debug("scanned " + key);
                    }
                    return current.cf != null && current.cf.isSuper() ? new Row(current.key, ColumnFamilyStore.removeDeleted(current.cf, gcBefore)) : current;
                }

                @Override
                public void close() throws IOException {
                    SSTableReader.releaseReferences(view.sstables);
                    try {
                        iterator.close();
                    }
                    catch (IOException e) {
                        throw new IOError(e);
                    }
                }
            };
        }
        catch (RuntimeException e) {
            SSTableReader.releaseReferences(view.sstables);
            throw e;
        }
    }

    public List<Row> getRangeSlice(ByteBuffer superColumn, AbstractBounds<RowPosition> range, int maxResults, IFilter columnFilter, List<IndexExpression> rowFilter) {
        return this.getRangeSlice(superColumn, range, maxResults, columnFilter, rowFilter, false, false);
    }

    public List<Row> getRangeSlice(ByteBuffer superColumn, AbstractBounds<RowPosition> range, int maxResults, IFilter columnFilter, List<IndexExpression> rowFilter, boolean maxIsColumns, boolean isPaging) {
        return this.filter(this.getSequentialIterator(superColumn, range, columnFilter), ExtendedFilter.create(this, columnFilter, rowFilter, maxResults, maxIsColumns, isPaging));
    }

    public List<Row> search(List<IndexExpression> clause, AbstractBounds<RowPosition> range, int maxResults, IFilter dataFilter) {
        return this.search(clause, range, maxResults, dataFilter, false);
    }

    public List<Row> search(List<IndexExpression> clause, AbstractBounds<RowPosition> range, int maxResults, IFilter dataFilter, boolean maxIsColumns) {
        return this.indexManager.search(clause, range, maxResults, dataFilter, maxIsColumns);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Row> filter(AbstractScanIterator rowIterator, ExtendedFilter filter) {
        if (logger.isDebugEnabled()) {
            logger.debug("Filtering {} for rows matching {}", (Object)rowIterator, (Object)filter);
        }
        ArrayList<Row> rows = new ArrayList<Row>();
        int columnsCount = 0;
        try {
            while (rowIterator.hasNext() && rows.size() < filter.maxRows() && columnsCount < filter.maxColumns()) {
                QueryPath path;
                ColumnFamily cf;
                Row rawRow = (Row)rowIterator.next();
                ColumnFamily data = rawRow.cf;
                IFilter extraFilter = filter.getExtraFilter(data);
                if (extraFilter != null && (cf = filter.cfs.getColumnFamily(new QueryFilter(rawRow.key, path = new QueryPath(this.columnFamily), extraFilter))) != null) {
                    data.addAll(cf, HeapAllocator.instance);
                }
                if (!filter.isSatisfiedBy(data)) continue;
                logger.debug("{} satisfies all filter expressions", (Object)data);
                data = filter.prune(data);
                rows.add(new Row(rawRow.key, data));
                if (data != null) {
                    columnsCount += data.getLiveColumnCount();
                }
                filter.updateFilter(columnsCount);
            }
            ArrayList<Row> arrayList = rows;
            return arrayList;
        }
        finally {
            try {
                rowIterator.close();
            }
            catch (IOException e) {
                throw new IOError(e);
            }
        }
    }

    public AbstractType<?> getComparator() {
        return this.metadata.comparator;
    }

    public void snapshotWithoutFlush(String snapshotName) {
        for (ColumnFamilyStore cfs : this.concatWithIndexes()) {
            DataTracker.View currentView = cfs.markCurrentViewReferenced();
            try {
                for (SSTableReader ssTable : currentView.sstables) {
                    File snapshotDirectory = Directories.getSnapshotDirectory(ssTable.descriptor, snapshotName);
                    ssTable.createLinks(snapshotDirectory.getPath());
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug("Snapshot for " + this.table + " keyspace data file " + ssTable.getFilename() + " created in " + snapshotDirectory);
                }
                if (!(cfs.compactionStrategy instanceof LeveledCompactionStrategy)) continue;
                cfs.directories.snapshotLeveledManifest(snapshotName);
            }
            catch (IOException e) {
                throw new IOError(e);
            }
            finally {
                SSTableReader.releaseReferences(currentView.sstables);
            }
        }
    }

    public List<SSTableReader> getSnapshotSSTableReader(String tag) throws IOException {
        Map<Descriptor, Set<Component>> snapshots = this.directories.sstableLister().snapshots(tag).list();
        ArrayList<SSTableReader> readers = new ArrayList<SSTableReader>(snapshots.size());
        for (Map.Entry<Descriptor, Set<Component>> entries : snapshots.entrySet()) {
            readers.add(SSTableReader.open(entries.getKey(), entries.getValue(), this.metadata, this.partitioner));
        }
        return readers;
    }

    public void snapshot(String snapshotName) {
        try {
            this.forceBlockingFlush();
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
        catch (InterruptedException e) {
            throw new AssertionError((Object)e);
        }
        this.snapshotWithoutFlush(snapshotName);
    }

    public boolean snapshotExists(String snapshotName) {
        return this.directories.snapshotExists(snapshotName);
    }

    public void clearSnapshot(String snapshotName) throws IOException {
        this.directories.clearSnapshot(snapshotName);
    }

    public boolean hasUnreclaimedSpace() {
        return this.data.getLiveSize() < this.data.getTotalSize();
    }

    @Override
    public long getTotalDiskSpaceUsed() {
        return this.data.getTotalSize();
    }

    @Override
    public long getLiveDiskSpaceUsed() {
        return this.data.getLiveSize();
    }

    @Override
    public int getLiveSSTableCount() {
        return this.data.getSSTables().size();
    }

    public ColumnFamily getRawCachedRow(DecoratedKey key) {
        if (this.metadata.cfId == null) {
            return null;
        }
        IRowCacheEntry cached = this.getCachedRowInternal(new RowCacheKey((int)this.metadata.cfId, key));
        return cached == null || cached instanceof RowCacheSentinel ? null : (ColumnFamily)cached;
    }

    private IRowCacheEntry getCachedRowInternal(RowCacheKey key) {
        return CacheService.instance.rowCache.getCapacity() == 0L ? null : (IRowCacheEntry)CacheService.instance.rowCache.getInternal(key);
    }

    public boolean containsCachedRow(DecoratedKey key) {
        return CacheService.instance.rowCache.getCapacity() != 0L && CacheService.instance.rowCache.containsKey(new RowCacheKey((int)this.metadata.cfId, key));
    }

    public void invalidateCachedRow(RowCacheKey key) {
        CacheService.instance.rowCache.remove(key);
    }

    public void invalidateCachedRow(DecoratedKey key) {
        Integer cfId = Schema.instance.getId(this.table.name, this.columnFamily);
        if (cfId == null) {
            return;
        }
        this.invalidateCachedRow(new RowCacheKey((int)cfId, key));
    }

    @Override
    public void forceMajorCompaction() throws InterruptedException, ExecutionException {
        CompactionManager.instance.performMaximal(this);
    }

    public static Iterable<ColumnFamilyStore> all() {
        ArrayList<Collection<ColumnFamilyStore>> stores = new ArrayList<Collection<ColumnFamilyStore>>(Schema.instance.getTables().size());
        for (Table table : Table.all()) {
            stores.add(table.getColumnFamilyStores());
        }
        return Iterables.concat(stores);
    }

    public static List<ColumnFamilyStore> allUserDefined() {
        ArrayList<ColumnFamilyStore> cfses = new ArrayList<ColumnFamilyStore>();
        for (Table table : Sets.difference((Set)ImmutableSet.copyOf(Table.all()), (Set)ImmutableSet.of((Object)Table.open("system")))) {
            cfses.addAll(table.getColumnFamilyStores());
        }
        return cfses;
    }

    public Iterable<DecoratedKey<?>> keySamples(Range<Token> range) {
        Collection<SSTableReader> sstables = this.getSSTables();
        Iterable[] samples = new Iterable[sstables.size()];
        int i = 0;
        for (SSTableReader sstable : sstables) {
            samples[i++] = sstable.getKeySamples(range);
        }
        return Iterables.concat((Iterable[])samples);
    }

    public void clearUnsafe() {
        for (ColumnFamilyStore cfs : this.concatWithIndexes()) {
            cfs.data.init();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForActiveFlushes() {
        Future<?> future;
        Table.switchLock.writeLock().lock();
        try {
            future = postFlushExecutor.submit(new Runnable(){

                @Override
                public void run() {
                }
            });
        }
        finally {
            Table.switchLock.writeLock().unlock();
        }
        try {
            future.get();
        }
        catch (InterruptedException e) {
            throw new AssertionError((Object)e);
        }
        catch (ExecutionException e) {
            throw new AssertionError((Object)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Future<?> truncate() throws IOException, ExecutionException, InterruptedException {
        logger.debug("truncating {}", (Object)this.columnFamily);
        if (DatabaseDescriptor.isAutoSnapshot()) {
            this.forceBlockingFlush();
        } else {
            Table.switchLock.writeLock().lock();
            try {
                for (ColumnFamilyStore cfs : this.concatWithIndexes()) {
                    Memtable mt = cfs.getMemtableThreadSafe();
                    if (mt.isClean() || mt.isFrozen()) continue;
                    mt.cfs.data.renewMemtable();
                }
            }
            finally {
                Table.switchLock.writeLock().unlock();
            }
        }
        KSMetaData ksm = Schema.instance.getKSMetaData(this.table.name);
        if (ksm.durableWrites) {
            CommitLog.instance.forceNewSegment();
            Future<ReplayPosition> position = CommitLog.instance.getContext();
            for (ColumnFamilyStore cfs : ColumnFamilyStore.all()) {
                cfs.forceFlush();
            }
            this.waitForActiveFlushes();
            CommitLog.instance.discardCompletedSegments(this.metadata.cfId, position.get());
        }
        try {
            long starttime = System.currentTimeMillis();
            while (System.currentTimeMillis() - starttime < 1L) {
                Thread.sleep(1L);
            }
        }
        catch (InterruptedException e) {
            throw new AssertionError((Object)e);
        }
        long truncatedAt = System.currentTimeMillis();
        if (DatabaseDescriptor.isAutoSnapshot()) {
            this.snapshot(Table.getTimestampedSnapshotName(this.columnFamily));
        }
        return CompactionManager.instance.submitTruncate(this, truncatedAt);
    }

    @Override
    public long getBloomFilterFalsePositives() {
        return this.data.getBloomFilterFalsePositives();
    }

    @Override
    public long getRecentBloomFilterFalsePositives() {
        return this.data.getRecentBloomFilterFalsePositives();
    }

    @Override
    public double getBloomFilterFalseRatio() {
        return this.data.getBloomFilterFalseRatio();
    }

    @Override
    public double getRecentBloomFilterFalseRatio() {
        return this.data.getRecentBloomFilterFalseRatio();
    }

    @Override
    public long getBloomFilterDiskSpaceUsed() {
        long total = 0L;
        for (SSTableReader sst : this.getSSTables()) {
            total += sst.getBloomFilterSerializedSize();
        }
        return total;
    }

    public String toString() {
        return "CFS(Keyspace='" + this.table.name + '\'' + ", ColumnFamily='" + this.columnFamily + '\'' + ')';
    }

    @Override
    public void disableAutoCompaction() {
        this.minCompactionThreshold.set(0);
        this.maxCompactionThreshold.set(0);
    }

    public AbstractCompactionStrategy getCompactionStrategy() {
        return this.compactionStrategy;
    }

    @Override
    public int getMinimumCompactionThreshold() {
        return this.minCompactionThreshold.value();
    }

    @Override
    public void setMinimumCompactionThreshold(int minCompactionThreshold) {
        if (minCompactionThreshold > this.maxCompactionThreshold.value() && this.maxCompactionThreshold.value() != 0) {
            throw new RuntimeException("The min_compaction_threshold cannot be larger than the max.");
        }
        this.minCompactionThreshold.set(minCompactionThreshold);
        if (this.compactionStrategy != null) {
            CompactionManager.instance.submitBackground(this);
        }
    }

    @Override
    public int getMaximumCompactionThreshold() {
        return this.maxCompactionThreshold.value();
    }

    @Override
    public void setMaximumCompactionThreshold(int maxCompactionThreshold) {
        if (maxCompactionThreshold > 0 && maxCompactionThreshold < this.minCompactionThreshold.value()) {
            throw new RuntimeException("The max_compaction_threshold cannot be smaller than the min.");
        }
        this.maxCompactionThreshold.set(maxCompactionThreshold);
        if (this.compactionStrategy != null) {
            CompactionManager.instance.submitBackground(this);
        }
    }

    public boolean isCompactionDisabled() {
        return this.getMinimumCompactionThreshold() <= 0 || this.getMaximumCompactionThreshold() <= 0;
    }

    @Override
    public long estimateKeys() {
        return this.data.estimatedKeys();
    }

    @Override
    public long[] getEstimatedRowSizeHistogram() {
        return this.data.getEstimatedRowSizeHistogram();
    }

    @Override
    public long[] getEstimatedColumnCountHistogram() {
        return this.data.getEstimatedColumnCountHistogram();
    }

    @Override
    public double getCompressionRatio() {
        return this.data.getCompressionRatio();
    }

    public boolean isIndex() {
        return this.partitioner instanceof LocalPartitioner;
    }

    private String getParentColumnfamily() {
        assert (this.isIndex());
        return this.columnFamily.split("\\.")[0];
    }

    private ByteBuffer intern(ByteBuffer name) {
        ByteBuffer concurrentName;
        ByteBuffer internedName = (ByteBuffer)this.internedNames.get(name);
        if (internedName == null && (concurrentName = this.internedNames.putIfAbsent(internedName = ByteBufferUtil.clone(name), internedName)) != null) {
            internedName = concurrentName;
        }
        return internedName;
    }

    public ByteBuffer internOrCopy(ByteBuffer name, Allocator allocator) {
        if (this.internedNames.size() >= 256) {
            return allocator.clone(name);
        }
        return this.intern(name);
    }

    public ByteBuffer maybeIntern(ByteBuffer name) {
        if (this.internedNames.size() >= 256) {
            return null;
        }
        return this.intern(name);
    }

    public SSTableWriter createFlushWriter(long estimatedRows, long estimatedSize, ReplayPosition context) throws IOException {
        SSTableMetadata.Collector sstableMetadataCollector = SSTableMetadata.createCollector().replayPosition(context);
        return new SSTableWriter(this.getFlushPath(estimatedSize, "hd"), estimatedRows, this.metadata, this.partitioner, sstableMetadataCollector);
    }

    public SSTableWriter createCompactionWriter(long estimatedRows, File location, Collection<SSTableReader> sstables) throws IOException {
        ReplayPosition rp = ReplayPosition.getReplayPosition(sstables);
        SSTableMetadata.Collector sstableMetadataCollector = SSTableMetadata.createCollector().replayPosition(rp);
        for (SSTableReader sstable : sstables) {
            sstableMetadataCollector.updateMaxTimestamp(sstable.getMaxTimestamp());
        }
        return new SSTableWriter(this.getTempSSTablePath(location), estimatedRows, this.metadata, this.partitioner, sstableMetadataCollector);
    }

    public Iterable<ColumnFamilyStore> concatWithIndexes() {
        return Iterables.concat(this.indexManager.getIndexesBackedByCfs(), Collections.singleton(this));
    }

    public Set<Memtable> getMemtablesPendingFlush() {
        return this.data.getMemtablesPendingFlush();
    }

    @Override
    public List<String> getBuiltIndexes() {
        return this.indexManager.getBuiltIndexes();
    }

    @Override
    public int getUnleveledSSTables() {
        return this.compactionStrategy instanceof LeveledCompactionStrategy ? ((LeveledCompactionStrategy)this.compactionStrategy).getLevelSize(0) : 0;
    }

    public long oldestUnflushedMemtable() {
        DataTracker.View view = this.data.getView();
        long oldest = view.memtable.creationTime();
        for (Memtable memtable : view.memtablesPendingFlush) {
            oldest = Math.min(oldest, memtable.creationTime());
        }
        return oldest;
    }

    public boolean isEmpty() {
        DataTracker.View view = this.data.getView();
        return view.sstables.isEmpty() && view.memtable.getOperations() == 0L && view.memtablesPendingFlush.isEmpty();
    }

    private boolean isRowCacheEnabled() {
        return this.metadata.getCaching() != CFMetaData.Caching.NONE && this.metadata.getCaching() != CFMetaData.Caching.KEYS_ONLY && CacheService.instance.rowCache.getCapacity() != 0L;
    }

    public void discardSSTables(long truncatedAt) {
        ArrayList<SSTableReader> truncatedSSTables = new ArrayList<SSTableReader>();
        for (SSTableReader sstable : this.getSSTables()) {
            if (sstable.newSince(truncatedAt)) continue;
            truncatedSSTables.add(sstable);
        }
        if (!truncatedSSTables.isEmpty()) {
            this.markCompacted(truncatedSSTables, OperationType.UNKNOWN);
        }
    }

    static {
        StorageService.optionalTasks.scheduleWithFixedDelay(new MeteredFlusher(), 1000L, 1000L, TimeUnit.MILLISECONDS);
    }

    public static class ViewFragment {
        public final List<SSTableReader> sstables;
        public final Iterable<Memtable> memtables;

        public ViewFragment(List<SSTableReader> sstables, Iterable<Memtable> memtables) {
            this.sstables = sstables;
            this.memtables = memtables;
        }
    }

    public static abstract class AbstractScanIterator
    extends AbstractIterator<Row>
    implements CloseableIterator<Row> {
    }
}

