/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.config;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.cassandra.auth.AllowAllAuthenticator;
import org.apache.cassandra.auth.AllowAllAuthority;
import org.apache.cassandra.auth.IAuthenticator;
import org.apache.cassandra.auth.IAuthority;
import org.apache.cassandra.cache.IRowCacheProvider;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.Config;
import org.apache.cassandra.config.ConfigurationException;
import org.apache.cassandra.config.EncryptionOptions;
import org.apache.cassandra.config.KSMetaData;
import org.apache.cassandra.config.RequestSchedulerOptions;
import org.apache.cassandra.config.Schema;
import org.apache.cassandra.config.SeedProviderDef;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.DefsTable;
import org.apache.cassandra.db.SystemTable;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.cassandra.io.util.MmappedSegmentedFile;
import org.apache.cassandra.locator.DynamicEndpointSnitch;
import org.apache.cassandra.locator.EndpointSnitchInfo;
import org.apache.cassandra.locator.IEndpointSnitch;
import org.apache.cassandra.locator.SeedProvider;
import org.apache.cassandra.scheduler.IRequestScheduler;
import org.apache.cassandra.scheduler.NoScheduler;
import org.apache.cassandra.service.CacheService;
import org.apache.cassandra.service.MigrationManager;
import org.apache.cassandra.thrift.CassandraDaemon;
import org.apache.cassandra.utils.FBUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.Loader;
import org.yaml.snakeyaml.TypeDescription;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.Constructor;
import org.yaml.snakeyaml.error.YAMLException;

public class DatabaseDescriptor {
    private static Logger logger = LoggerFactory.getLogger(DatabaseDescriptor.class);
    private static IEndpointSnitch snitch;
    private static InetAddress listenAddress;
    private static InetAddress broadcastAddress;
    private static InetAddress rpcAddress;
    private static SeedProvider seedProvider;
    private static IPartitioner partitioner;
    private static Config.DiskAccessMode indexAccessMode;
    private static Config conf;
    private static IAuthenticator authenticator;
    private static IAuthority authority;
    private static final String DEFAULT_CONFIGURATION = "cassandra.yaml";
    private static IRequestScheduler requestScheduler;
    private static Config.RequestSchedulerId requestSchedulerId;
    private static RequestSchedulerOptions requestSchedulerOptions;
    private static long keyCacheSizeInMB;
    private static IRowCacheProvider rowCacheProvider;

    static URL getStorageConfigURL() throws ConfigurationException {
        URL url;
        block3: {
            String configUrl = System.getProperty("cassandra.config");
            if (configUrl == null) {
                configUrl = DEFAULT_CONFIGURATION;
            }
            try {
                url = new URL(configUrl);
                url.openStream().close();
            }
            catch (Exception e) {
                ClassLoader loader = DatabaseDescriptor.class.getClassLoader();
                url = loader.getResource(configUrl);
                if (url != null) break block3;
                throw new ConfigurationException("Cannot locate " + configUrl);
            }
        }
        return url;
    }

    static void loadYaml() {
        try {
            URL url = DatabaseDescriptor.getStorageConfigURL();
            logger.info("Loading settings from " + url);
            InputStream input = null;
            try {
                input = url.openStream();
            }
            catch (IOException e) {
                throw new AssertionError((Object)e);
            }
            Constructor constructor = new Constructor(Config.class);
            TypeDescription seedDesc = new TypeDescription(SeedProviderDef.class);
            seedDesc.putMapPropertyType("parameters", String.class, String.class);
            constructor.addTypeDescription(seedDesc);
            Yaml yaml = new Yaml(new Loader((BaseConstructor)constructor));
            conf = (Config)yaml.load(input);
            if (DatabaseDescriptor.conf.commitlog_sync == null) {
                throw new ConfigurationException("Missing required directive CommitLogSync");
            }
            if (DatabaseDescriptor.conf.commitlog_sync == Config.CommitLogSync.batch) {
                if (DatabaseDescriptor.conf.commitlog_sync_batch_window_in_ms == null) {
                    throw new ConfigurationException("Missing value for commitlog_sync_batch_window_in_ms: Double expected.");
                }
                if (DatabaseDescriptor.conf.commitlog_sync_period_in_ms != null) {
                    throw new ConfigurationException("Batch sync specified, but commitlog_sync_period_in_ms found. Only specify commitlog_sync_batch_window_in_ms when using batch sync");
                }
                logger.debug("Syncing log with a batch window of " + DatabaseDescriptor.conf.commitlog_sync_batch_window_in_ms);
            } else {
                if (DatabaseDescriptor.conf.commitlog_sync_period_in_ms == null) {
                    throw new ConfigurationException("Missing value for commitlog_sync_period_in_ms: Integer expected");
                }
                if (DatabaseDescriptor.conf.commitlog_sync_batch_window_in_ms != null) {
                    throw new ConfigurationException("commitlog_sync_period_in_ms specified, but commitlog_sync_batch_window_in_ms found.  Only specify commitlog_sync_period_in_ms when using periodic sync.");
                }
                logger.debug("Syncing log with a period of " + DatabaseDescriptor.conf.commitlog_sync_period_in_ms);
            }
            if (DatabaseDescriptor.conf.disk_access_mode == Config.DiskAccessMode.auto) {
                indexAccessMode = DatabaseDescriptor.conf.disk_access_mode = System.getProperty("os.arch").contains("64") ? Config.DiskAccessMode.mmap : Config.DiskAccessMode.standard;
                logger.info("DiskAccessMode 'auto' determined to be " + (Object)((Object)DatabaseDescriptor.conf.disk_access_mode) + ", indexAccessMode is " + (Object)((Object)indexAccessMode));
            } else if (DatabaseDescriptor.conf.disk_access_mode == Config.DiskAccessMode.mmap_index_only) {
                DatabaseDescriptor.conf.disk_access_mode = Config.DiskAccessMode.standard;
                indexAccessMode = Config.DiskAccessMode.mmap;
                logger.info("DiskAccessMode is " + (Object)((Object)DatabaseDescriptor.conf.disk_access_mode) + ", indexAccessMode is " + (Object)((Object)indexAccessMode));
            } else {
                indexAccessMode = DatabaseDescriptor.conf.disk_access_mode;
                logger.info("DiskAccessMode is " + (Object)((Object)DatabaseDescriptor.conf.disk_access_mode) + ", indexAccessMode is " + (Object)((Object)indexAccessMode));
            }
            if (DatabaseDescriptor.conf.disk_access_mode == Config.DiskAccessMode.mmap) {
                MmappedSegmentedFile.initCleaner();
            }
            logger.debug("page_cache_hinting is " + DatabaseDescriptor.conf.populate_io_cache_on_flush);
            if (DatabaseDescriptor.conf.authenticator != null) {
                authenticator = (IAuthenticator)FBUtilities.construct(DatabaseDescriptor.conf.authenticator, "authenticator");
            }
            if (DatabaseDescriptor.conf.authority != null) {
                authority = (IAuthority)FBUtilities.construct(DatabaseDescriptor.conf.authority, "authority");
            }
            authenticator.validateConfiguration();
            authority.validateConfiguration();
            if (DatabaseDescriptor.conf.partitioner == null) {
                throw new ConfigurationException("Missing directive: partitioner");
            }
            try {
                partitioner = FBUtilities.newPartitioner(System.getProperty("cassandra.partitioner", DatabaseDescriptor.conf.partitioner));
            }
            catch (Exception e) {
                throw new ConfigurationException("Invalid partitioner class " + DatabaseDescriptor.conf.partitioner);
            }
            if (DatabaseDescriptor.conf.phi_convict_threshold < 5 || DatabaseDescriptor.conf.phi_convict_threshold > 16) {
                throw new ConfigurationException("phi_convict_threshold must be between 5 and 16");
            }
            if (DatabaseDescriptor.conf.concurrent_reads != null && DatabaseDescriptor.conf.concurrent_reads < 2) {
                throw new ConfigurationException("concurrent_reads must be at least 2");
            }
            if (DatabaseDescriptor.conf.concurrent_writes != null && DatabaseDescriptor.conf.concurrent_writes < 2) {
                throw new ConfigurationException("concurrent_writes must be at least 2");
            }
            if (DatabaseDescriptor.conf.concurrent_replicates != null && DatabaseDescriptor.conf.concurrent_replicates < 2) {
                throw new ConfigurationException("concurrent_replicates must be at least 2");
            }
            if (DatabaseDescriptor.conf.memtable_total_space_in_mb == null) {
                DatabaseDescriptor.conf.memtable_total_space_in_mb = (int)(Runtime.getRuntime().maxMemory() / 0x300000L);
            }
            if (DatabaseDescriptor.conf.memtable_total_space_in_mb <= 0) {
                throw new ConfigurationException("memtable_total_space_in_mb must be positive");
            }
            logger.info("Global memtable threshold is enabled at {}MB", (Object)DatabaseDescriptor.conf.memtable_total_space_in_mb);
            if (DatabaseDescriptor.conf.memtable_flush_writers != null && DatabaseDescriptor.conf.memtable_flush_writers < 1) {
                throw new ConfigurationException("memtable_flush_writers must be at least 1");
            }
            if (DatabaseDescriptor.conf.memtable_flush_writers == null) {
                DatabaseDescriptor.conf.memtable_flush_writers = DatabaseDescriptor.conf.data_file_directories.length;
            }
            if (DatabaseDescriptor.conf.listen_address != null) {
                try {
                    listenAddress = InetAddress.getByName(DatabaseDescriptor.conf.listen_address);
                }
                catch (UnknownHostException e) {
                    throw new ConfigurationException("Unknown listen_address '" + DatabaseDescriptor.conf.listen_address + "'");
                }
            }
            if (DatabaseDescriptor.conf.broadcast_address != null) {
                if (DatabaseDescriptor.conf.broadcast_address.equals("0.0.0.0")) {
                    throw new ConfigurationException("broadcast_address cannot be 0.0.0.0!");
                }
                try {
                    broadcastAddress = InetAddress.getByName(DatabaseDescriptor.conf.broadcast_address);
                }
                catch (UnknownHostException e) {
                    throw new ConfigurationException("Unknown broadcast_address '" + DatabaseDescriptor.conf.broadcast_address + "'");
                }
            }
            if (DatabaseDescriptor.conf.rpc_address != null) {
                try {
                    rpcAddress = InetAddress.getByName(DatabaseDescriptor.conf.rpc_address);
                }
                catch (UnknownHostException e) {
                    throw new ConfigurationException("Unknown host in rpc_address " + DatabaseDescriptor.conf.rpc_address);
                }
            } else {
                rpcAddress = FBUtilities.getLocalAddress();
            }
            if (DatabaseDescriptor.conf.thrift_framed_transport_size_in_mb <= 0) {
                throw new ConfigurationException("thrift_framed_transport_size_in_mb must be positive");
            }
            if (DatabaseDescriptor.conf.thrift_framed_transport_size_in_mb > 0 && DatabaseDescriptor.conf.thrift_max_message_length_in_mb < DatabaseDescriptor.conf.thrift_framed_transport_size_in_mb) {
                throw new ConfigurationException("thrift_max_message_length_in_mb must be greater than thrift_framed_transport_size_in_mb when using TFramedTransport");
            }
            if (DatabaseDescriptor.conf.endpoint_snitch == null) {
                throw new ConfigurationException("Missing endpoint_snitch directive");
            }
            snitch = DatabaseDescriptor.createEndpointSnitch(DatabaseDescriptor.conf.endpoint_snitch);
            EndpointSnitchInfo.create();
            requestSchedulerOptions = DatabaseDescriptor.conf.request_scheduler_options;
            if (DatabaseDescriptor.conf.request_scheduler != null) {
                try {
                    if (requestSchedulerOptions == null) {
                        requestSchedulerOptions = new RequestSchedulerOptions();
                    }
                    Class<?> cls = Class.forName(DatabaseDescriptor.conf.request_scheduler);
                    requestScheduler = (IRequestScheduler)cls.getConstructor(RequestSchedulerOptions.class).newInstance(requestSchedulerOptions);
                }
                catch (ClassNotFoundException e) {
                    throw new ConfigurationException("Invalid Request Scheduler class " + DatabaseDescriptor.conf.request_scheduler);
                }
                catch (Exception e) {
                    throw new ConfigurationException("Unable to instantiate request scheduler", e);
                }
            } else {
                requestScheduler = new NoScheduler();
            }
            requestSchedulerId = DatabaseDescriptor.conf.request_scheduler_id == Config.RequestSchedulerId.keyspace ? DatabaseDescriptor.conf.request_scheduler_id : Config.RequestSchedulerId.keyspace;
            if (logger.isDebugEnabled() && DatabaseDescriptor.conf.auto_bootstrap != null) {
                logger.debug("setting auto_bootstrap to " + DatabaseDescriptor.conf.auto_bootstrap);
            }
            if (DatabaseDescriptor.conf.in_memory_compaction_limit_in_mb != null && DatabaseDescriptor.conf.in_memory_compaction_limit_in_mb <= 0) {
                throw new ConfigurationException("in_memory_compaction_limit_in_mb must be a positive integer");
            }
            if (DatabaseDescriptor.conf.concurrent_compactors == null) {
                DatabaseDescriptor.conf.concurrent_compactors = Runtime.getRuntime().availableProcessors();
            }
            if (DatabaseDescriptor.conf.concurrent_compactors <= 0) {
                throw new ConfigurationException("concurrent_compactors should be strictly greater than 0");
            }
            if (DatabaseDescriptor.conf.compaction_throughput_mb_per_sec == null) {
                DatabaseDescriptor.conf.compaction_throughput_mb_per_sec = 16;
            }
            if (DatabaseDescriptor.conf.stream_throughput_outbound_megabits_per_sec == null) {
                DatabaseDescriptor.conf.stream_throughput_outbound_megabits_per_sec = 400;
            }
            if (!CassandraDaemon.rpc_server_types.contains(DatabaseDescriptor.conf.rpc_server_type.toLowerCase())) {
                throw new ConfigurationException("Unknown rpc_server_type: " + DatabaseDescriptor.conf.rpc_server_type);
            }
            if (DatabaseDescriptor.conf.rpc_min_threads == null) {
                DatabaseDescriptor.conf.rpc_min_threads = DatabaseDescriptor.conf.rpc_server_type.toLowerCase().equals("hsha") ? Runtime.getRuntime().availableProcessors() * 4 : 16;
            }
            if (DatabaseDescriptor.conf.rpc_max_threads == null) {
                DatabaseDescriptor.conf.rpc_max_threads = DatabaseDescriptor.conf.rpc_server_type.toLowerCase().equals("hsha") ? Runtime.getRuntime().availableProcessors() * 4 : Integer.MAX_VALUE;
            }
            if (DatabaseDescriptor.conf.commitlog_directory != null && DatabaseDescriptor.conf.data_file_directories != null && DatabaseDescriptor.conf.saved_caches_directory != null) {
                for (String datadir : DatabaseDescriptor.conf.data_file_directories) {
                    if (datadir.equals(DatabaseDescriptor.conf.commitlog_directory)) {
                        throw new ConfigurationException("commitlog_directory must not be the same as any data_file_directories");
                    }
                    if (!datadir.equals(DatabaseDescriptor.conf.saved_caches_directory)) continue;
                    throw new ConfigurationException("saved_caches_directory must not be the same as any data_file_directories");
                }
                if (DatabaseDescriptor.conf.commitlog_directory.equals(DatabaseDescriptor.conf.saved_caches_directory)) {
                    throw new ConfigurationException("saved_caches_directory must not be the same as the commitlog_directory");
                }
            } else {
                if (DatabaseDescriptor.conf.commitlog_directory == null) {
                    throw new ConfigurationException("commitlog_directory missing");
                }
                if (DatabaseDescriptor.conf.data_file_directories == null) {
                    throw new ConfigurationException("data_file_directories missing; at least one data directory must be specified");
                }
                if (DatabaseDescriptor.conf.saved_caches_directory == null) {
                    throw new ConfigurationException("saved_caches_directory missing");
                }
            }
            if (DatabaseDescriptor.conf.initial_token != null) {
                partitioner.getTokenFactory().validate(DatabaseDescriptor.conf.initial_token);
            }
            try {
                long l = keyCacheSizeInMB = DatabaseDescriptor.conf.key_cache_size_in_mb == null ? (long)Math.min((int)((double)Runtime.getRuntime().totalMemory() * 0.05 / 1024.0 / 1024.0), 100) : DatabaseDescriptor.conf.key_cache_size_in_mb;
                if (keyCacheSizeInMB < 0L) {
                    throw new NumberFormatException();
                }
            }
            catch (NumberFormatException e) {
                throw new ConfigurationException("key_cache_size_in_mb option was set incorrectly to '" + DatabaseDescriptor.conf.key_cache_size_in_mb + "', supported values are <integer> >= 0.");
            }
            rowCacheProvider = FBUtilities.newCacheProvider(DatabaseDescriptor.conf.row_cache_provider);
            KSMetaData systemMeta = KSMetaData.systemKeyspace();
            Schema.instance.load(CFMetaData.StatusCf);
            Schema.instance.load(CFMetaData.HintsCf);
            Schema.instance.load(CFMetaData.MigrationsCf);
            Schema.instance.load(CFMetaData.SchemaCf);
            Schema.instance.load(CFMetaData.IndexCf);
            Schema.instance.load(CFMetaData.NodeIdCf);
            Schema.instance.load(CFMetaData.VersionCf);
            Schema.instance.load(CFMetaData.SchemaKeyspacesCf);
            Schema.instance.load(CFMetaData.SchemaColumnFamiliesCf);
            Schema.instance.load(CFMetaData.SchemaColumnsCf);
            Schema.instance.addSystemTable(systemMeta);
            if (DatabaseDescriptor.conf.seed_provider == null) {
                throw new ConfigurationException("seeds configuration is missing; a minimum of one seed is required.");
            }
            try {
                Class<?> seedProviderClass = Class.forName(DatabaseDescriptor.conf.seed_provider.class_name);
                seedProvider = (SeedProvider)seedProviderClass.getConstructor(Map.class).newInstance(DatabaseDescriptor.conf.seed_provider.parameters);
            }
            catch (Exception e) {
                logger.error("Fatal configuration error", (Throwable)e);
                System.err.println(e.getMessage() + "\nFatal configuration error; unable to start server.  See log for stacktrace.");
                System.exit(1);
            }
            if (seedProvider.getSeeds().size() == 0) {
                throw new ConfigurationException("The seed provider lists no seeds.");
            }
        }
        catch (ConfigurationException e) {
            logger.error("Fatal configuration error", (Throwable)e);
            System.err.println(e.getMessage() + "\nFatal configuration error; unable to start server.  See log for stacktrace.");
            System.exit(1);
        }
        catch (YAMLException e) {
            logger.error("Fatal configuration error error", (Throwable)e);
            System.err.println(e.getMessage() + "\nInvalid yaml; unable to start server.  See log for stacktrace.");
            System.exit(1);
        }
    }

    private static IEndpointSnitch createEndpointSnitch(String snitchClassName) throws ConfigurationException {
        if (!snitchClassName.contains(".")) {
            snitchClassName = "org.apache.cassandra.locator." + snitchClassName;
        }
        IEndpointSnitch snitch = (IEndpointSnitch)FBUtilities.construct(snitchClassName, "snitch");
        return DatabaseDescriptor.conf.dynamic_snitch != false ? new DynamicEndpointSnitch(snitch) : snitch;
    }

    public static void loadSchemas() throws IOException {
        ColumnFamilyStore schemaCFS = SystemTable.schemaCFS("schema_keyspaces");
        if (schemaCFS.estimateKeys() == 0L) {
            UUID uuid = MigrationManager.getLastMigrationId();
            if (uuid == null) {
                logger.info("Couldn't detect any schema definitions in local storage.");
                if (DatabaseDescriptor.hasExistingNoSystemTables()) {
                    logger.info("Found table data in data directories. Consider using the CLI to define your schema.");
                } else {
                    logger.info("To create keyspaces and column families, see 'help create keyspace' in the CLI, or set up a schema using the thrift system_* calls.");
                }
            } else {
                logger.info("Loading schema version " + uuid.toString());
                Collection<KSMetaData> tableDefs = DefsTable.loadFromStorage(uuid);
                if (tableDefs.size() == 0) {
                    logger.warn("No schema definitions were found in local storage.");
                } else {
                    Schema.instance.load(tableDefs);
                }
            }
        } else {
            Schema.instance.load(DefsTable.loadFromTable());
        }
        Schema.instance.updateVersion();
        Schema.instance.fixCFMaxId();
    }

    private static boolean hasExistingNoSystemTables() {
        for (String dataDir : DatabaseDescriptor.getAllDataFileLocations()) {
            int dirCount;
            File dataPath = new File(dataDir);
            if (!dataPath.exists() || !dataPath.isDirectory() || (dirCount = dataPath.listFiles(new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    return pathname.isDirectory();
                }
            }).length) <= 0) continue;
            return true;
        }
        return false;
    }

    public static IAuthenticator getAuthenticator() {
        return authenticator;
    }

    public static IAuthority getAuthority() {
        return authority;
    }

    public static int getThriftMaxMessageLength() {
        return DatabaseDescriptor.conf.thrift_max_message_length_in_mb * 1024 * 1024;
    }

    public static int getThriftFramedTransportSize() {
        return DatabaseDescriptor.conf.thrift_framed_transport_size_in_mb * 1024 * 1024;
    }

    public static void createAllDirectories() throws IOException {
        try {
            if (DatabaseDescriptor.conf.data_file_directories.length == 0) {
                throw new ConfigurationException("At least one DataFileDirectory must be specified");
            }
            for (String dataFileDirectory : DatabaseDescriptor.conf.data_file_directories) {
                FileUtils.createDirectory(dataFileDirectory);
            }
            if (DatabaseDescriptor.conf.commitlog_directory == null) {
                throw new ConfigurationException("commitlog_directory must be specified");
            }
            FileUtils.createDirectory(DatabaseDescriptor.conf.commitlog_directory);
            if (DatabaseDescriptor.conf.saved_caches_directory == null) {
                throw new ConfigurationException("saved_caches_directory must be specified");
            }
            FileUtils.createDirectory(DatabaseDescriptor.conf.saved_caches_directory);
        }
        catch (ConfigurationException ex) {
            logger.error("Fatal error: " + ex.getMessage());
            System.err.println("Bad configuration; unable to start server");
            System.exit(1);
        }
    }

    public static IPartitioner getPartitioner() {
        return partitioner;
    }

    public static void setPartitioner(IPartitioner newPartitioner) {
        partitioner = newPartitioner;
    }

    public static IEndpointSnitch getEndpointSnitch() {
        return snitch;
    }

    public static void setEndpointSnitch(IEndpointSnitch eps) {
        snitch = eps;
    }

    public static IRequestScheduler getRequestScheduler() {
        return requestScheduler;
    }

    public static RequestSchedulerOptions getRequestSchedulerOptions() {
        return requestSchedulerOptions;
    }

    public static Config.RequestSchedulerId getRequestSchedulerId() {
        return requestSchedulerId;
    }

    public static String getJobTrackerAddress() {
        return DatabaseDescriptor.conf.job_tracker_host;
    }

    public static int getColumnIndexSize() {
        return DatabaseDescriptor.conf.column_index_size_in_kb * 1024;
    }

    public static String getInitialToken() {
        return System.getProperty("cassandra.initial_token", DatabaseDescriptor.conf.initial_token);
    }

    public static String getReplaceToken() {
        return System.getProperty("cassandra.replace_token", null);
    }

    public static String getClusterName() {
        return DatabaseDescriptor.conf.cluster_name;
    }

    public static int getMaxStreamingRetries() {
        return DatabaseDescriptor.conf.max_streaming_retries;
    }

    public static String getJobJarLocation() {
        return DatabaseDescriptor.conf.job_jar_file_location;
    }

    public static int getStoragePort() {
        return Integer.parseInt(System.getProperty("cassandra.storage_port", DatabaseDescriptor.conf.storage_port.toString()));
    }

    public static int getSSLStoragePort() {
        return Integer.parseInt(System.getProperty("cassandra.ssl_storage_port", DatabaseDescriptor.conf.ssl_storage_port.toString()));
    }

    public static int getRpcPort() {
        return Integer.parseInt(System.getProperty("cassandra.rpc_port", DatabaseDescriptor.conf.rpc_port.toString()));
    }

    public static long getRpcTimeout() {
        return DatabaseDescriptor.conf.rpc_timeout_in_ms;
    }

    public static void setRpcTimeout(Long timeOutInMillis) {
        DatabaseDescriptor.conf.rpc_timeout_in_ms = timeOutInMillis;
    }

    public static int getPhiConvictThreshold() {
        return DatabaseDescriptor.conf.phi_convict_threshold;
    }

    public static int getConcurrentReaders() {
        return DatabaseDescriptor.conf.concurrent_reads;
    }

    public static int getConcurrentWriters() {
        return DatabaseDescriptor.conf.concurrent_writes;
    }

    public static int getConcurrentReplicators() {
        return DatabaseDescriptor.conf.concurrent_replicates;
    }

    public static int getFlushWriters() {
        return DatabaseDescriptor.conf.memtable_flush_writers;
    }

    public static int getInMemoryCompactionLimit() {
        return DatabaseDescriptor.conf.in_memory_compaction_limit_in_mb * 1024 * 1024;
    }

    public static void setInMemoryCompactionLimit(int sizeInMB) {
        DatabaseDescriptor.conf.in_memory_compaction_limit_in_mb = sizeInMB;
    }

    public static int getConcurrentCompactors() {
        return DatabaseDescriptor.conf.concurrent_compactors;
    }

    public static boolean isMultithreadedCompaction() {
        return DatabaseDescriptor.conf.multithreaded_compaction;
    }

    public static int getCompactionThroughputMbPerSec() {
        return DatabaseDescriptor.conf.compaction_throughput_mb_per_sec;
    }

    public static void setCompactionThroughputMbPerSec(int value) {
        DatabaseDescriptor.conf.compaction_throughput_mb_per_sec = value;
    }

    public static int getStreamThroughputOutboundMegabitsPerSec() {
        return DatabaseDescriptor.conf.stream_throughput_outbound_megabits_per_sec;
    }

    public static void setStreamThroughputOutboundMegabitsPerSec(int value) {
        DatabaseDescriptor.conf.stream_throughput_outbound_megabits_per_sec = value;
    }

    public static String[] getAllDataFileLocations() {
        return DatabaseDescriptor.conf.data_file_directories;
    }

    public static String getCommitLogLocation() {
        return DatabaseDescriptor.conf.commitlog_directory;
    }

    public static int getCommitLogSegmentSize() {
        return DatabaseDescriptor.conf.commitlog_segment_size_in_mb * 1024 * 1024;
    }

    public static String getSavedCachesLocation() {
        return DatabaseDescriptor.conf.saved_caches_directory;
    }

    public static Set<InetAddress> getSeeds() {
        return Collections.unmodifiableSet(new HashSet<InetAddress>(seedProvider.getSeeds()));
    }

    public static InetAddress getListenAddress() {
        return listenAddress;
    }

    public static InetAddress getBroadcastAddress() {
        return broadcastAddress;
    }

    public static void setBroadcastAddress(InetAddress broadcastAdd) {
        broadcastAddress = broadcastAdd;
    }

    public static InetAddress getRpcAddress() {
        return rpcAddress;
    }

    public static String getRpcServerType() {
        return DatabaseDescriptor.conf.rpc_server_type;
    }

    public static boolean getRpcKeepAlive() {
        return DatabaseDescriptor.conf.rpc_keepalive;
    }

    public static Integer getRpcMinThreads() {
        return DatabaseDescriptor.conf.rpc_min_threads;
    }

    public static Integer getRpcMaxThreads() {
        return DatabaseDescriptor.conf.rpc_max_threads;
    }

    public static Integer getRpcSendBufferSize() {
        return DatabaseDescriptor.conf.rpc_send_buff_size_in_bytes;
    }

    public static Integer getRpcRecvBufferSize() {
        return DatabaseDescriptor.conf.rpc_recv_buff_size_in_bytes;
    }

    public static double getCommitLogSyncBatchWindow() {
        return DatabaseDescriptor.conf.commitlog_sync_batch_window_in_ms;
    }

    public static int getCommitLogSyncPeriod() {
        return DatabaseDescriptor.conf.commitlog_sync_period_in_ms;
    }

    public static Config.CommitLogSync getCommitLogSync() {
        return DatabaseDescriptor.conf.commitlog_sync;
    }

    public static Config.DiskAccessMode getDiskAccessMode() {
        return DatabaseDescriptor.conf.disk_access_mode;
    }

    public static Config.DiskAccessMode getIndexAccessMode() {
        return indexAccessMode;
    }

    public static boolean isSnapshotBeforeCompaction() {
        return DatabaseDescriptor.conf.snapshot_before_compaction;
    }

    public static boolean isAutoSnapshot() {
        return DatabaseDescriptor.conf.auto_snapshot;
    }

    public static boolean isAutoBootstrap() {
        return DatabaseDescriptor.conf.auto_bootstrap;
    }

    public static boolean hintedHandoffEnabled() {
        return DatabaseDescriptor.conf.hinted_handoff_enabled;
    }

    public static int getMaxHintWindow() {
        return DatabaseDescriptor.conf.max_hint_window_in_ms;
    }

    public static Integer getIndexInterval() {
        return DatabaseDescriptor.conf.index_interval;
    }

    public static File getSerializedCachePath(String ksName, String cfName, CacheService.CacheType cacheType) {
        return new File(DatabaseDescriptor.conf.saved_caches_directory + File.separator + ksName + "-" + cfName + "-" + (Object)((Object)cacheType));
    }

    public static int getDynamicUpdateInterval() {
        return DatabaseDescriptor.conf.dynamic_snitch_update_interval_in_ms;
    }

    public static void setDynamicUpdateInterval(Integer dynamicUpdateInterval) {
        DatabaseDescriptor.conf.dynamic_snitch_update_interval_in_ms = dynamicUpdateInterval;
    }

    public static int getDynamicResetInterval() {
        return DatabaseDescriptor.conf.dynamic_snitch_reset_interval_in_ms;
    }

    public static void setDynamicResetInterval(Integer dynamicResetInterval) {
        DatabaseDescriptor.conf.dynamic_snitch_reset_interval_in_ms = dynamicResetInterval;
    }

    public static double getDynamicBadnessThreshold() {
        return DatabaseDescriptor.conf.dynamic_snitch_badness_threshold;
    }

    public static void setDynamicBadnessThreshold(Double dynamicBadnessThreshold) {
        DatabaseDescriptor.conf.dynamic_snitch_badness_threshold = dynamicBadnessThreshold;
    }

    public static EncryptionOptions getEncryptionOptions() {
        return DatabaseDescriptor.conf.encryption_options;
    }

    public static double getFlushLargestMemtablesAt() {
        return DatabaseDescriptor.conf.flush_largest_memtables_at;
    }

    public static double getReduceCacheSizesAt() {
        return DatabaseDescriptor.conf.reduce_cache_sizes_at;
    }

    public static double getReduceCacheCapacityTo() {
        return DatabaseDescriptor.conf.reduce_cache_capacity_to;
    }

    public static int getHintedHandoffThrottleDelay() {
        return DatabaseDescriptor.conf.hinted_handoff_throttle_delay_in_ms;
    }

    public static boolean getPreheatKeyCache() {
        return DatabaseDescriptor.conf.compaction_preheat_key_cache;
    }

    public static void validateMemtableThroughput(int sizeInMB) throws ConfigurationException {
        if (sizeInMB <= 0) {
            throw new ConfigurationException("memtable_throughput_in_mb must be greater than 0.");
        }
    }

    public static void validateMemtableOperations(double operationsInMillions) throws ConfigurationException {
        if (operationsInMillions <= 0.0) {
            throw new ConfigurationException("memtable_operations_in_millions must be greater than 0.0.");
        }
        if (operationsInMillions > 9.223372036854775E18) {
            throw new ConfigurationException("memtable_operations_in_millions must be less than 9223372036854774784");
        }
    }

    public static boolean isIncrementalBackupsEnabled() {
        return DatabaseDescriptor.conf.incremental_backups;
    }

    public static void setIncrementalBackupsEnabled(boolean value) {
        DatabaseDescriptor.conf.incremental_backups = value;
    }

    public static int getFlushQueueSize() {
        return DatabaseDescriptor.conf.memtable_flush_queue_size;
    }

    public static int getTotalMemtableSpaceInMB() {
        assert (DatabaseDescriptor.conf.memtable_total_space_in_mb > 0);
        return DatabaseDescriptor.conf.memtable_total_space_in_mb;
    }

    public static long getTotalCommitlogSpaceInMB() {
        return DatabaseDescriptor.conf.commitlog_total_space_in_mb.intValue();
    }

    public static boolean getTrickleFsync() {
        return DatabaseDescriptor.conf.trickle_fsync;
    }

    public static int getTrickleFsyncIntervalInKb() {
        return DatabaseDescriptor.conf.trickle_fsync_interval_in_kb;
    }

    public static long getKeyCacheSizeInMB() {
        return keyCacheSizeInMB;
    }

    public static int getKeyCacheSavePeriod() {
        return DatabaseDescriptor.conf.key_cache_save_period;
    }

    public static int getKeyCacheKeysToSave() {
        return DatabaseDescriptor.conf.key_cache_keys_to_save;
    }

    public static long getRowCacheSizeInMB() {
        return DatabaseDescriptor.conf.row_cache_size_in_mb;
    }

    public static int getRowCacheSavePeriod() {
        return DatabaseDescriptor.conf.row_cache_save_period;
    }

    public static int getRowCacheKeysToSave() {
        return DatabaseDescriptor.conf.row_cache_keys_to_save;
    }

    public static IRowCacheProvider getRowCacheProvider() {
        return rowCacheProvider;
    }

    public static int getStreamingSocketTimeout() {
        return DatabaseDescriptor.conf.streaming_socket_timeout_in_ms;
    }

    public static boolean populateIOCacheOnFlush() {
        return DatabaseDescriptor.conf.populate_io_cache_on_flush;
    }

    static {
        authenticator = new AllowAllAuthenticator();
        authority = new AllowAllAuthority();
        if (Config.getLoadYaml()) {
            DatabaseDescriptor.loadYaml();
        } else {
            conf = new Config();
        }
    }
}

