/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.concurrent;

import java.lang.management.ManagementFactory;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.cassandra.concurrent.DebuggableThreadPoolExecutor;
import org.apache.cassandra.concurrent.JMXEnabledThreadPoolExecutorMBean;
import org.apache.cassandra.concurrent.NamedThreadFactory;
import org.apache.cassandra.concurrent.Stage;

public class JMXEnabledThreadPoolExecutor
extends DebuggableThreadPoolExecutor
implements JMXEnabledThreadPoolExecutorMBean {
    private final String mbeanName;
    private final AtomicInteger totalBlocked = new AtomicInteger(0);
    private final AtomicInteger currentBlocked = new AtomicInteger(0);

    public JMXEnabledThreadPoolExecutor(String threadPoolName) {
        this(1, Integer.MAX_VALUE, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new NamedThreadFactory(threadPoolName), "internal");
    }

    public JMXEnabledThreadPoolExecutor(String threadPoolName, String jmxPath) {
        this(1, Integer.MAX_VALUE, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new NamedThreadFactory(threadPoolName), jmxPath);
    }

    public JMXEnabledThreadPoolExecutor(String threadPoolName, int priority) {
        this(1, Integer.MAX_VALUE, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new NamedThreadFactory(threadPoolName, priority), "internal");
    }

    public JMXEnabledThreadPoolExecutor(int corePoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, NamedThreadFactory threadFactory, String jmxPath) {
        this(corePoolSize, corePoolSize, keepAliveTime, unit, workQueue, threadFactory, jmxPath);
    }

    public JMXEnabledThreadPoolExecutor(int corePoolSize, int maxPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, NamedThreadFactory threadFactory, String jmxPath) {
        super(corePoolSize, maxPoolSize, keepAliveTime, unit, workQueue, threadFactory);
        super.prestartAllCoreThreads();
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        this.mbeanName = "org.apache.cassandra." + jmxPath + ":type=" + threadFactory.id;
        try {
            mbs.registerMBean(this, new ObjectName(this.mbeanName));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public JMXEnabledThreadPoolExecutor(Stage stage) {
        this(stage.getJmxName(), stage.getJmxType());
    }

    private void unregisterMBean() {
        try {
            ManagementFactory.getPlatformMBeanServer().unregisterMBean(new ObjectName(this.mbeanName));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public synchronized void shutdown() {
        if (!this.isShutdown()) {
            this.unregisterMBean();
        }
        super.shutdown();
    }

    @Override
    public synchronized List<Runnable> shutdownNow() {
        if (!this.isShutdown()) {
            this.unregisterMBean();
        }
        return super.shutdownNow();
    }

    @Override
    public long getCompletedTasks() {
        return this.getCompletedTaskCount();
    }

    @Override
    public long getPendingTasks() {
        return this.getTaskCount() - this.getCompletedTaskCount();
    }

    @Override
    public int getTotalBlockedTasks() {
        return this.totalBlocked.get();
    }

    @Override
    public int getCurrentlyBlockedTasks() {
        return this.currentBlocked.get();
    }

    @Override
    protected void onInitialRejection(Runnable task) {
        this.totalBlocked.incrementAndGet();
        this.currentBlocked.incrementAndGet();
    }

    @Override
    protected void onFinalAccept(Runnable task) {
        this.currentBlocked.decrementAndGet();
    }

    @Override
    protected void onFinalRejection(Runnable task) {
        this.currentBlocked.decrementAndGet();
    }
}

