/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.web.util;

import org.apache.camel.builder.ExpressionClause;
import org.apache.camel.model.language.ExpressionDefinition;
import org.apache.camel.model.language.MethodCallExpression;
import org.apache.camel.model.language.XPathExpression;

public final class ExpressionRenderer {
    private ExpressionRenderer() {
    }

    public static void render(StringBuilder buffer, ExpressionDefinition expression) {
        if (buffer.toString().endsWith(")")) {
            buffer.append(".");
        }
        if (expression instanceof ExpressionClause) {
            ExpressionRenderer.renderExpressionClause(buffer, (ExpressionClause)expression);
        } else if (expression.getExpressionValue() instanceof ExpressionClause) {
            ExpressionRenderer.render(buffer, (ExpressionDefinition)((ExpressionClause)expression.getExpressionValue()));
        } else if (expression.getExpressionValue() != null) {
            ExpressionRenderer.renderExpression(buffer, expression.getExpressionValue().toString());
        } else if (expression.getLanguage() != null) {
            ExpressionRenderer.renderLanguageExpression(buffer, expression);
        }
    }

    public static void renderConstant(StringBuilder buffer, ExpressionDefinition expression) {
        buffer.append(".constant(\"").append(expression.getExpressionValue().toString()).append("\")");
    }

    private static void renderExpressionClause(StringBuilder buffer, ExpressionClause expression) {
        if (expression.getLanguage() != null) {
            ExpressionRenderer.renderLanguageExpression(buffer, (ExpressionDefinition)expression);
        } else if (expression.getExpressionType() instanceof MethodCallExpression) {
            String exp = expression.getExpressionType().toString();
            String bean = exp.substring(exp.indexOf(123) + 1, exp.indexOf(44));
            String method = exp.substring(exp.indexOf(61) + 1, exp.indexOf(125));
            buffer.append("method(\"").append(bean).append("\", \"").append(method).append("\")");
        } else if (expression.getExpressionType() instanceof XPathExpression) {
            XPathExpression xpath = (XPathExpression)expression.getExpressionType();
            buffer.append("xpath(\"").append(xpath.getExpression()).append("\", ").append(xpath.getResultType().getSimpleName()).append(".class)");
        } else {
            ExpressionRenderer.renderExpression(buffer, expression.getExpressionValue().toString());
        }
    }

    public static void renderLanguageExpression(StringBuilder buffer, ExpressionDefinition expression) {
        buffer.append(expression.getLanguage()).append("(\"");
        if (expression.getExpression() != null) {
            buffer.append(expression.getExpression()).append("\")");
        } else if (expression.getExpressionValue() instanceof ExpressionClause) {
            buffer.append(((ExpressionClause)expression.getExpressionValue()).getExpression()).append("\")");
        }
    }

    public static void renderExpression(StringBuilder buffer, String expression) {
        if (!expression.contains(",")) {
            if (expression.contains("(")) {
                expression = expression.replaceAll("\\(", "(\"").replaceAll("\\)", "\")");
                buffer.append(expression);
            } else {
                buffer.append(expression).append("()");
            }
        } else if (expression.startsWith("tokenize")) {
            String[] words = expression.split("\\(");
            if (words.length == 2) {
                String tokenize = words[1].substring(words[1].indexOf(" ") + 1, words[1].lastIndexOf(")"));
                words[1] = words[1].substring(0, words[1].indexOf(","));
                if (!words[1].contains("[")) {
                    buffer.append(words[1]).append("()");
                } else {
                    String word = words[1].substring(0, words[1].indexOf("As"));
                    String clazz = words[1].substring(words[1].lastIndexOf(".") + 1, words[1].length() - 1);
                    buffer.append(word).append("(").append(clazz).append(".class)");
                }
                buffer.append(".").append(words[0]).append("(\"").append(tokenize).append("\")");
            } else if (words.length == 3) {
                String symbolName = words[2].substring(0, words[2].indexOf(")"));
                String tokenize = words[2].substring(words[2].indexOf(" ") + 1, words[2].lastIndexOf(")"));
                buffer.append(words[1]).append("(\"").append(symbolName).append("\").");
                buffer.append(words[0]).append("(\"").append(tokenize).append("\")");
            }
        } else if (expression.startsWith("append")) {
            String[] words = expression.split("\\(|, |\\)");
            buffer.append(words[1]).append("().").append("append(\"").append(words[2]).append("\")");
        } else if (expression.startsWith("prepend")) {
            String[] words = expression.split("\\(|, |\\)");
            buffer.append(words[1]).append("().").append("prepend(\"").append(words[2]).append("\")");
        }
    }
}

