/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.web.resources;

import com.sun.jersey.api.representation.Form;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.spi.BrowsableEndpoint;
import org.apache.camel.util.ExchangeHelper;
import org.apache.camel.web.model.EndpointLink;
import org.apache.camel.web.resources.CamelChildResourceSupport;
import org.apache.camel.web.resources.CamelContextResource;
import org.apache.camel.web.resources.ExchangeResource;

public class EndpointResource
extends CamelChildResourceSupport {
    private final String key;
    private final Endpoint endpoint;

    public EndpointResource(CamelContextResource contextResource, String key, Endpoint endpoint) {
        super(contextResource);
        this.key = key;
        this.endpoint = endpoint;
    }

    public String getHref() {
        return new EndpointLink(this.key, this.endpoint).getHref();
    }

    public String getKey() {
        return this.key;
    }

    public String getUri() {
        return this.endpoint.getEndpointUri();
    }

    public Endpoint getEndpoint() {
        return this.endpoint;
    }

    public BrowsableEndpoint getBrowsableEndpoint() {
        if (this.endpoint instanceof BrowsableEndpoint) {
            return (BrowsableEndpoint)this.endpoint;
        }
        return null;
    }

    @Path(value="messages/{id}")
    public ExchangeResource getExchange(@PathParam(value="id") String exchangeId) {
        BrowsableEndpoint browsableEndpoint;
        Exchange exchange;
        if (this.endpoint instanceof BrowsableEndpoint && (exchange = ExchangeHelper.getExchangeById((Iterable)(browsableEndpoint = (BrowsableEndpoint)this.endpoint).getExchanges(), (String)exchangeId)) != null) {
            return new ExchangeResource(this, exchange);
        }
        return null;
    }

    @POST
    @Consumes(value={"text/plain", "text/html", "text/xml", "application/xml"})
    public Response postMessage(@Context HttpHeaders headers, String body) throws URISyntaxException {
        this.sendMessage(headers, body);
        return Response.ok().build();
    }

    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Response postMessageForm(@Context HttpHeaders headers, Form formData) throws URISyntaxException {
        String body = (String)formData.getFirst("body", String.class);
        this.sendMessage(headers, body);
        return Response.seeOther((URI)new URI(this.getHref())).build();
    }

    protected void sendMessage(final HttpHeaders headers, final String body) {
        this.getTemplate().send(this.endpoint, new Processor(){

            public void process(Exchange exchange) throws Exception {
                Message in = exchange.getIn();
                in.setBody((Object)body);
                if (headers != null) {
                    MultivaluedMap requestHeaders = headers.getRequestHeaders();
                    Set entries = requestHeaders.entrySet();
                    for (Map.Entry entry : entries) {
                        String key = (String)entry.getKey();
                        List values = (List)entry.getValue();
                        int size = values.size();
                        if (size == 1) {
                            in.setHeader(key, values.get(0));
                            continue;
                        }
                        if (size <= 0) continue;
                        in.setHeader(key, (Object)values);
                    }
                }
            }
        });
    }
}

