/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.mojo;

import java.io.File;
import java.io.IOException;
import org.apache.avro.Schema;
import org.apache.avro.compiler.specific.SpecificCompiler;
import org.apache.avro.generic.GenericData;
import org.apache.avro.mojo.AbstractAvroMojo;

public class SchemaMojo
extends AbstractAvroMojo {
    private Schema.Parser schemaParser = new Schema.Parser();
    private String[] includes = new String[]{"**/*.avsc"};
    private String[] testIncludes = new String[]{"**/*.avsc"};

    @Override
    protected void doCompile(String filename, File sourceDirectory, File outputDirectory) throws IOException {
        File src = new File(sourceDirectory, filename);
        Schema schema = this.imports == null ? new Schema.Parser().parse(src) : this.schemaParser.parse(src);
        SpecificCompiler compiler = new SpecificCompiler(schema);
        compiler.setTemplateDir(this.templateDirectory);
        compiler.setStringType(GenericData.StringType.valueOf((String)this.stringType));
        compiler.setFieldVisibility(this.getFieldVisibility());
        compiler.setCreateSetters(this.createSetters);
        compiler.setEnableDecimalLogicalType(this.enableDecimalLogicalType);
        compiler.setOutputCharacterEncoding(this.project.getProperties().getProperty("project.build.sourceEncoding"));
        compiler.compileToDestination(src, outputDirectory);
    }

    @Override
    protected String[] getIncludes() {
        return this.includes;
    }

    @Override
    protected String[] getTestIncludes() {
        return this.testIncludes;
    }
}

