/*
 * Decompiled with CFR 0.152.
 */
package org.andromda.metafacades.uml14;

import java.util.Collection;
import java.util.Iterator;
import org.andromda.metafacades.uml.ClassifierFacade;
import org.andromda.metafacades.uml.NameMasker;
import org.andromda.metafacades.uml.OperationFacade;
import org.andromda.metafacades.uml.UMLMetafacadeUtils;
import org.andromda.metafacades.uml.UMLProfile;
import org.andromda.metafacades.uml14.ParameterFacadeLogic;
import org.andromda.metafacades.uml14.UML14MetafacadeUtils;
import org.andromda.utils.StringUtilsHelper;
import org.apache.commons.lang.StringUtils;
import org.omg.uml.behavioralelements.statemachines.Event;
import org.omg.uml.foundation.core.Classifier;
import org.omg.uml.foundation.core.Operation;
import org.omg.uml.foundation.core.Parameter;
import org.omg.uml.foundation.datatypes.Expression;
import org.omg.uml.foundation.datatypes.ParameterDirectionKindEnum;

public class ParameterFacadeLogicImpl
extends ParameterFacadeLogic {
    private static final long serialVersionUID = 34L;

    public ParameterFacadeLogicImpl(Parameter metaObject, String context) {
        super(metaObject, context);
    }

    @Override
    protected String handleGetName() {
        String nameMask = String.valueOf(this.getConfiguredProperty("parameterNameMask"));
        String name = NameMasker.mask((String)super.handleGetName(), (String)nameMask);
        return name;
    }

    @Override
    protected String handleGetGetterName() {
        return UMLMetafacadeUtils.getGetterPrefix((ClassifierFacade)this.getType(), (int)this.getLower()) + StringUtilsHelper.capitalize((String)this.getName());
    }

    @Override
    protected String handleGetSetterName() {
        return "set" + StringUtilsHelper.capitalize((String)this.getName());
    }

    public Object getValidationOwner() {
        OperationFacade owner = this.getOperation();
        if (owner == null) {
            owner = this.getEvent();
        }
        return owner;
    }

    @Override
    public String handleGetDefaultValue() {
        String defaultValue = null;
        Expression expression = this.metaObject.getDefaultValue();
        if (expression != null) {
            defaultValue = expression.getBody();
        }
        if (StringUtils.isNotBlank(defaultValue)) {
            String typeName = this.metaObject.getType().getName();
            if ("String".equals(typeName) && defaultValue.indexOf(34) < 0) {
                defaultValue = '\"' + defaultValue + '\"';
            } else if (("char".equals(typeName) || "Character".equals(typeName)) && defaultValue.indexOf(39) < 0) {
                defaultValue = "'" + defaultValue.charAt(0) + '\'';
            }
        }
        if (defaultValue == null) {
            defaultValue = "";
        }
        return defaultValue;
    }

    @Override
    public boolean handleIsDefaultValuePresent() {
        return StringUtils.isNotBlank((String)this.getDefaultValue());
    }

    @Override
    protected String handleGetGetterSetterTypeName() {
        if (this.getType() == null) {
            return "";
        }
        return this.getType().getFullyQualifiedName();
    }

    @Override
    protected String handleGetGetterSetterTypeNameImpl() {
        return this.getGetterSetterTypeName();
    }

    protected Classifier handleGetType() {
        return this.metaObject.getType();
    }

    @Override
    public String handleGetEffect() {
        return "NONE";
    }

    @Override
    public boolean handleIsException() {
        return false;
    }

    @Override
    protected boolean handleIsOrdered() {
        return false;
    }

    @Override
    public boolean handleIsReturn() {
        return ParameterDirectionKindEnum.PDK_RETURN.equals((Object)this.metaObject.getKind());
    }

    @Override
    protected boolean handleIsRequired() {
        return !this.hasStereotype(UMLProfile.STEREOTYPE_NULLABLE);
    }

    @Override
    protected boolean handleIsUnique() {
        return !this.hasStereotype(UMLProfile.STEREOTYPE_UNIQUE);
    }

    protected Operation handleGetOperation() {
        Operation parameterOperation = null;
        Collection allOperations = UML14MetafacadeUtils.getModel().getCore().getOperation().refAllOfType();
        Iterator iterator = allOperations.iterator();
        while (iterator.hasNext() && parameterOperation == null) {
            Operation operation = (Operation)iterator.next();
            if (!operation.getParameter().contains(this.metaObject)) continue;
            parameterOperation = operation;
        }
        return parameterOperation;
    }

    protected Event handleGetEvent() {
        Event parameterEvent = null;
        Collection allEvents = UML14MetafacadeUtils.getModel().getStateMachines().getEvent().refAllOfType();
        Iterator iterator = allEvents.iterator();
        while (iterator.hasNext() && parameterEvent == null) {
            Event event = (Event)iterator.next();
            if (!event.getParameter().contains(this.metaObject)) continue;
            parameterEvent = event;
        }
        return parameterEvent;
    }

    @Override
    protected boolean handleIsReadable() {
        return this.isInParameter() || this.isInoutParameter();
    }

    @Override
    protected boolean handleIsWritable() {
        return this.isOutParameter() || this.isInoutParameter();
    }

    @Override
    protected boolean handleIsInParameter() {
        return ParameterDirectionKindEnum.PDK_IN.equals((Object)this.metaObject.getKind());
    }

    @Override
    protected boolean handleIsOutParameter() {
        return ParameterDirectionKindEnum.PDK_OUT.equals((Object)this.metaObject.getKind());
    }

    @Override
    protected boolean handleIsInoutParameter() {
        return ParameterDirectionKindEnum.PDK_INOUT.equals((Object)this.metaObject.getKind());
    }

    @Override
    protected boolean handleIsMany() {
        return false;
    }

    @Override
    protected int handleGetUpper() {
        if (this.isMany()) {
            return -1;
        }
        return 1;
    }

    @Override
    protected int handleGetLower() {
        if (!this.hasStereotype("Nullable") && this.getType().isPrimitive()) {
            return 1;
        }
        return 0;
    }

    private boolean isPluralizeParameterNames() {
        Object value = this.getConfiguredProperty("pluralizeParameterNames");
        return value != null && Boolean.valueOf(String.valueOf(value)) != false;
    }
}

