/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.test.cluster;

import java.io.IOException;
import java.io.StringWriter;
import org.alfresco.jlan.client.CIFSDiskSession;
import org.alfresco.jlan.client.CIFSFile;
import org.alfresco.jlan.client.DiskSession;
import org.alfresco.jlan.debug.Debug;
import org.alfresco.jlan.smb.SMBException;
import org.alfresco.jlan.test.cluster.BooleanTestResult;
import org.alfresco.jlan.test.cluster.ExceptionTestResult;
import org.alfresco.jlan.test.cluster.Test;
import org.alfresco.jlan.test.cluster.TestResult;

public class SharingModeTest
extends Test {
    private static final String TestFileName = "nosharingFile";
    private static final String TestFileExt = ".txt";

    public SharingModeTest() {
        super("SharingMode");
    }

    @Override
    public TestResult runTest(int threadId, int iteration, DiskSession sess, StringWriter log) {
        TestResult result = null;
        try {
            String testFileName = this.getPerTestFileName(threadId, iteration);
            this.testLog(log, "Creating file ...");
            CIFSDiskSession cifsSess = (CIFSDiskSession)sess;
            CIFSFile noshareFile = cifsSess.NTCreate("\\" + testFileName, 3, 128, 0, 2, 0L, 0);
            this.testLog(log, "Created file with sharing mode NONE, file=" + noshareFile);
            try {
                Thread.sleep(3000L);
            }
            catch (Exception ex) {
                // empty catch block
            }
            noshareFile.Close();
            this.testLog(log, "Closed file");
            result = new BooleanTestResult(true);
            if (this.hasTestCleanup() && threadId == 1) {
                sess.DeleteFile(testFileName);
            }
            this.testLog(log, "Test completed");
        }
        catch (SMBException ex) {
            this.testLog(log, "Failed to create file - " + ex.getMessage());
            result = new ExceptionTestResult(ex);
        }
        catch (IOException ex) {
            this.testLog(log, "Failed to create file - " + ex.getMessage());
            result = new ExceptionTestResult(ex);
        }
        catch (Exception ex) {
            Debug.println(ex);
            result = new ExceptionTestResult(ex);
        }
        return result;
    }

    @Override
    public void cleanupTest(int threadId, int iter, DiskSession sess, StringWriter log) throws Exception {
        if (threadId == 1) {
            sess.DeleteFile(this.getPerTestFileName(threadId, iter));
        }
    }
}

