/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.smb.server.disk;

import java.io.IOException;
import org.alfresco.jlan.locking.FileLock;
import org.alfresco.jlan.locking.LockConflictException;
import org.alfresco.jlan.locking.NotLockedException;
import org.alfresco.jlan.server.SrvSession;
import org.alfresco.jlan.server.filesys.NetworkFile;
import org.alfresco.jlan.server.filesys.TreeConnection;
import org.alfresco.jlan.server.locking.LockManager;
import org.alfresco.jlan.smb.server.disk.NIOFileLock;
import org.alfresco.jlan.smb.server.disk.NIOJavaNetworkFile;

public class NIOLockManager
implements LockManager {
    @Override
    public void lockFile(SrvSession sess, TreeConnection tree, NetworkFile file, FileLock lock) throws LockConflictException, IOException {
        if (!(file instanceof NIOJavaNetworkFile)) {
            throw new IllegalArgumentException("Invalid NetworkFile class");
        }
        if (!(lock instanceof NIOFileLock)) {
            throw new IllegalArgumentException("Invalid FileLock class");
        }
        NIOJavaNetworkFile nioFile = (NIOJavaNetworkFile)file;
        NIOFileLock nioLock = (NIOFileLock)lock;
        nioFile.lockFile(nioLock);
    }

    @Override
    public void unlockFile(SrvSession sess, TreeConnection tree, NetworkFile file, FileLock lock) throws NotLockedException, IOException {
        if (!(file instanceof NIOJavaNetworkFile)) {
            throw new IllegalArgumentException("Invalid NetworkFile class");
        }
        if (!(lock instanceof NIOFileLock)) {
            throw new IllegalArgumentException("Invalid FileLock class");
        }
        NIOJavaNetworkFile nioFile = (NIOJavaNetworkFile)file;
        NIOFileLock nioLock = (NIOFileLock)lock;
        nioFile.unlockFile(nioLock);
    }

    @Override
    public FileLock createLockObject(SrvSession sess, TreeConnection tree, NetworkFile file, long offset, long len, int pid) {
        return new NIOFileLock(offset, len, pid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void releaseLocksForFile(SrvSession sess, TreeConnection tree, NetworkFile file) {
        if (!file.hasLocks()) return;
        NetworkFile networkFile = file;
        synchronized (networkFile) {
            while (file.numberOfLocks() > 0) {
                FileLock curLock = file.getLockAt(0);
                try {
                    this.unlockFile(sess, tree, file, curLock);
                }
                catch (Exception ex) {}
            }
            return;
        }
    }
}

