/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.smb.server.disk;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.util.StringTokenizer;
import org.alfresco.jlan.server.SrvSession;
import org.alfresco.jlan.server.core.DeviceContext;
import org.alfresco.jlan.server.core.DeviceContextException;
import org.alfresco.jlan.server.filesys.AccessDeniedException;
import org.alfresco.jlan.server.filesys.DiskDeviceContext;
import org.alfresco.jlan.server.filesys.DiskInterface;
import org.alfresco.jlan.server.filesys.FileExistsException;
import org.alfresco.jlan.server.filesys.FileInfo;
import org.alfresco.jlan.server.filesys.FileName;
import org.alfresco.jlan.server.filesys.FileOpenParams;
import org.alfresco.jlan.server.filesys.NetworkFile;
import org.alfresco.jlan.server.filesys.PathNotFoundException;
import org.alfresco.jlan.server.filesys.SearchContext;
import org.alfresco.jlan.server.filesys.TreeConnection;
import org.alfresco.jlan.server.locking.FileLockingInterface;
import org.alfresco.jlan.server.locking.LockManager;
import org.alfresco.jlan.smb.server.disk.JavaFileSearchContext;
import org.alfresco.jlan.smb.server.disk.NIOJavaNetworkFile;
import org.alfresco.jlan.smb.server.disk.NIOLockManager;
import org.springframework.extensions.config.ConfigElement;

public class EnhJavaFileDiskDriver
implements DiskInterface,
FileLockingInterface {
    private static final String DOS_SEPERATOR = "\\";
    protected static long _globalCreateDate = System.currentTimeMillis();
    private static LockManager _lockManager = new NIOLockManager();

    protected FileInfo buildFileInformation(String path, String relPath) {
        String[] pathStr = FileName.splitPath(path, File.separatorChar);
        if (pathStr[1] != null) {
            File file = new File(pathStr[0], pathStr[1]);
            if (file.exists() && file.isFile()) {
                long flen = file.length();
                long alloc = flen + 512L & 0xFFFFFFFFFFFFFE00L;
                int fattr = 0;
                if (file.isDirectory()) {
                    fattr = 16;
                }
                if (!file.canWrite()) {
                    ++fattr;
                }
                if (pathStr[1].equalsIgnoreCase("Desktop.ini") || pathStr[1].equalsIgnoreCase("Thumbs.db") || pathStr[1].charAt(0) == '.') {
                    fattr += 2;
                }
                FileInfo finfo = new FileInfo(pathStr[1], flen, fattr);
                long fdate = file.lastModified();
                finfo.setModifyDateTime(fdate);
                finfo.setAllocationSize(alloc);
                finfo.setFileId(relPath.hashCode());
                finfo.setCreationDateTime(EnhJavaFileDiskDriver.getGlobalCreateDateTime() > fdate ? fdate : EnhJavaFileDiskDriver.getGlobalCreateDateTime());
                finfo.setChangeDateTime(fdate);
                return finfo;
            }
            File dir = new File(FileName.buildPath(pathStr[0], pathStr[1], null, File.separatorChar));
            if (dir.exists()) {
                int fattr = 0;
                if (dir.isDirectory()) {
                    fattr = 16;
                }
                FileInfo finfo = new FileInfo(pathStr[1] != null ? pathStr[1] : "", 0L, fattr);
                long fdate = file.lastModified();
                finfo.setModifyDateTime(fdate);
                finfo.setFileId(relPath.hashCode());
                finfo.setCreationDateTime(EnhJavaFileDiskDriver.getGlobalCreateDateTime() > fdate ? fdate : EnhJavaFileDiskDriver.getGlobalCreateDateTime());
                finfo.setChangeDateTime(fdate);
                return finfo;
            }
        } else {
            File dir = new File(pathStr[0]);
            if (dir.exists()) {
                int fattr = 0;
                if (dir.isDirectory()) {
                    fattr = 16;
                }
                FileInfo finfo = new FileInfo(pathStr[1] != null ? pathStr[1] : "", 0L, fattr);
                long fdate = dir.lastModified();
                finfo.setModifyDateTime(fdate);
                finfo.setFileId(relPath.hashCode());
                finfo.setCreationDateTime(EnhJavaFileDiskDriver.getGlobalCreateDateTime() > fdate ? fdate : EnhJavaFileDiskDriver.getGlobalCreateDateTime());
                finfo.setChangeDateTime(fdate);
                return finfo;
            }
        }
        return null;
    }

    @Override
    public void closeFile(SrvSession sess, TreeConnection tree, NetworkFile file) throws IOException {
        file.closeFile();
        if (file.hasDeleteOnClose()) {
            if (file.isDirectory()) {
                this.deleteDirectory(sess, tree, file.getFullName());
            } else {
                this.deleteFile(sess, tree, file.getFullName());
            }
        }
    }

    @Override
    public void createDirectory(SrvSession sess, TreeConnection tree, FileOpenParams params) throws IOException {
        String dirname = FileName.buildPath(tree.getContext().getDeviceName(), params.getPath(), null, File.separatorChar);
        File newDir = new File(dirname);
        if (!newDir.mkdir()) {
            throw new IOException("Failed to create directory " + dirname);
        }
    }

    @Override
    public NetworkFile createFile(SrvSession sess, TreeConnection tree, FileOpenParams params) throws IOException {
        DeviceContext ctx = tree.getContext();
        String fname = FileName.buildPath(ctx.getDeviceName(), params.getPath(), null, File.separatorChar);
        File file = new File(fname);
        if (file.exists()) {
            throw new FileExistsException();
        }
        FileWriter newFile = new FileWriter(fname, false);
        newFile.close();
        file = new File(fname);
        NIOJavaNetworkFile netFile = new NIOJavaNetworkFile(file, params.getPath());
        netFile.setGrantedAccess(3);
        netFile.setFullName(params.getPath());
        return netFile;
    }

    @Override
    public void deleteDirectory(SrvSession sess, TreeConnection tree, String dir) throws IOException {
        String mappedPath;
        DeviceContext ctx = tree.getContext();
        String dirname = FileName.buildPath(ctx.getDeviceName(), dir, null, File.separatorChar);
        File delDir = new File(dirname);
        if (delDir.exists() && delDir.isDirectory()) {
            String[] fileList = delDir.list();
            if (fileList != null && fileList.length > 0) {
                throw new AccessDeniedException("Directory not empty");
            }
            delDir.delete();
        } else if (!delDir.exists() && (mappedPath = this.mapPath(ctx.getDeviceName(), dir)) != null && (delDir = new File(mappedPath)).isDirectory()) {
            String[] fileList = delDir.list();
            if (fileList != null && fileList.length > 0) {
                throw new AccessDeniedException("Directory not empty");
            }
            delDir.delete();
        }
    }

    @Override
    public void deleteFile(SrvSession sess, TreeConnection tree, String name) throws IOException {
        String mappedPath;
        DeviceContext ctx = tree.getContext();
        String fullname = FileName.buildPath(ctx.getDeviceName(), name, null, File.separatorChar);
        File delFile = new File(fullname);
        if (delFile.exists() && delFile.isFile()) {
            delFile.delete();
        } else if (!delFile.exists() && (mappedPath = this.mapPath(ctx.getDeviceName(), name)) != null && (delFile = new File(mappedPath)).exists() && delFile.isFile()) {
            delFile.delete();
        }
    }

    @Override
    public int fileExists(SrvSession sess, TreeConnection tree, String name) {
        DeviceContext ctx = tree.getContext();
        String filename = FileName.buildPath(ctx.getDeviceName(), name, null, File.separatorChar);
        File chkFile = new File(filename);
        if (chkFile.exists()) {
            if (chkFile.isFile()) {
                return 1;
            }
            return 2;
        }
        if (!chkFile.exists()) {
            try {
                String mappedPath = this.mapPath(ctx.getDeviceName(), name);
                if (mappedPath != null && (chkFile = new File(mappedPath)).exists()) {
                    if (chkFile.isFile()) {
                        return 1;
                    }
                    return 2;
                }
            }
            catch (FileNotFoundException ex) {
            }
            catch (PathNotFoundException ex) {
                // empty catch block
            }
        }
        return 0;
    }

    @Override
    public void flushFile(SrvSession sess, TreeConnection tree, NetworkFile file) throws IOException {
        file.flushFile();
    }

    @Override
    public FileInfo getFileInformation(SrvSession sess, TreeConnection tree, String name) throws IOException {
        DeviceContext ctx = tree.getContext();
        String path = FileName.buildPath(ctx.getDeviceName(), name, null, File.separatorChar);
        FileInfo info = this.buildFileInformation(path, name);
        if (info != null) {
            return info;
        }
        String mappedPath = this.mapPath(ctx.getDeviceName(), name);
        if (mappedPath != null) {
            return this.buildFileInformation(mappedPath, name);
        }
        return null;
    }

    @Override
    public boolean isReadOnly(SrvSession sess, DeviceContext ctx) throws IOException {
        File rootDir = new File(ctx.getDeviceName());
        if (!rootDir.exists() || !rootDir.isDirectory()) {
            throw new FileNotFoundException(ctx.getDeviceName());
        }
        boolean readOnly = true;
        try {
            File tempFile = null;
            boolean fileOK = false;
            while (!fileOK) {
                tempFile = new File(rootDir, "_JSRV" + (System.currentTimeMillis() & 0xFFFL) + ".TMP");
                if (tempFile.exists()) continue;
                fileOK = true;
            }
            FileWriter outFile = new FileWriter(tempFile);
            outFile.close();
            tempFile.delete();
            readOnly = false;
        }
        catch (IllegalArgumentException ex) {
        }
        catch (IOException ex) {
            // empty catch block
        }
        return readOnly;
    }

    protected final String mapPath(String path) throws FileNotFoundException, PathNotFoundException {
        return this.mapPath("", path);
    }

    protected final String mapPath(String base, String path) throws FileNotFoundException, PathNotFoundException {
        String pathCopy = path;
        if (pathCopy.length() > 0 && pathCopy.startsWith(DOS_SEPERATOR)) {
            pathCopy = pathCopy.substring(1);
        }
        StringTokenizer token = new StringTokenizer(pathCopy, "\\/");
        int tokCnt = token.countTokens();
        String mappedPath = null;
        if (tokCnt > 0) {
            String[] fileList;
            String[] dirs = new String[token.countTokens()];
            int idx = 0;
            while (token.hasMoreTokens()) {
                dirs[idx++] = token.nextToken();
            }
            int maxDir = dirs.length;
            if (!path.endsWith(DOS_SEPERATOR)) {
                --maxDir;
            }
            StringBuffer pathStr = new StringBuffer(base);
            if (!base.endsWith(File.separator)) {
                pathStr.append(File.separator);
            }
            int lastPos = pathStr.length();
            idx = 0;
            File lastDir = null;
            if (base != null && base.length() > 0) {
                lastDir = new File(base);
            }
            File curDir = null;
            while (idx < maxDir) {
                pathStr.append(dirs[idx]);
                pathStr.append(File.separator);
                curDir = new File(pathStr.toString());
                if (!curDir.exists()) {
                    if (lastDir == null) {
                        throw new PathNotFoundException();
                    }
                    fileList = lastDir.list();
                    if (fileList == null || fileList.length == 0) {
                        throw new PathNotFoundException();
                    }
                    boolean foundPath = false;
                    for (int fidx = 0; fidx < fileList.length && !foundPath; ++fidx) {
                        if (!fileList[fidx].equalsIgnoreCase(dirs[idx])) continue;
                        pathStr.setLength(lastPos);
                        pathStr.append(fileList[fidx]);
                        pathStr.append(File.separator);
                        curDir = new File(pathStr.toString());
                        if (!curDir.exists()) continue;
                        foundPath = true;
                        break;
                    }
                    if (!foundPath) {
                        throw new PathNotFoundException();
                    }
                }
                lastDir = curDir;
                lastPos = pathStr.length();
                ++idx;
            }
            if (!path.endsWith(DOS_SEPERATOR)) {
                fileList = lastDir.list();
                String fileName = dirs[dirs.length - 1];
                if (fileList == null) {
                    throw new FileNotFoundException(path);
                }
                idx = 0;
                boolean foundFile = false;
                while (idx < fileList.length && !foundFile) {
                    if (fileList[idx].compareTo(fileName) == 0) {
                        foundFile = true;
                        continue;
                    }
                    ++idx;
                }
                if (!foundFile) {
                    idx = 0;
                    while (idx < fileList.length && !foundFile) {
                        if (fileList[idx].equalsIgnoreCase(fileName)) {
                            foundFile = true;
                            fileName = fileList[idx];
                            continue;
                        }
                        ++idx;
                    }
                }
                pathStr.append(fileName);
            }
            mappedPath = pathStr.toString();
        }
        return mappedPath;
    }

    @Override
    public NetworkFile openFile(SrvSession sess, TreeConnection tree, FileOpenParams params) throws IOException {
        DeviceContext ctx = tree.getContext();
        String fname = FileName.buildPath(ctx.getDeviceName(), params.getPath(), null, File.separatorChar);
        File file = new File(fname);
        if (!file.exists()) {
            String mappedPath = this.mapPath(ctx.getDeviceName(), params.getPath());
            if (mappedPath == null) {
                throw new FileNotFoundException(fname);
            }
            file = new File(mappedPath);
            if (!file.exists()) {
                throw new FileNotFoundException(fname);
            }
        }
        if (!file.canWrite() && (params.isReadWriteAccess() || params.isWriteOnlyAccess())) {
            throw new AccessDeniedException("File " + fname + " is read-only");
        }
        NIOJavaNetworkFile netFile = new NIOJavaNetworkFile(file, params.getPath());
        if (params.isReadOnlyAccess()) {
            netFile.setGrantedAccess(1);
        } else {
            netFile.setGrantedAccess(3);
        }
        netFile.setFullName(params.getPath());
        if (file.isDirectory() || file.list() != null) {
            netFile.setAttributes(16);
        }
        return netFile;
    }

    @Override
    public int readFile(SrvSession sess, TreeConnection tree, NetworkFile file, byte[] buf, int bufPos, int siz, long filePos) throws IOException {
        if (file.isDirectory()) {
            throw new AccessDeniedException();
        }
        int rdlen = file.readFile(buf, siz, bufPos, filePos);
        if (rdlen == -1) {
            rdlen = 0;
        }
        return rdlen;
    }

    @Override
    public void renameFile(SrvSession sess, TreeConnection tree, String oldName, String newName) throws IOException {
        DeviceContext ctx = tree.getContext();
        String oldPath = FileName.buildPath(ctx.getDeviceName(), oldName, null, File.separatorChar);
        String newPath = FileName.buildPath(ctx.getDeviceName(), newName, null, File.separatorChar);
        if (this.fileExists(sess, tree, oldName) == 0) {
            throw new FileNotFoundException("Rename file, does not exist " + oldName);
        }
        if (this.fileExists(sess, tree, newName) != 0) {
            throw new FileExistsException("Rename file, path exists " + newName);
        }
        File oldFile = new File(oldPath);
        File newFile = new File(newPath);
        if (!oldFile.renameTo(newFile)) {
            throw new IOException("Rename " + oldPath + " to " + newPath + " failed");
        }
    }

    @Override
    public long seekFile(SrvSession sess, TreeConnection tree, NetworkFile file, long pos, int typ) throws IOException {
        return file.seekFile(pos, typ);
    }

    @Override
    public void setFileInformation(SrvSession sess, TreeConnection tree, String name, FileInfo info) throws IOException {
        if (info.hasSetFlag(8)) {
            DeviceContext ctx = tree.getContext();
            String fname = FileName.buildPath(ctx.getDeviceName(), name, null, File.separatorChar);
            File file = new File(fname);
            file.setLastModified(info.getModifyDateTime());
        }
    }

    @Override
    public SearchContext startSearch(SrvSession sess, TreeConnection tree, String searchPath, int attrib) throws FileNotFoundException {
        JavaFileSearchContext srch = new JavaFileSearchContext();
        String path = FileName.buildPath(tree.getContext().getDeviceName(), null, searchPath, File.separatorChar);
        try {
            path = this.mapPath(path);
            if (sess != null && sess.hasDebug(128)) {
                sess.debugPrintln("  Start search path=" + path);
            }
            srch.initSearch(path, attrib);
            return srch;
        }
        catch (PathNotFoundException ex) {
            throw new FileNotFoundException();
        }
    }

    @Override
    public void truncateFile(SrvSession sess, TreeConnection tree, NetworkFile file, long siz) throws IOException {
        file.truncateFile(siz);
        file.flushFile();
    }

    @Override
    public int writeFile(SrvSession sess, TreeConnection tree, NetworkFile file, byte[] buf, int bufoff, int siz, long fileoff) throws IOException {
        if (file.isDirectory()) {
            throw new AccessDeniedException();
        }
        file.writeFile(buf, siz, bufoff, fileoff);
        return siz;
    }

    @Override
    public DeviceContext createContext(String shareName, ConfigElement args) throws DeviceContextException {
        ConfigElement path = args.getChild("LocalPath");
        DiskDeviceContext ctx = null;
        if (path != null) {
            File rootDir = new File(path.getValue());
            ctx = new DiskDeviceContext(rootDir.getAbsolutePath());
            ctx.setFilesystemAttributes(6);
            if (!rootDir.exists() || !rootDir.isDirectory() || rootDir.list() == null) {
                ctx.setAvailable(false);
            }
            return ctx;
        }
        throw new DeviceContextException("LocalPath parameter not specified");
    }

    @Override
    public void treeOpened(SrvSession sess, TreeConnection tree) {
    }

    @Override
    public void treeClosed(SrvSession sess, TreeConnection tree) {
    }

    public static final long getGlobalCreateDateTime() {
        return _globalCreateDate;
    }

    @Override
    public LockManager getLockManager(SrvSession sess, TreeConnection tree) {
        return _lockManager;
    }
}

