/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.smb.nt;

import org.alfresco.jlan.smb.nt.LoadException;
import org.alfresco.jlan.smb.nt.SaveException;
import org.alfresco.jlan.util.DataBuffer;
import org.alfresco.jlan.util.DataPacker;

public class SID {
    public static final int IdentAuthNull = 0;
    public static final int IdentAuthWorld = 1;
    public static final int IdentAuthLocal = 2;
    public static final int IdentAuthCreator = 3;
    public static final int IdentAuthNonUnique = 4;
    public static final int IdentAuthNT = 5;
    public static final int SubAuthNull = 0;
    public static final int SubAuthWorld = 0;
    public static final int SubAuthLocal = 0;
    public static final int SubAuthCreatorOwner = 0;
    public static final int SubAuthCreatorGroup = 1;
    public static final int SubAuthNTDialup = 1;
    public static final int SubAuthNTNetwork = 2;
    public static final int SubAuthNTBatch = 3;
    public static final int SubAuthNTInteractive = 4;
    public static final int SubAuthNTService = 6;
    public static final int SubAuthNTAnonymous = 7;
    public static final int SubAuthNTProxy = 8;
    public static final int SubAuthNTEnterpriseCtrl = 9;
    public static final int SubAuthNTPrincipalSelf = 10;
    public static final int SubAuthNTAuthenticated = 11;
    public static final int SubAuthNTRestrictedCode = 12;
    public static final int SubAuthNTTerminalServer = 13;
    public static final int SubAuthNTLocalSystem = 18;
    public static final int SubAuthNTNonUnique = 21;
    public static final int SubAuthNTBuiltinDomain = 32;
    private static final int MinimumBinarySize = 12;
    private int m_revision;
    private byte[] m_identAuth;
    private int m_subAuthCnt;
    private int[] m_subAuth;
    private int m_rid = -1;
    private String m_name;

    public SID() {
    }

    public SID(String name, int rev, int auth, int subauth) {
        this.m_name = name;
        this.m_revision = rev;
        this.m_identAuth = new byte[6];
        this.m_identAuth[5] = (byte)(auth & 0xFF);
        this.m_subAuthCnt = 1;
        this.m_subAuth = new int[1];
        this.m_subAuth[0] = subauth;
        this.m_rid = -1;
    }

    public SID(int rev, int auth, int subauth, int rid) {
        this.m_revision = rev;
        this.m_identAuth = new byte[6];
        this.m_identAuth[5] = (byte)(auth & 0xFF);
        this.m_subAuthCnt = 1;
        this.m_subAuth = new int[1];
        this.m_subAuth[0] = subauth;
        this.m_rid = rid;
    }

    public SID(int rev, int auth, int subauth1, int subauth2, int rid) {
        this.m_revision = rev;
        this.m_identAuth = new byte[6];
        this.m_identAuth[5] = (byte)(auth & 0xFF);
        this.m_subAuthCnt = 2;
        this.m_subAuth = new int[2];
        this.m_subAuth[0] = subauth1;
        this.m_subAuth[1] = subauth2;
        this.m_rid = rid;
    }

    public SID(SID sid) {
        this.m_revision = sid.getRevision();
        this.m_identAuth = sid.getIdentifierAuthority();
        this.m_subAuthCnt = sid.getSubauthorityCount();
        if (sid.hasRID()) {
            --this.m_subAuthCnt;
        }
        this.m_subAuth = new int[this.m_subAuthCnt];
        for (int i = 0; i < this.m_subAuth.length; ++i) {
            this.m_subAuth[i] = sid.getSubauthority(i);
        }
        this.m_rid = sid.getRID();
    }

    public final int getRevision() {
        return this.m_revision;
    }

    public final byte[] getIdentifierAuthority() {
        return this.m_identAuth;
    }

    public final int getSubauthorityCount() {
        if (this.m_rid != -1) {
            return this.m_subAuthCnt + 1;
        }
        return this.m_subAuthCnt;
    }

    public final int getSubauthority(int idx) {
        if (idx < 0 || idx >= this.m_subAuthCnt) {
            return -1;
        }
        return this.m_subAuth[idx];
    }

    public final boolean hasRID() {
        return this.m_rid != -1;
    }

    public final int getRID() {
        return this.m_rid;
    }

    public final boolean hasName() {
        return this.m_name != null;
    }

    public final String getName() {
        return this.m_name;
    }

    public final boolean equalsSID(SID sid) {
        if (this.getRevision() == sid.getRevision() && this.getIdentifierAuthority() != null && sid.getIdentifierAuthority() != null) {
            int i;
            byte[] sidIdent = sid.getIdentifierAuthority();
            if (sidIdent.length != this.m_identAuth.length) {
                return false;
            }
            for (i = 0; i < this.m_identAuth.length; ++i) {
                if (this.m_identAuth[i] == sidIdent[i]) continue;
                return false;
            }
            for (i = 0; i < this.getSubauthorityCount(); ++i) {
                if (this.getSubauthority(i) == sid.getSubauthority(i)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public final void setRID(int id) {
        this.m_rid = id;
    }

    public final void setName(String name) {
        this.m_name = name;
    }

    public final int loadSID(byte[] buf, int off, boolean domain) throws LoadException {
        if (buf.length - off < 12) {
            throw new LoadException("Buffer too short for SID");
        }
        this.m_revision = buf[off++] & 0xFF;
        this.m_subAuthCnt = buf[off++] & 0xFF;
        if (this.m_identAuth == null) {
            this.m_identAuth = new byte[6];
        }
        for (int i = 0; i < 6; ++i) {
            this.m_identAuth[i] = buf[off++];
        }
        boolean hasRID = false;
        if (!domain && this.m_subAuthCnt > 1) {
            --this.m_subAuthCnt;
            hasRID = true;
        }
        this.m_subAuth = new int[this.m_subAuthCnt];
        for (int i = 0; i < this.m_subAuthCnt; ++i) {
            this.m_subAuth[i] = DataPacker.getIntelInt(buf, off);
            off += 4;
        }
        if (hasRID) {
            this.m_rid = DataPacker.getIntelInt(buf, off);
            off += 4;
        }
        return off;
    }

    public final int loadSID(DataBuffer buf, boolean domain) throws LoadException {
        if (buf.getAvailableLength() < 12) {
            throw new LoadException("Buffer too short for SID");
        }
        this.m_revision = buf.getByte();
        this.m_subAuthCnt = buf.getByte();
        if (this.m_identAuth == null) {
            this.m_identAuth = new byte[6];
        }
        for (int i = 0; i < 6; ++i) {
            this.m_identAuth[i] = (byte)(buf.getByte() & 0xFF);
        }
        boolean hasRID = false;
        if (!domain && this.m_subAuthCnt > 1) {
            --this.m_subAuthCnt;
            hasRID = true;
        }
        this.m_subAuth = new int[this.m_subAuthCnt];
        for (int i = 0; i < this.m_subAuthCnt; ++i) {
            this.m_subAuth[i] = buf.getInt();
        }
        if (hasRID) {
            this.m_rid = buf.getInt();
        }
        return buf.getPosition();
    }

    public final int saveSID(byte[] buf, int off) throws SaveException {
        int i;
        buf[off++] = (byte)(this.m_revision & 0xFF);
        buf[off++] = (byte)(this.m_rid != -1 ? this.m_subAuthCnt + 1 : this.m_subAuthCnt);
        for (i = 0; i < 6; ++i) {
            buf[off++] = this.m_identAuth[i];
        }
        if (this.m_subAuth != null) {
            for (i = 0; i < this.m_subAuth.length; ++i) {
                DataPacker.putIntelInt(this.m_subAuth[i], buf, off);
                off += 4;
            }
        }
        if (this.m_rid != -1) {
            DataPacker.putIntelInt(this.m_rid, buf, off);
            off += 4;
        }
        return off;
    }

    public final int saveSID(DataBuffer buf) throws SaveException {
        int i;
        buf.putByte(this.m_revision);
        buf.putByte(this.m_rid != -1 ? this.m_subAuthCnt + 1 : this.m_subAuthCnt);
        for (i = 0; i < 6; ++i) {
            buf.putByte(this.m_identAuth[i]);
        }
        if (this.m_subAuth != null) {
            for (i = 0; i < this.m_subAuth.length; ++i) {
                buf.putInt(this.m_subAuth[i]);
            }
        }
        if (this.m_rid != -1) {
            buf.putInt(this.m_rid);
        }
        return buf.getPosition();
    }

    public String toString() {
        if (this.hasName()) {
            return this.getName();
        }
        StringBuffer str = new StringBuffer();
        str.append("S-");
        str.append(this.getRevision());
        str.append("-");
        str.append(this.m_identAuth[5]);
        for (int i = 0; i < this.m_subAuth.length; ++i) {
            str.append("-");
            str.append(this.getSubauthority(i));
        }
        if (this.getRID() != -1) {
            str.append("-");
            str.append(this.getRID());
        }
        return str.toString();
    }
}

