/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.smb.nt;

import org.alfresco.jlan.smb.nt.LoadException;
import org.alfresco.jlan.smb.nt.SID;
import org.alfresco.jlan.smb.nt.SaveException;
import org.alfresco.jlan.util.DataBuffer;
import org.alfresco.jlan.util.DataPacker;

public class ACE {
    public static final int Allowed = 0;
    public static final int Denied = 1;
    public static final int Audit = 2;
    public static final int Alarm = 3;
    public static final int AllowedCompound = 4;
    public static final int AllowedObject = 5;
    public static final int DeniedObject = 6;
    public static final int AuditObject = 7;
    public static final int AlarmObject = 8;
    private static final String[] _typeStr = new String[]{"Allow", "Deny", "Audit", "Alarm", "AlCm", "AlOb", "DeOb", "AuOb", "AlmO"};
    public static final int ObjectInherit = 1;
    public static final int ContainerInherit = 2;
    public static final int NoPropagateInherit = 4;
    public static final int InheritOnly = 8;
    public static final int Inherited = 16;
    public static final int SuccessfulAccess = 64;
    public static final int FailedAccess = 128;
    public static final int FullAccess = 0x1F01FF;
    private int m_type;
    private int m_flags;
    private int m_accessMask;
    private SID m_sid;

    public ACE() {
    }

    public ACE(int type, int flags, int mask, SID sid) {
        this.m_type = type;
        this.m_flags = flags;
        this.m_accessMask = mask;
        this.m_sid = sid;
    }

    public final int getType() {
        return this.m_type;
    }

    public final int getFlags() {
        return this.m_flags;
    }

    public final int getAccessMask() {
        return this.m_accessMask;
    }

    public final SID getSID() {
        return this.m_sid;
    }

    public final boolean hasObjectInherit() {
        return (this.m_flags & 1) != 0;
    }

    public final boolean hasContainerInherit() {
        return (this.m_flags & 2) != 0;
    }

    public final boolean hasNoPropagateInherit() {
        return (this.m_flags & 4) != 0;
    }

    public final boolean hasInheritOnly() {
        return (this.m_flags & 8) != 0;
    }

    public final boolean isInherited() {
        return (this.m_flags & 0x10) != 0;
    }

    public final boolean isSuccessfulAccess() {
        return (this.m_flags & 0x40) != 0;
    }

    public final boolean isFailedAccess() {
        return (this.m_flags & 0x80) != 0;
    }

    public final int loadACE(byte[] buf, int off) throws LoadException {
        this.m_type = buf[off] & 0xFF;
        this.m_flags = buf[off + 1] & 0xFF;
        int siz = DataPacker.getIntelShort(buf, off + 2);
        if (this.getType() >= 0 && this.getType() <= 3) {
            this.m_accessMask = DataPacker.getIntelInt(buf, off + 4);
            this.m_sid = new SID();
            this.m_sid.loadSID(buf, off + 8, false);
        }
        return off + siz;
    }

    public final int loadACE(DataBuffer buf) throws LoadException {
        this.m_type = buf.getByte();
        this.m_flags = buf.getByte();
        int siz = buf.getShort();
        if (this.getType() >= 0 && this.getType() <= 3) {
            this.m_accessMask = buf.getInt();
            this.m_sid = new SID();
            this.m_sid.loadSID(buf, false);
        }
        return buf.getPosition();
    }

    public final int saveACE(byte[] buf, int off) throws SaveException {
        buf[off] = (byte)(this.m_type & 0xFF);
        buf[off + 1] = (byte)(this.m_flags & 0xFF);
        int endPos = off + 4;
        if (this.getType() >= 0 && this.getType() <= 3) {
            DataPacker.putIntelInt(this.m_accessMask, buf, off + 4);
            endPos += 4;
            endPos = this.m_sid.saveSID(buf, endPos);
        }
        DataPacker.putIntelShort(endPos - off, buf, off + 2);
        return endPos;
    }

    public final int saveACE(DataBuffer buf) throws SaveException {
        int startPos = buf.getPosition();
        buf.putByte(this.m_type);
        buf.putByte(this.m_flags);
        buf.putShort(0);
        if (this.getType() >= 0 && this.getType() <= 3) {
            buf.putInt(this.m_accessMask);
            this.m_sid.saveSID(buf);
        }
        int endPos = buf.getPosition();
        buf.setPosition(startPos + 2);
        buf.putShort(endPos - startPos);
        buf.setPosition(endPos);
        return endPos;
    }

    public final String getTypeAsString() {
        return _typeStr[this.getType()];
    }

    public final String getAccessMaskAsString() {
        if (this.getAccessMask() == 0x1F01FF) {
            return "FullAccess";
        }
        return "0x" + Integer.toHexString(this.getAccessMask());
    }

    public String toString() {
        StringBuffer str = new StringBuffer();
        str.append("[");
        str.append(_typeStr[this.getType()]);
        str.append(",");
        if (this.getAccessMask() == 0x1F01FF) {
            str.append("FullAccess");
        } else {
            str.append("0x");
            str.append(Integer.toHexString(this.getAccessMask()));
        }
        str.append(",");
        str.append(this.getSID().toString());
        str.append("]");
        return str.toString();
    }
}

