/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.smb;

public final class SMBErrorText {
    public static final String ErrorString(int errclass, int errcode) {
        String errtext = null;
        switch (errclass) {
            case 0: {
                errtext = "The request was successful";
                break;
            }
            case 1: {
                errtext = SMBErrorText.DOSErrorText(errcode);
                break;
            }
            case 2: {
                errtext = SMBErrorText.ServerErrorText(errcode);
                break;
            }
            case 3: {
                errtext = SMBErrorText.HardwareErrorText(errcode);
                break;
            }
            case 4: {
                errtext = SMBErrorText.NetworkErrorText(errcode);
                break;
            }
            case 5: {
                errtext = SMBErrorText.JLANErrorText(errcode);
                break;
            }
            case 6: {
                errtext = SMBErrorText.NTErrorText(errcode);
                break;
            }
            case 8: {
                errtext = SMBErrorText.Win32ErrorText(errcode);
                break;
            }
            case 7: {
                errtext = SMBErrorText.DCERPCErrorText(errcode);
                break;
            }
            case 255: {
                errtext = "Command was not in the SMB format";
            }
        }
        if (errtext == null) {
            errtext = "[Unknown error status/class: " + errclass + "," + errcode + "]";
        }
        return errtext;
    }

    private static String DOSErrorText(int errcode) {
        String errtext = null;
        switch (errcode) {
            case 1: {
                errtext = "Invalid function. Server did not recognize/perform system call";
                break;
            }
            case 2: {
                errtext = "File not found";
                break;
            }
            case 3: {
                errtext = "Directory invalid";
                break;
            }
            case 4: {
                errtext = "Too many open files";
                break;
            }
            case 5: {
                errtext = "Access denied";
                break;
            }
            case 6: {
                errtext = "Invalid file handle";
                break;
            }
            case 7: {
                errtext = "Memory control blocks destroyed";
                break;
            }
            case 8: {
                errtext = "Insufficient server memory to perform function";
                break;
            }
            case 9: {
                errtext = "Invalid memory block address";
                break;
            }
            case 10: {
                errtext = "Invalid environment";
                break;
            }
            case 11: {
                errtext = "Invalid format";
                break;
            }
            case 12: {
                errtext = "Invalid open mode";
                break;
            }
            case 13: {
                errtext = "Invalid data, in server IOCTL call";
                break;
            }
            case 15: {
                errtext = "Invalid drive specified";
                break;
            }
            case 16: {
                errtext = "Delete directory attempted to delete servers directory";
                break;
            }
            case 17: {
                errtext = "Not same device";
                break;
            }
            case 18: {
                errtext = "No more files";
                break;
            }
            case 32: {
                errtext = "File sharing mode conflict";
                break;
            }
            case 33: {
                errtext = "Lock request conflicts with existing lock";
                break;
            }
            case 66: {
                errtext = "IPC not supported";
                break;
            }
            case 80: {
                errtext = "File already exists";
                break;
            }
            case 110: {
                errtext = "Cannot open the file specified";
                break;
            }
            case 124: {
                errtext = "Unknown information level";
                break;
            }
            case 145: {
                errtext = "Directory not empty";
                break;
            }
            case 158: {
                errtext = "Not locked";
                break;
            }
            case 230: {
                errtext = "Named pipe invalid";
                break;
            }
            case 231: {
                errtext = "All instances of pipe are busy";
                break;
            }
            case 232: {
                errtext = "Named pipe close in progress";
                break;
            }
            case 233: {
                errtext = "No process on other end of named pipe";
                break;
            }
            case 234: {
                errtext = "More data to be returned";
                break;
            }
            case 267: {
                errtext = "Invalid directory name in path";
                break;
            }
            case 275: {
                errtext = "Extended attributes did not fit";
                break;
            }
            case 282: {
                errtext = "Extended attributes not supported";
                break;
            }
            case 2142: {
                errtext = "Unknown IPC";
            }
        }
        return errtext;
    }

    private static final String HardwareErrorText(int errcode) {
        String errtext = null;
        switch (errcode) {
            case 19: {
                errtext = "Attempt to write on write protected media";
                break;
            }
            case 20: {
                errtext = "Unknown unit";
                break;
            }
            case 21: {
                errtext = "Drive not ready";
                break;
            }
            case 22: {
                errtext = "Unknown command";
                break;
            }
            case 23: {
                errtext = "Data error (CRC)";
                break;
            }
            case 24: {
                errtext = "Bad request structure length";
                break;
            }
            case 25: {
                errtext = "Seek error";
                break;
            }
            case 26: {
                errtext = "Unknown media type";
                break;
            }
            case 27: {
                errtext = "Sector not found";
                break;
            }
            case 28: {
                errtext = "Printer out of paper";
                break;
            }
            case 29: {
                errtext = "Write fault";
                break;
            }
            case 30: {
                errtext = "Read fault";
                break;
            }
            case 31: {
                errtext = "General failure";
                break;
            }
            case 32: {
                errtext = "Open conflicts with existing open";
                break;
            }
            case 33: {
                errtext = "Lock request conflicted with existing lock";
                break;
            }
            case 34: {
                errtext = "Wrong disk was found in a drive";
                break;
            }
            case 35: {
                errtext = "No FCBs are available to process request";
                break;
            }
            case 36: {
                errtext = "A sharing buffer has been exceeded";
            }
        }
        return errtext;
    }

    private static String JLANErrorText(int errcode) {
        String errtext = null;
        switch (errcode) {
            case 1: {
                errtext = "Invalid device type for dialect";
                break;
            }
            case 2: {
                errtext = "Evaluation period expired";
                break;
            }
            case 3: {
                errtext = "Feature not available, upgrade to JLAN Pro";
                break;
            }
            case 4: {
                errtext = "No more sessions available";
                break;
            }
            case 5: {
                errtext = "Session is not active";
                break;
            }
            case 6: {
                errtext = "Invalid SMB response received";
                break;
            }
            case 7: {
                errtext = "Large files not supported";
                break;
            }
            case 8: {
                errtext = "Invalid file information for level";
                break;
            }
            case 9: {
                errtext = "Server does not support DCE/RPC requests";
                break;
            }
            case 10: {
                errtext = "Invalid SMB signature received";
            }
        }
        return errtext;
    }

    private static final String NetworkErrorText(int errcode) {
        String errtext = null;
        switch (errcode) {
            case 5: {
                errtext = "Access denied";
                break;
            }
            case 6: {
                errtext = "Invalid handle";
                break;
            }
            case 50: {
                errtext = "Function not supported";
                break;
            }
            case 66: {
                errtext = "Bad device type";
                break;
            }
            case 67: {
                errtext = "Bad network name";
                break;
            }
            case 85: {
                errtext = "Already assigned";
                break;
            }
            case 86: {
                errtext = "Invalid password";
                break;
            }
            case 87: {
                errtext = "Incorrect parameter";
                break;
            }
            case 234: {
                errtext = "Transaction continued ...";
                break;
            }
            case 259: {
                errtext = "No more items";
                break;
            }
            case 487: {
                errtext = "Invalid address";
                break;
            }
            case 1060: {
                errtext = "Service does not exist";
                break;
            }
            case 1200: {
                errtext = "Bad device";
                break;
            }
            case 1203: {
                errtext = "No network or bad path";
                break;
            }
            case 1208: {
                errtext = "Extended error";
                break;
            }
            case 1222: {
                errtext = "No network";
                break;
            }
            case 1223: {
                errtext = "Cancelled";
                break;
            }
            case 2114: {
                errtext = "Server service is not running";
                break;
            }
            case 2123: {
                errtext = "Supplied buffer is too small";
                break;
            }
            case 2141: {
                errtext = "Server is not configured for transactions";
                break;
            }
            case 2150: {
                errtext = "Invalid queue name";
                break;
            }
            case 2151: {
                errtext = "Specified print job could not be located";
                break;
            }
            case 2160: {
                errtext = "Print process is not responding";
                break;
            }
            case 2161: {
                errtext = "Spooler is not started on the remote server";
                break;
            }
            case 2164: {
                errtext = "Operation cannot be performed on the print job in it's current state";
                break;
            }
            case 2212: {
                errtext = "Error occurred running/loading logon script";
                break;
            }
            case 2214: {
                errtext = "Logon was not validated by any server";
                break;
            }
            case 2217: {
                errtext = "Logon server is running old software version, cannot validate logon";
                break;
            }
            case 2221: {
                errtext = "User name was not found";
                break;
            }
            case 2240: {
                errtext = "User is not allowed to logon from this computer";
                break;
            }
            case 2241: {
                errtext = "USer is not allowed to logon at this time";
                break;
            }
            case 2242: {
                errtext = "User password has expired";
                break;
            }
            case 2243: {
                errtext = "Password cannot be changed";
                break;
            }
            case 2246: {
                errtext = "Password is too short";
            }
        }
        return errtext;
    }

    private static final String ServerErrorText(int errcode) {
        String errtext = null;
        switch (errcode) {
            case 1: {
                errtext = "Non-specific error";
                break;
            }
            case 2: {
                errtext = "Bad password";
                break;
            }
            case 4: {
                errtext = "Client does not have access rights";
                break;
            }
            case 5: {
                errtext = "Invalid TID";
                break;
            }
            case 6: {
                errtext = "Invalid network name";
                break;
            }
            case 7: {
                errtext = "Invalid device";
                break;
            }
            case 49: {
                errtext = "Print queue full (files)";
                break;
            }
            case 50: {
                errtext = "Print queue full (space)";
                break;
            }
            case 51: {
                errtext = "EOF on print queue dump";
                break;
            }
            case 52: {
                errtext = "Invalid print file FID";
                break;
            }
            case 64: {
                errtext = "Server did not recognize the command received";
                break;
            }
            case 65: {
                errtext = "Internal server error";
                break;
            }
            case 67: {
                errtext = "FID and pathname combination invalid";
                break;
            }
            case 69: {
                errtext = "Invalid access permission";
                break;
            }
            case 71: {
                errtext = "Invalid attribute mode";
                break;
            }
            case 81: {
                errtext = "Server is paused";
                break;
            }
            case 82: {
                errtext = "Not receiving messages";
                break;
            }
            case 83: {
                errtext = "No room to buffer message";
                break;
            }
            case 87: {
                errtext = "Too many remote user names";
                break;
            }
            case 88: {
                errtext = "Operation timed out";
                break;
            }
            case 89: {
                errtext = "No resources available for request";
                break;
            }
            case 90: {
                errtext = "Too many UIDs active on session";
                break;
            }
            case 91: {
                errtext = "Invalid UID";
                break;
            }
            case 250: {
                errtext = "Unable to support RAW, use MPX";
                break;
            }
            case 251: {
                errtext = "Unable to support RAW, use standard read/write";
                break;
            }
            case 252: {
                errtext = "Continue in MPX mode";
                break;
            }
            case 65535: {
                errtext = "Function not supported";
            }
        }
        return errtext;
    }

    private static final String NTErrorText(int errcode) {
        String errtext = "";
        switch (errcode) {
            case 0: {
                errtext = "The request was successful";
                break;
            }
            case -1073741790: {
                errtext = "Access denied";
                break;
            }
            case -1073741772: {
                errtext = "Object not found";
                break;
            }
            case 6: {
                errtext = "Invalid handle";
                break;
            }
            case 66: {
                errtext = "Bad device type";
                break;
            }
            case 67: {
                errtext = "Bad network name";
                break;
            }
            case 85: {
                errtext = "Already assigned";
                break;
            }
            case 86: {
                errtext = "Invalid password";
                break;
            }
            case -1073741811: {
                errtext = "Invalid parameter";
                break;
            }
            case 234: {
                errtext = "More data available";
                break;
            }
            case 259: {
                errtext = "No more items";
                break;
            }
            case 487: {
                errtext = "Invalid address";
                break;
            }
            case 1060: {
                errtext = "Service does not exist";
                break;
            }
            case 1200: {
                errtext = "Bad device";
                break;
            }
            case 1203: {
                errtext = "No network or bad path";
                break;
            }
            case 1208: {
                errtext = "Extended error";
                break;
            }
            case 1222: {
                errtext = "No network";
                break;
            }
            case -1073741536: {
                errtext = "Cancelled";
                break;
            }
            case -2147483643: {
                errtext = "Buffer overflow";
                break;
            }
            case -1073741809: {
                errtext = "No such file";
                break;
            }
            case -1073741703: {
                errtext = "Invalid security descriptor";
                break;
            }
            case -1073741802: {
                errtext = "More processing required";
                break;
            }
            case -1073741637: {
                errtext = "Not supported";
                break;
            }
            case -1073741621: {
                errtext = "Bad device type";
                break;
            }
            case -1073741766: {
                errtext = "Object path not found";
                break;
            }
            case -1073741715: {
                errtext = "Logon failure";
                break;
            }
            case -1073741710: {
                errtext = "Account disabled";
                break;
            }
            case -1073741709: {
                errtext = "None mapped";
                break;
            }
            case -1073741821: {
                errtext = "Invalid information class";
                break;
            }
            case -1073741771: {
                errtext = "Object name collision";
                break;
            }
            case -1073741822: {
                errtext = "Not implemented";
                break;
            }
            case -1073741209: {
                errtext = "File is offline";
                break;
            }
            case -1073741757: {
                errtext = "Sharing violation";
                break;
            }
            case -1073741620: {
                errtext = "Bad network name";
                break;
            }
            case -1073741618: {
                errtext = "Too many sessions/virtual circuits";
                break;
            }
            case -1073741789: {
                errtext = "Buffer too small";
                break;
            }
            case -1073741740: {
                errtext = "Lock conflict";
                break;
            }
            case -1073741739: {
                errtext = "Lock not granted";
                break;
            }
            case -1073741698: {
                errtext = "Range not locked";
                break;
            }
            case -1073741697: {
                errtext = "Disk full";
                break;
            }
            case -1073741537: {
                errtext = "Too many open files";
                break;
            }
            case -1073741616: {
                errtext = "Request not accepted";
                break;
            }
            case -1073741601: {
                errtext = "No such domain";
                break;
            }
            case -1073741567: {
                errtext = "Directory not empty";
                break;
            }
            case -2147483642: {
                errtext = "No more files";
                break;
            }
            case -1073741773: {
                errtext = "Object name invalid";
                break;
            }
            case -1073741650: {
                errtext = "Pipe is busy";
                break;
            }
            case -1073741788: {
                errtext = "Object type mismatch";
                break;
            }
            case -1073741711: {
                errtext = "Password expired";
                break;
            }
            case -1073741638: {
                errtext = "File is a directory";
                break;
            }
            case -1073741496: {
                errtext = "Invalid information level";
                break;
            }
            case -1073741260: {
                errtext = "Account is locked";
                break;
            }
            case 65538: {
                errtext = "Invalid SMB, or not supported";
                break;
            }
            default: {
                errtext = "Unknown NT status 0x" + Integer.toHexString(errcode);
            }
        }
        return errtext;
    }

    private static final String Win32ErrorText(int errcode) {
        String errtext = "";
        switch (errcode) {
            case 2: {
                errtext = "File not found";
                break;
            }
            case 3: {
                errtext = "Path not found";
                break;
            }
            case 5: {
                errtext = "Access denied";
                break;
            }
            case 6: {
                errtext = "Invalid handle";
                break;
            }
            case 66: {
                errtext = "Bad device type";
                break;
            }
            case 67: {
                errtext = "Bad network name";
                break;
            }
            case 85: {
                errtext = "Already assigned";
                break;
            }
            case 86: {
                errtext = "Invalid password";
                break;
            }
            case 261: {
                errtext = "More entries";
                break;
            }
            case 234: {
                errtext = "More data";
                break;
            }
            case 259: {
                errtext = "No more items";
                break;
            }
            case 487: {
                errtext = "Invalid address";
                break;
            }
            case 1060: {
                errtext = "Service does not exist";
                break;
            }
            case 1072: {
                errtext = "Service marked for delete";
                break;
            }
            case 1073: {
                errtext = "Service already exists";
                break;
            }
            case 1077: {
                errtext = "Duplicate service name";
                break;
            }
            case 1200: {
                errtext = "Bad device";
                break;
            }
            case 1203: {
                errtext = "No network or bad path";
                break;
            }
            case 1208: {
                errtext = "Extended error";
                break;
            }
            case 1222: {
                errtext = "No network";
                break;
            }
            default: {
                errtext = "Unknown Win32 status 0x" + Integer.toHexString(errcode);
            }
        }
        return errtext;
    }

    private static final String DCERPCErrorText(int errcode) {
        if (errcode == 0) {
            return "DCE/RPC Fault";
        }
        return "DCE/RPC Error 0x" + Integer.toHexString(errcode);
    }
}

