/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.server.auth.acl;

import org.alfresco.jlan.server.auth.acl.ACLParseException;
import org.alfresco.jlan.server.auth.acl.AccessControl;
import org.alfresco.jlan.server.auth.acl.AccessControlParser;
import org.alfresco.jlan.server.auth.acl.ProtocolAccessControl;
import org.springframework.extensions.config.ConfigElement;

public class ProtocolAccessControlParser
extends AccessControlParser {
    @Override
    public String getType() {
        return "protocol";
    }

    @Override
    public AccessControl createAccessControl(ConfigElement params) throws ACLParseException {
        int access = this.parseAccessType(params);
        String val = params.getAttribute("type");
        if (val == null || val.length() == 0) {
            throw new ACLParseException("Protocol type not specified");
        }
        String protList = val.trim();
        if (protList.length() == 0) {
            throw new ACLParseException("Protocol type not valid");
        }
        if (!ProtocolAccessControl.validateProtocolList(protList)) {
            throw new ACLParseException("Invalid protocol type");
        }
        return new ProtocolAccessControl(protList, this.getType(), access);
    }
}

