/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.server.auth;

import java.net.InetAddress;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Random;
import org.alfresco.jlan.debug.Debug;
import org.alfresco.jlan.server.SrvSession;
import org.alfresco.jlan.server.auth.AuthContext;
import org.alfresco.jlan.server.auth.AuthenticatorException;
import org.alfresco.jlan.server.auth.ChallengeAuthContext;
import org.alfresco.jlan.server.auth.ClientInfo;
import org.alfresco.jlan.server.auth.ICifsAuthenticator;
import org.alfresco.jlan.server.auth.NTLanManAuthContext;
import org.alfresco.jlan.server.auth.PasswordEncryptor;
import org.alfresco.jlan.server.auth.UserAccount;
import org.alfresco.jlan.server.auth.passthru.DomainMapping;
import org.alfresco.jlan.server.config.InvalidConfigurationException;
import org.alfresco.jlan.server.config.SecurityConfigSection;
import org.alfresco.jlan.server.config.ServerConfiguration;
import org.alfresco.jlan.server.config.ServerConfigurationAccessor;
import org.alfresco.jlan.server.core.NoPooledMemoryException;
import org.alfresco.jlan.server.core.SharedDevice;
import org.alfresco.jlan.smb.DialectSelector;
import org.alfresco.jlan.smb.server.CIFSConfigSection;
import org.alfresco.jlan.smb.server.SMBSrvException;
import org.alfresco.jlan.smb.server.SMBSrvPacket;
import org.alfresco.jlan.smb.server.SMBSrvSession;
import org.alfresco.jlan.smb.server.VirtualCircuit;
import org.alfresco.jlan.util.DataPacker;
import org.alfresco.jlan.util.HexDump;
import org.alfresco.jlan.util.IPAddress;
import org.springframework.extensions.config.ConfigElement;

public abstract class CifsAuthenticator
implements ICifsAuthenticator {
    protected static final String GUEST_USERNAME = "guest";
    private DialectSelector m_dialects;
    private int m_securityMode = 3;
    private PasswordEncryptor m_encryptor = new PasswordEncryptor();
    private int m_accessMode = 0;
    private boolean m_extendedSecurity;
    private boolean m_allowGuest;
    private boolean m_mapToGuest;
    private String m_guestUserName = "guest";
    protected Random m_random = new Random(System.currentTimeMillis());
    protected ServerConfigurationAccessor m_config;
    private boolean m_debug;

    public void setDebug(boolean debug) {
        this.m_debug = debug;
    }

    public void setConfig(ServerConfigurationAccessor config) {
        this.m_config = config;
    }

    @Override
    public int authenticateShareConnect(ClientInfo client, SharedDevice share, String sharePwd, SrvSession sess) {
        return 2;
    }

    @Override
    public int authenticateUser(ClientInfo client, SrvSession sess, int alg) {
        UserAccount userAcc = this.getUserDetails(client.getUserName());
        if (userAcc != null) {
            boolean authSts = false;
            if (client.getPassword() != null) {
                authSts = this.validatePassword(userAcc, client, sess.getAuthenticationContext(), alg);
            } else if (client.hasANSIPassword()) {
                authSts = this.validatePassword(userAcc, client, sess.getAuthenticationContext(), 0);
            }
            return authSts ? 0 : -2;
        }
        if (client.isNullSession() && sess instanceof SMBSrvSession) {
            return 0;
        }
        return this.allowGuest() ? 0x10000000 : -1;
    }

    public final int authenticateUserPlainText(ClientInfo client, SrvSession sess) {
        String textPwd;
        NTLanManAuthContext authCtx = (NTLanManAuthContext)sess.getAuthenticationContext();
        if (authCtx == null) {
            authCtx = new NTLanManAuthContext();
            sess.setAuthenticationContext(authCtx);
        }
        if ((textPwd = client.getPasswordAsString()) == null) {
            textPwd = client.getANSIPasswordAsString();
        }
        byte[] encPwd = this.generateEncryptedPassword(textPwd, authCtx.getChallenge(), 1, client.getUserName(), client.getDomain());
        client.setPassword(encPwd);
        return this.authenticateUser(client, sess, 1);
    }

    public void initialize() throws InvalidConfigurationException {
        if (this.m_config == null) {
            throw new InvalidConfigurationException("server configuration accessor not set");
        }
        this.m_dialects = new DialectSelector();
        this.m_dialects.AddDialect(2);
        this.m_dialects.AddDialect(4);
        this.m_dialects.AddDialect(3);
        this.m_dialects.AddDialect(5);
        this.m_dialects.AddDialect(6);
        this.m_dialects.AddDialect(7);
    }

    public void initialize(ServerConfiguration config, ConfigElement params) throws InvalidConfigurationException {
        if (params.getChild("Debug") != null) {
            this.setDebug(true);
        }
        this.setConfig(config);
        this.initialize();
    }

    protected final byte[] generateEncryptedPassword(String plainPwd, byte[] encryptKey, int alg, String userName, String domain) {
        byte[] encPwd = null;
        try {
            encPwd = this.m_encryptor.generateEncryptedPassword(plainPwd, encryptKey, alg, userName, domain);
        }
        catch (NoSuchAlgorithmException ex) {
        }
        catch (InvalidKeyException ex) {
            // empty catch block
        }
        return encPwd;
    }

    @Override
    public final int getAccessMode() {
        return this.m_accessMode;
    }

    @Override
    public final boolean hasExtendedSecurity() {
        return this.m_extendedSecurity;
    }

    public AuthContext getAuthContext(SMBSrvSession sess) {
        AuthContext authCtx = null;
        if (sess.hasAuthenticationContext() && sess.getAuthenticationContext() instanceof NTLanManAuthContext) {
            authCtx = sess.getAuthenticationContext();
        } else {
            authCtx = new NTLanManAuthContext();
            sess.setAuthenticationContext(authCtx);
        }
        return authCtx;
    }

    public final DialectSelector getEnabledDialects() {
        return this.m_dialects;
    }

    @Override
    public final int getSecurityMode() {
        return this.m_securityMode;
    }

    public final CIFSConfigSection getCIFSConfig() {
        return (CIFSConfigSection)this.m_config.getConfigSection("CIFS");
    }

    public final SecurityConfigSection getsecurityConfig() {
        return (SecurityConfigSection)this.m_config.getConfigSection("Security");
    }

    public final boolean hasDebug() {
        return this.m_debug;
    }

    @Override
    public void generateNegotiateResponse(SMBSrvSession sess, SMBSrvPacket respPkt, boolean extendedSecurity) throws AuthenticatorException {
        String domain;
        ChallengeAuthContext authCtx = (ChallengeAuthContext)this.getAuthContext(sess);
        int pos = respPkt.getByteOffset();
        byte[] buf = respPkt.getBuffer();
        if (authCtx == null || authCtx.getChallenge() == null) {
            for (int i = 0; i < 8; ++i) {
                buf[pos++] = 0;
            }
        } else {
            byte[] key = authCtx.getChallenge();
            for (int i = 0; i < key.length; ++i) {
                buf[pos++] = key[i];
            }
        }
        if ((domain = sess.getSMBServer().getCIFSConfiguration().getDomainName()) != null) {
            pos = DataPacker.putString(domain, buf, pos, true, true);
        }
        pos = DataPacker.putString(sess.getSMBServer().getServerName(), buf, pos, true, true);
        respPkt.setByteCount(pos - respPkt.getByteOffset());
    }

    @Override
    public void processSessionSetup(SMBSrvSession sess, SMBSrvPacket reqPkt) throws SMBSrvException {
        VirtualCircuit vc;
        int uid;
        if (!reqPkt.checkPacketIsValid(13, 0)) {
            throw new SMBSrvException(-1073741811, 2, 1);
        }
        int maxBufSize = reqPkt.getParameter(2);
        int maxMpx = reqPkt.getParameter(3);
        int vcNum = reqPkt.getParameter(4);
        int ascPwdLen = reqPkt.getParameter(7);
        int uniPwdLen = reqPkt.getParameter(8);
        int capabs = reqPkt.getParameterLong(11);
        byte[] buf = reqPkt.getBuffer();
        boolean isUni = reqPkt.isUnicode();
        byte[] ascPwd = reqPkt.unpackBytes(ascPwdLen);
        byte[] uniPwd = reqPkt.unpackBytes(uniPwdLen);
        String user = reqPkt.unpackString(isUni);
        if (user == null) {
            throw new SMBSrvException(-1073741811, 2, 1);
        }
        String domain = "";
        if (reqPkt.hasMoreData() && (domain = reqPkt.unpackString(isUni)) == null) {
            throw new SMBSrvException(-1073741811, 2, 1);
        }
        String clientOS = "";
        if (reqPkt.hasMoreData() && (clientOS = reqPkt.unpackString(isUni)) == null) {
            throw new SMBSrvException(-1073741811, 2, 1);
        }
        if (sess.hasDebug(32)) {
            Debug.println("[SMB] NT Session setup from user=" + user + ", password=" + (uniPwd != null ? HexDump.hexString(uniPwd) : "none") + ", ANSIpwd=" + (ascPwd != null ? HexDump.hexString(ascPwd) : "none") + ", domain=" + domain + ", os=" + clientOS + ", VC=" + vcNum + ", maxBuf=" + maxBufSize + ", maxMpx=" + maxMpx + ", authCtx=" + sess.getAuthenticationContext());
            Debug.println("[SMB]  MID=" + reqPkt.getMultiplexId() + ", UID=" + reqPkt.getUserId() + ", PID=" + reqPkt.getProcessId());
        }
        sess.setClientMaximumBufferSize(maxBufSize != 0 ? maxBufSize : 65540);
        sess.setClientMaximumMultiplex(maxMpx);
        sess.setClientCapabilities(capabs);
        ClientInfo client = ClientInfo.getFactory().createInfo(user, uniPwd);
        client.setANSIPassword(ascPwd);
        client.setDomain(domain);
        client.setOperatingSystem(clientOS);
        if (sess.hasRemoteAddress()) {
            client.setClientAddress(sess.getRemoteAddress().getHostAddress());
        }
        if (user.length() == 0 && domain.length() == 0 && uniPwdLen == 0 && ascPwdLen == 1) {
            client.setLogonType(2);
        }
        boolean isGuest = false;
        int sts = this.authenticateUser(client, sess, 1);
        if (sts > 0 && (sts & 0x10000000) != 0) {
            isGuest = true;
            if (sess.hasDebug(32)) {
                Debug.println("[SMB] User " + user + ", logged on as guest");
            }
        } else {
            if (sts != 0) {
                if (sess.hasDebug(32)) {
                    Debug.println("[SMB] User " + user + ", access denied");
                }
                throw new SMBSrvException(-1073741715, 1, 5);
            }
            if (sess.hasDebug(32)) {
                Debug.println("[SMB] User " + user + " logged on " + (client != null ? " (type " + client.getLogonTypeString() + ")" : ""));
            }
        }
        if ((uid = sess.addVirtualCircuit(vc = new VirtualCircuit(vcNum, client))) == -1) {
            if (sess.hasDebug(32)) {
                Debug.println("[SMB] Failed to allocate UID for virtual circuit, " + vc);
            }
            throw new SMBSrvException(-1073741715, 1, 5);
        }
        if (sess.hasDebug(32)) {
            Debug.println("[SMB] Allocated UID=" + uid + " for VC=" + vc);
        }
        if (!client.isNullSession()) {
            client.setGuest(isGuest);
        }
        sess.setLoggedOn(true);
        SMBSrvPacket respPkt = reqPkt;
        if (reqPkt.hasAndXCommand()) {
            try {
                respPkt = sess.getPacketPool().allocatePacket(reqPkt.getLength(), reqPkt);
            }
            catch (NoPooledMemoryException ex) {
                throw new SMBSrvException(2, 83);
            }
        }
        respPkt.setParameterCount(3);
        respPkt.setParameter(0, 0);
        respPkt.setParameter(1, 0);
        respPkt.setParameter(2, isGuest ? 1 : 0);
        respPkt.setByteCount(0);
        respPkt.setTreeId(0);
        respPkt.setUserId(uid);
        int flags = respPkt.getFlags();
        respPkt.setFlags(flags &= 0xFFFFFFF7);
        int flags2 = 1;
        if (isUni) {
            flags2 += 32768;
        }
        if (!this.hasExtendedSecurity()) {
            flags2 &= 0xFFFFF7FF;
        }
        respPkt.setFlags2(flags2);
        int pos = respPkt.getByteOffset();
        buf = respPkt.getBuffer();
        if (isUni) {
            pos = DataPacker.wordAlign(pos);
        }
        pos = DataPacker.putString("Java", buf, pos, true, isUni);
        pos = DataPacker.putString("Alfresco CIFS Server " + sess.getServer().isVersion(), buf, pos, true, isUni);
        pos = DataPacker.putString(sess.getSMBServer().getCIFSConfiguration().getDomainName(), buf, pos, true, isUni);
        respPkt.setByteCount(pos - respPkt.getByteOffset());
        respPkt.setParameter(1, pos - 4);
    }

    @Override
    public int getEncryptionKeyLength() {
        return 8;
    }

    @Override
    public int getServerCapabilities() {
        return 49788;
    }

    public final boolean allowGuest() {
        return this.m_allowGuest;
    }

    public final String getGuestUserName() {
        return this.m_guestUserName;
    }

    public final boolean mapUnknownUserToGuest() {
        return this.m_mapToGuest;
    }

    public final void setAllowGuest(boolean ena) {
        this.m_allowGuest = ena;
    }

    public final void setGuestUserName(String guest) {
        this.m_guestUserName = guest;
    }

    public final void setMapToGuest(boolean ena) {
        this.m_mapToGuest = ena;
    }

    protected final void setSecurityMode(int flg) {
        this.m_securityMode = flg;
    }

    protected final void setExtendedSecurity(boolean extSec) {
        this.m_extendedSecurity = extSec;
    }

    @Override
    public void closeAuthenticator() {
    }

    protected final boolean validatePassword(UserAccount user, ClientInfo client, AuthContext authCtx, int alg) {
        byte[] encryptKey = null;
        if (authCtx == null || !(authCtx instanceof NTLanManAuthContext)) {
            return false;
        }
        NTLanManAuthContext ntlmCtx = (NTLanManAuthContext)authCtx;
        encryptKey = ntlmCtx.getChallenge();
        byte[] encryptedPwd = null;
        encryptedPwd = alg == 0 ? client.getANSIPassword() : client.getPassword();
        byte[] encPwd = null;
        if (user.hasMD4Password() && alg != 0) {
            try {
                if (alg == 1) {
                    byte[] p21 = new byte[21];
                    System.arraycopy(user.getMD4Password(), 0, p21, 0, user.getMD4Password().length);
                    encPwd = this.getEncryptor().doNTLM1Encryption(p21, encryptKey);
                } else if (alg == 2) {
                    encPwd = this.getEncryptor().doNTLM2Encryption(user.getMD4Password(), client.getUserName(), client.getDomain());
                }
            }
            catch (NoSuchAlgorithmException ex) {
            }
            catch (InvalidKeyException ex) {}
        } else {
            encPwd = this.generateEncryptedPassword(user.getPassword() != null ? user.getPassword() : "", encryptKey, alg, client.getUserName(), client.getDomain());
        }
        if (encPwd != null && encryptedPwd != null && encPwd.length == 24 && encryptedPwd.length == 24) {
            for (int i = 0; i < 24; ++i) {
                if (encPwd[i] == encryptedPwd[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    protected final byte[] convertPassword(String pwd) {
        StringBuffer p14str = new StringBuffer();
        p14str.append(pwd);
        if (p14str.length() > 14) {
            p14str.setLength(14);
        } else {
            while (p14str.length() < 14) {
                p14str.append('\u0000');
            }
        }
        return p14str.toString().getBytes();
    }

    protected final PasswordEncryptor getEncryptor() {
        return this.m_encryptor;
    }

    protected final String getStatusAsString(int sts) {
        String str = null;
        switch (sts) {
            case 0: {
                str = "Allow";
                break;
            }
            case -1: {
                str = "Disallow";
                break;
            }
            case 0x10000000: {
                str = "Guest";
                break;
            }
            case -2: {
                str = "BadPassword";
                break;
            }
            case -3: {
                str = "BadUser";
            }
        }
        return str;
    }

    public final void setAccessMode(int mode) {
        this.m_accessMode = mode;
    }

    protected void doGuestLogon(ClientInfo client, SrvSession sess) {
        client.setUserName(this.getGuestUserName());
        client.setGuest(true);
    }

    public final UserAccount getUserDetails(String user) {
        return this.getsecurityConfig().getUsersInterface().getUserAccount(user);
    }

    @Override
    public void setCurrentUser(ClientInfo client) {
    }

    protected final String mapClientAddressToDomain(InetAddress clientIP) {
        SecurityConfigSection securityConfig = this.getsecurityConfig();
        if (!securityConfig.hasDomainMappings()) {
            return null;
        }
        int clientAddr = IPAddress.asInteger(clientIP);
        for (DomainMapping domainMap : securityConfig.getDomainMappings()) {
            if (!domainMap.isMemberOfDomain(clientAddr)) continue;
            if (this.hasDebug()) {
                Debug.println("Mapped client IP " + clientIP + " to domain " + domainMap.getDomain());
            }
            return domainMap.getDomain();
        }
        if (this.hasDebug()) {
            Debug.println("Failed to map client IP " + clientIP + " to a domain");
        }
        return null;
    }

    public String toString() {
        return this.getClass().getName() + ", mode=" + (this.getAccessMode() == 0 ? "SHARE" : "USER");
    }
}

