/*
 * Decompiled with CFR 0.152.
 */
package nu.zoom.catonine.tail;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import nu.zoom.catonine.prefs.Preferences;
import nu.zoom.catonine.tail.AbstractRegularExpressionLogBlockTailer;
import nu.zoom.catonine.tail.Tailer;
import nu.zoom.catonine.tail.TailerListener;
import nu.zoom.swing.desktop.common.BackendException;
import nu.zoom.swing.desktop.preferences.InvalidDataTypeException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FullFileTailer
extends AbstractRegularExpressionLogBlockTailer
implements Tailer {
    private static final int MAX_UNDERFLOW_ERRORS = 10;
    private final Preferences preferences;
    private final Log log = LogFactory.getLog(this.getClass());
    private FileChannel fileChannel = null;
    private File file = null;
    private long lastEntryStartPosition = 0L;
    private long lastReadFileSize = 0L;
    private CharsetDecoder charsetDecoder = null;
    private ByteBuffer fileByteBuffer;
    private CharBuffer charBuffer;
    private int underflowerrorCounter = 10;

    public FullFileTailer(Preferences preferences) {
        this.preferences = preferences;
        this.charsetDecoder = Charset.defaultCharset().newDecoder();
        this.setReadBufferSize(65536);
    }

    @Override
    public synchronized void setReadBufferSize(int size) {
        if (size < 3) {
            throw new IllegalArgumentException("Buffer size may not be less than 3");
        }
        this.log.debug((Object)("Changing Readbuffer size to: " + size));
        this.fileByteBuffer = ByteBuffer.allocate(size);
        this.charBuffer = CharBuffer.allocate(size);
        this.log.trace((Object)"Readbuffer allocated");
    }

    @Override
    public synchronized void setFile(File file) throws IllegalArgumentException, FileNotFoundException, IOException {
        this.file = file;
        FileInputStream fis = new FileInputStream(file);
        this.fileChannel = fis.getChannel();
        this.restart();
    }

    @Override
    public synchronized File getFile() {
        return this.file;
    }

    @Override
    public synchronized String setCharSet(String charsetName) {
        Charset charset;
        if (charsetName == null || !Charset.isSupported(charsetName)) {
            this.log.warn((Object)("Using default charset. Charset named: " + charsetName + " is not supported"));
            charset = Charset.defaultCharset();
        } else {
            charset = Charset.forName(charsetName);
        }
        this.charsetDecoder = charset.newDecoder();
        this.charsetDecoder.onMalformedInput(CodingErrorAction.REPLACE);
        this.log.trace((Object)("Charset changed to: " + charset));
        return charset.displayName();
    }

    private synchronized void resetCounters(long size) {
        this.underflowerrorCounter = 10;
        long offset = 0L;
        try {
            Integer scrollbackSize = this.preferences.getScrollbackSize();
            if (scrollbackSize != null) {
                this.log.debug((Object)"Scrollback enabled");
                offset = Math.max(0L, size - scrollbackSize.longValue() * 1024L * 1024L);
            } else {
                offset = 0L;
            }
        }
        catch (InvalidDataTypeException e) {
            offset = 0L;
            this.log.error((Object)e);
        }
        catch (BackendException e) {
            offset = 0L;
            this.log.error((Object)e);
        }
        this.log.debug((Object)("Setting lastEntryStartPosition & lastReadFileSize to:" + offset));
        this.lastEntryStartPosition = offset;
        this.lastReadFileSize = offset;
    }

    @Override
    protected synchronized void read() throws IOException {
        if (this.fileChannel != null && this.fileChannel.isOpen() && this.fileByteBuffer != null && this.charsetDecoder != null) {
            long size = this.fileChannel.size();
            if (size < this.lastReadFileSize) {
                this.log.debug((Object)"File has been truncated, resetting tailer counters");
                this.resetCounters(size);
                this.fireReset();
            } else if (size > this.lastReadFileSize) {
                this.log.debug((Object)("File has grown from " + this.lastReadFileSize + " to " + size));
                long remainder = 0L;
                LinkedList<TailerListener.LogEntry> entries = new LinkedList<TailerListener.LogEntry>();
                do {
                    this.fileChannel.position(this.lastEntryStartPosition);
                    this.fileByteBuffer.clear();
                    int bytesRead = this.fileChannel.read(this.fileByteBuffer);
                    this.charsetDecoder.reset();
                    this.charBuffer.clear();
                    this.fileByteBuffer.flip();
                    this.decode();
                    this.charBuffer.flip();
                    long filePositionForNextBufferFill = this.convertToLines(entries, this.lastEntryStartPosition);
                    remainder = this.lastEntryStartPosition + (long)bytesRead - filePositionForNextBufferFill;
                    this.lastEntryStartPosition = filePositionForNextBufferFill;
                } while (this.lastEntryStartPosition + remainder < size);
                this.lastReadFileSize = size;
                if (entries.size() > 0) {
                    this.fireLinesRead(entries);
                }
            }
        }
    }

    private long convertToLines(List<TailerListener.LogEntry> lines, long fileoffset) {
        long filePositionForNextBufferFill;
        CharSequence blockSeq;
        Matcher blockMatcher = this.createBlockMatcher();
        blockMatcher.reset(this.charBuffer);
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Breaking buffer into blocks using pattern: " + blockMatcher.pattern().toString()));
        }
        int startOfBlock = 0;
        int endOfBlock = 0;
        boolean blockMatcherStarting = this.isBlockMatcherStarting();
        while (blockMatcher.find()) {
            int n = endOfBlock = blockMatcherStarting ? blockMatcher.start() : blockMatcher.end();
            if (endOfBlock > startOfBlock) {
                blockSeq = this.charBuffer.subSequence(startOfBlock, endOfBlock);
                lines.add(new TailerListener.LogEntry(fileoffset + (long)startOfBlock, ((Object)blockSeq).toString()));
            }
            startOfBlock = endOfBlock;
        }
        int limit = this.fileByteBuffer.limit();
        int capacity = this.fileByteBuffer.capacity();
        if (endOfBlock < limit) {
            blockSeq = this.charBuffer.subSequence(endOfBlock, this.charBuffer.remaining());
            lines.add(new TailerListener.LogEntry(fileoffset + (long)endOfBlock, ((Object)blockSeq).toString()));
            filePositionForNextBufferFill = endOfBlock == 0 ? (limit < capacity ? fileoffset : fileoffset + (long)limit) : fileoffset + (long)endOfBlock;
        } else {
            filePositionForNextBufferFill = fileoffset + (long)endOfBlock;
        }
        return filePositionForNextBufferFill;
    }

    private synchronized void decode() throws IOException {
        CoderResult coderResult = this.charsetDecoder.decode(this.fileByteBuffer, this.charBuffer, true);
        this.logErrors(coderResult);
        if (coderResult.isUnderflow()) {
            coderResult = this.charsetDecoder.flush(this.charBuffer);
            this.logErrors(coderResult);
        } else {
            this.log.error((Object)"Unable to decode file properly, decoder did not return underflow, is the file binary?");
            --this.underflowerrorCounter;
            if (this.underflowerrorCounter < 0) {
                throw new IOException("Too many underflows, unable to decode file. Is this a binary file?");
            }
        }
    }

    private void logErrors(CoderResult coderResult) {
        if (coderResult.isOverflow()) {
            this.log.error((Object)"Buffer overflow, the character buffer is not large enough to decode the characters, some information may be lost");
        } else if (coderResult.isError()) {
            this.log.warn((Object)"There was some error in decoding the file given the current charset");
        }
    }

    @Override
    public void restart() {
        if (this.fileChannel == null) {
            this.log.warn((Object)"Restart called on tailer but no file channel has been set");
            throw new NullPointerException("File channel is null when restart was called");
        }
        try {
            this.resetCounters(this.fileChannel.size());
        }
        catch (IOException ex) {
            this.log.error((Object)ex);
            if (this.fileChannel != null) {
                try {
                    this.fileChannel.close();
                }
                catch (IOException ex1) {
                    this.log.error((Object)ex1);
                }
            }
            this.fileChannel = null;
        }
    }
}

