/*
 * Decompiled with CFR 0.152.
 */
package net.timewalker.ffmq4.spring;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Properties;
import javax.jms.JMSException;
import net.timewalker.ffmq4.FFMQException;
import net.timewalker.ffmq4.FFMQServer;
import net.timewalker.ffmq4.utils.Settings;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FFMQServerBean {
    private static final Log log = LogFactory.getLog(FFMQServerBean.class);
    private String engineName;
    private String configLocation;
    private FFMQServer server;

    public String getEngineName() {
        return this.engineName;
    }

    public void setEngineName(String engineName) {
        this.engineName = engineName;
    }

    public String getConfigLocation() {
        return this.configLocation;
    }

    public void setConfigLocation(String configLocation) {
        this.configLocation = configLocation;
    }

    private void checkProperties() throws JMSException {
        if (this.engineName == null || this.engineName.length() == 0) {
            throw new FFMQException("Bean property 'engineName' is required", "INVALID_BEAN_CONFIG");
        }
        if (this.configLocation == null) {
            throw new FFMQException("Bean property 'configLocation' is required", "INVALID_BEAN_CONFIG");
        }
    }

    private Settings loadConfig() throws JMSException {
        try {
            Properties settings = new Properties();
            if (this.configLocation.startsWith("classpath:")) {
                String resourcePath = this.configLocation.substring(10);
                InputStream in = FFMQServerBean.class.getClassLoader().getResourceAsStream(resourcePath);
                if (in == null) {
                    throw new IllegalArgumentException("Cannot find configuration resource in classpath : " + resourcePath);
                }
                settings.load(in);
                in.close();
            } else {
                File configFile = new File(this.configLocation);
                if (!configFile.canRead()) {
                    throw new IllegalArgumentException("Cannot read configuration file : " + configFile.getAbsolutePath());
                }
                FileInputStream in = new FileInputStream(configFile);
                settings.load(in);
                ((InputStream)in).close();
            }
            return new Settings(settings);
        }
        catch (Exception e) {
            throw new FFMQException("Cannot load engine settings", "INVALID_BEAN_CONFIG", (Throwable)e);
        }
    }

    public void start() throws JMSException {
        if (this.server == null) {
            this.checkProperties();
            log.info((Object)"Starting FFMQServerBean ...");
            Settings settings = this.loadConfig();
            this.server = new FFMQServer(this.engineName, settings);
            this.server.start();
        }
    }

    public void stop() {
        if (this.server != null) {
            this.server.shutdown();
            this.server = null;
        }
    }
}

