/*
 * Decompiled with CFR 0.152.
 */
package net.timewalker.ffmq4;

import java.io.File;
import java.io.FileInputStream;
import java.util.Properties;
import net.timewalker.ffmq4.FFMQServer;
import net.timewalker.ffmq4.logging.Log4JTools;
import net.timewalker.ffmq4.utils.Settings;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class FFMQServerLauncher {
    protected static final Log log = LogFactory.getLog(FFMQServerLauncher.class);
    private static final String DEFAULT_SERVER_CONF_FILE = "conf/ffmq-server.properties";
    private static final int SHUTDOWN_TIMEOUT = 60;

    public static void main(String[] args) {
        try {
            FFMQServerLauncher.setupSystemProperties();
            Settings settings = FFMQServerLauncher.parseCommandLine(args);
            FFMQServer server = new FFMQServer("engine1", settings);
            Runtime.getRuntime().addShutdownHook(new ShutdownHook(server));
            server.run();
            System.exit(0);
        }
        catch (IllegalArgumentException e) {
            System.err.println(e.getMessage());
            System.exit(-1);
        }
        catch (Throwable e) {
            e.printStackTrace();
            System.exit(-2);
        }
    }

    private static void setupSystemProperties() {
        String ffmqBase;
        String ffmqHome = System.getProperty("FFMQ_HOME");
        if (ffmqHome == null) {
            ffmqHome = "..";
            System.setProperty("FFMQ_HOME", ffmqHome);
        }
        if ((ffmqBase = System.getProperty("FFMQ_BASE")) == null) {
            System.setProperty("FFMQ_BASE", ffmqHome);
        }
    }

    private static Settings parseCommandLine(String[] args) {
        String confFilePath = null;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-conf")) {
                if (++i == args.length) {
                    throw new IllegalArgumentException("Missing value after parameter -conf");
                }
            } else {
                throw new IllegalArgumentException("Unknown command-line argument : " + args[i]);
            }
            confFilePath = args[i];
        }
        File confFile = confFilePath != null ? new File(confFilePath) : new File(System.getProperty("FFMQ_BASE"), DEFAULT_SERVER_CONF_FILE);
        if (!confFile.canRead()) {
            throw new IllegalArgumentException("Cannot access config file : " + confFile.getAbsolutePath());
        }
        Properties props = FFMQServerLauncher.loadServerProperties(confFile);
        Log4JTools.initializeLog4J(props);
        return new Settings(props);
    }

    private static Properties loadServerProperties(File configFile) {
        try {
            Properties settings = new Properties();
            FileInputStream in = new FileInputStream(configFile);
            settings.load(in);
            in.close();
            return settings;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Cannot load server settings : " + e);
        }
    }

    private static class ShutdownHook
    extends Thread {
        private FFMQServer server;

        public ShutdownHook(FFMQServer server) {
            this.server = server;
        }

        @Override
        public void run() {
            try {
                if (this.server.isStarted()) {
                    log.info((Object)"Caught signal, asking the server to shutdown");
                    this.server.pleaseStop();
                    long startTime = System.currentTimeMillis();
                    while (this.server.isStarted()) {
                        Thread.sleep(100L);
                        long now = System.currentTimeMillis();
                        if (now - startTime <= 60000L) continue;
                        log.fatal((Object)"Timeout waiting for server shutdown (60s)");
                        return;
                    }
                }
            }
            catch (Throwable e) {
                log.fatal((Object)"Cannot shutdown server", e);
            }
        }
    }
}

