/*
 * Decompiled with CFR 0.152.
 */
package net.sf.webdav.methods;

import java.io.IOException;
import java.util.Hashtable;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.webdav.ITransaction;
import net.sf.webdav.IWebdavStore;
import net.sf.webdav.StoredObject;
import net.sf.webdav.exceptions.AccessDeniedException;
import net.sf.webdav.exceptions.LockFailedException;
import net.sf.webdav.exceptions.WebdavException;
import net.sf.webdav.locking.IResourceLocks;
import net.sf.webdav.locking.LockedObject;
import net.sf.webdav.methods.AbstractMethod;
import net.sf.webdav.methods.DeterminableMethod;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DoMkcol
extends AbstractMethod {
    private static Logger LOG = LoggerFactory.getLogger(DoMkcol.class);
    private IWebdavStore _store;
    private IResourceLocks _resourceLocks;
    private boolean _readOnly;

    public DoMkcol(IWebdavStore store, IResourceLocks resourceLocks, boolean readOnly) {
        this._store = store;
        this._resourceLocks = resourceLocks;
        this._readOnly = readOnly;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(ITransaction transaction, HttpServletRequest req, HttpServletResponse resp) throws IOException, LockFailedException {
        LOG.trace("-- " + this.getClass().getName());
        if (!this._readOnly) {
            String path = this.getRelativePath(req);
            String parentPath = this.getParentPath(this.getCleanPath(path));
            Hashtable<String, Integer> errorList = new Hashtable<String, Integer>();
            if (!this.checkLocks(transaction, req, resp, this._resourceLocks, parentPath)) {
                LOG.trace("MkCol on locked resource (parentPath) not executable!\n Sending SC_FORBIDDEN (403) error response!");
                resp.sendError(403);
                return;
            }
            String tempLockOwner = "doMkcol" + System.currentTimeMillis() + req.toString();
            if (this._resourceLocks.lock(transaction, path, tempLockOwner, false, 0, 10, true)) {
                StoredObject so = null;
                try {
                    StoredObject parentSo = this._store.getStoredObject(transaction, parentPath);
                    if (parentSo == null) {
                        resp.sendError(409);
                        return;
                    }
                    if (parentPath != null && parentSo.isFolder()) {
                        so = this._store.getStoredObject(transaction, path);
                        if (so == null) {
                            this._store.createFolder(transaction, path);
                            resp.setStatus(201);
                        }
                        if (so.isNullResource()) {
                            LockedObject nullResourceLo = this._resourceLocks.getLockedObjectByPath(transaction, path);
                            if (nullResourceLo == null) {
                                resp.sendError(500);
                                return;
                            }
                            String nullResourceLockToken = nullResourceLo.getID();
                            String[] lockTokens = this.getLockIdFromIfHeader(req);
                            String lockToken = null;
                            if (lockTokens == null) {
                                resp.sendError(400);
                                return;
                            }
                            lockToken = lockTokens[0];
                            if (lockToken.equals(nullResourceLockToken)) {
                                so.setNullResource(false);
                                so.setFolder(true);
                                String[] nullResourceLockOwners = nullResourceLo.getOwner();
                                String owner = null;
                                if (nullResourceLockOwners != null) {
                                    owner = nullResourceLockOwners[0];
                                }
                                if (this._resourceLocks.unlock(transaction, lockToken, owner)) {
                                    resp.setStatus(201);
                                }
                                resp.sendError(500);
                            }
                            LOG.trace("MkCol on lock-null-resource with wrong lock-token!\n Sending multistatus error report!");
                            errorList.put(path, 423);
                            this.sendReport(req, resp, errorList);
                        }
                        String methodsAllowed = DeterminableMethod.determineMethodsAllowed(so);
                        resp.addHeader("Allow", methodsAllowed);
                        resp.sendError(405);
                    }
                    if (parentPath != null && parentSo.isResource()) {
                        LOG.trace("MkCol on resource is not executable\n Sending SC_METHOD_NOT_ALLOWED (405) error response!");
                        String methodsAllowed = DeterminableMethod.determineMethodsAllowed(parentSo);
                        resp.addHeader("Allow", methodsAllowed);
                        resp.sendError(405);
                    }
                    resp.sendError(403);
                }
                catch (AccessDeniedException e) {
                    resp.sendError(403);
                }
                catch (WebdavException e) {
                    resp.sendError(500);
                }
                finally {
                    this._resourceLocks.unlockTemporaryLockedObjects(transaction, path, tempLockOwner);
                }
            } else {
                resp.sendError(500);
            }
        } else {
            resp.sendError(403);
        }
    }
}

